<?php

/**
 * The template for displaying product widget entries.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-product.php.
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 15.5.5
 */

if (!defined('ABSPATH')) {
	exit;
}

global $product;

if (!is_a($product, 'WC_Product')) {
	return;
} ?>
<li class="powerhour-top-product-list">

	<?php do_action('woocommerce_widget_product_item_start', $args); ?>

	<?php echo '<div class="powerhour-top-product-img">' . $product->get_image() . '</div>'; ?>

	<div class="powerhour-top-product-wrapper">

		<a href="<?php echo esc_url($product->get_permalink()); ?>">
			<span class="product-title"><?php echo wp_kses($product->get_name() , 'power-hour'); ?></span>
		</a>
		<?php
			// Categories
			$prodcat = get_the_terms($product->get_id(), 'product_cat');
			if (!empty($prodcat)) {
				foreach ($prodcat as $cat) { ?>
					<span class="powerhour-product-category"><a href="<?php echo get_category_link($cat->term_id) ?>"><?php echo esc_html($cat->name); ?></a></span>
				<?php
				}
			} ?>
		<div class="powerhour-product-price">
			<?php echo wp_kses($product->get_price_html(), 'power-hour'); ?>

</div>

<?php do_action('woocommerce_widget_product_item_end', $args); ?>

</div>

</li>