<?php

global $product;
global $post;
$powerhour_option = get_option('power-hour-options');


$product = isset($args['id']) ? wc_get_product($args['id']) :  wc_get_product($post->ID); // condition fro Load Template from Plugin 
if (!$product) {
	return '';
}
$is_quickview = isset($powerhour_option['powerhour_display_product_quickview_icon']) ? $powerhour_option['powerhour_display_product_quickview_icon'] : "yes";
$is_wishlist = isset($powerhour_option['powerhour_display_product_wishlist_icon']) ? $powerhour_option['powerhour_display_product_wishlist_icon'] : "yes";
$is_addtocart = isset($powerhour_option['powerhour_display_product_addtocart_icon']) ? $powerhour_option['powerhour_display_product_addtocart_icon'] : "yes";
$default_title = isset($powerhour_option['powerhour_display_product_name']) ? $powerhour_option['powerhour_display_product_name'] : "yes";
$default_rating = isset($powerhour_option['powerhour_display_product_rating']) ? $powerhour_option['powerhour_display_product_rating'] : "yes";
$default_price = isset($powerhour_option['powerhour_display_price']) ? $powerhour_option['powerhour_display_price'] : "yes";
?>
<div <?php wc_product_class('powerhour-sub-product', $product->get_id()); ?>>
	<div class="powerhour-inner-box ">
		<a href="<?php the_permalink(); ?>"></a>
		<div class="powerhour-product-block">
			<?php
			$newness_days = 30;
			$created = strtotime($product->get_date_created());
			if (!$product->is_in_stock()) {
			?>
				<span class="onsale powerhour-sold-out"><?php echo esc_html__('Sold!', 'power-hour') ?></span>
			<?php } else if ($product->is_on_sale()) { ?>
				<span class="onsale powerhour-on-sale"><?php echo esc_html__('Sale!', 'power-hour') ?></span>
			<?php } else if ((time() - (60 * 60 * 24 * $newness_days)) < $created) { ?>
				<span class="onsale powerhour-new"><?php echo esc_html__('New!', 'power-hour'); ?></span>
			<?php } ?>

			<div class="powerhour-image-wrapper">
				<?php
				if ($product->get_image_id()) {
					$product->get_image('shop_catalog');
					$image = wp_get_attachment_image_src($product->get_image_id(), 'power-hour-product'); ?>
					<a href="<?php echo the_permalink($product->get_id()); ?>" class="powerhour-product-title-link ">
						<?php echo '<span class="powerhour-product-image">' . woocommerce_get_product_thumbnail() . '</span>'; ?>
					</a><?php
					} else { ?>
					<a href="<?php echo the_permalink($product->get_id()); ?>" class="powerhour-product-title-link ">
						<?php
						echo sprintf('<span class="powerhour-product-image"><img src="%s" alt="%s" class="wp-post-image" /></span>', esc_url(wc_placeholder_img_src()), esc_html__('Awaiting product image', 'power-hour')); ?>
					</a><?php
					}
						?>
				<?php
				if ($is_quickview || $is_wishlist || $is_addtocart) { ?>
					<div class="powerhour-woo-buttons-holder">
						<ul> <?php
							if ($is_quickview == "yes") { 
								if (class_exists('WPCleverWoosq')) { ?>
									<li><?php echo do_shortcode('[woosq id="' . $product->get_id() . '"]') ?></li> <?php
								}
							}

							if ($is_wishlist == "yes") {
								if (class_exists('YITH_WCWL')) { ?>
									<li>
										<?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
									</li> <?php
								}
							}

							if ($is_addtocart == "yes" && $product->is_in_stock()) { ?>
								<li>
									<?php if ($product->get_id() && !$product->is_type('grouped')) { ?>
										<a href="<?php echo esc_url($product->add_to_cart_url()); ?>" class=" ajax_add_to_cart add_to_cart_button button powerhour-box-shadow powerhour-morden-btn" data-product_id="<?php echo esc_attr($product->get_id()); ?>" data-product_sku="<?php echo esc_attr($product->get_sku()); ?>" data-product_name="<?php the_title(); ?>">
											<svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M5 7.00009L10 1.00009L15 7.00009" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
												<path d="M19 7.00009L17 15.0001C16.9065 15.5733 16.6552 16.0873 16.2897 16.4528C15.9243 16.8182 15.4679 17.0119 15 17.0001H5C4.53211 17.0119 4.07572 16.8182 3.71028 16.4528C3.34485 16.0873 3.0935 15.5733 3 15.0001L1 7.00009H19Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
											</svg>
										</a>
									<?php } else { ?>
										<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="added_to_cart d-flex align-items-center button iq-product-cart-button" title="<?php echo esc_attr__('View cart', 'power-hour'); ?>">
											<i class="fas fa-check"></i>
										</a>
									<?php } ?>
								</li>
							<?php } ?>
						</ul>
					</div>
				<?php
				}
				?>
			</div>
		</div>
		<div class="product-caption">
			<div class="product-content-wrapper">
				<?php if ($default_title == "yes") {?>
					<h5 class="woocommerce-loop-product__title th13">
						<a href="<?php echo the_permalink($product->get_id()); ?>" class="powerhour-product-title-link ">
							<?php echo esc_html($product->get_name()); ?>
						</a>
					</h5>
				<?php
				} ?>
				<?php if ($default_rating == "yes") {
				?>
					<div class="container-rating">
						<?php
						$rating_count = $product->get_rating_count();
						if ($rating_count >= 0) {
							$average      = $product->get_average_rating();
						?>
							<div class="star-rating">
								<?php echo wc_get_rating_html($average, $rating_count); ?>
							</div>
						<?php }
						?>
					</div>
				<?php } ?>
			</div>
			<?php if ($default_price == "yes") {
			?>
				<div class="price-detail">
					<span class="price">
						<?php echo $product->get_price_html(); ?>
					</span>
				</div>
			<?php } ?>
		</div>
	</div>
</div>