<?php


namespace PowerHour\Utility;

global $product;
global $post;
$powerhour_option = get_option('power-hour-options');
$product = wc_get_product($post->ID);
if (!$product) {
	return '';
}
$default_quickview = isset($powerhour_option['powerhour_display_product_quickview_icon']) ? $powerhour_option['powerhour_display_product_quickview_icon'] : "yes";

?>
<div <?php wc_product_class('powerhour-sub-product', get_the_ID()); ?>>

	<div class="powerhour-inner-box ">
		<a href="<?php the_permalink(); ?>"></a>
		<div class="row">
			<div class="col-md-4">
				<div class="powerhour-product-block">
					<?php
					$newness_days = 30;
					$created = strtotime($product->get_date_created());
					if (!$product->is_in_stock()) {
					?>
						<span class="onsale powerhour-sold-out"><?php echo esc_html__('Sold!', 'power-hour') ?></span>
					<?php } else if ($product->is_on_sale()) { ?>
						<span class="onsale powerhour-on-sale"><?php echo esc_html__('Sale!', 'power-hour') ?></span>
					<?php } else if ((time() - (60 * 60 * 24 * $newness_days)) < $created) { ?>
						<span class="onsale powerhour-new"><?php echo esc_html__('New!', 'power-hour'); ?></span>
					<?php } ?>
					<div class="powerhour-image-wrapper">
						<?php
						if ($product->get_image_id()) {
							$product->get_image('shop_catalog');
							$image = wp_get_attachment_image_src($product->get_image_id(), 'power-hour-product');
						?>
							<a href="<?php echo the_permalink($product->get_id()); ?>" class="powerhour-product-title-link ">
								<?php echo '<span class="powerhour-product-image"> <img src="' . $image['0'] . '" alt="' . esc_attr__('product-image', 'power-hour') . '" class="wp-post-image" /> </span>'; ?>
							</a><?php

							} else {
								?>
							<a href="<?php echo the_permalink($product->get_id()); ?>" class="powerhour-product-title-link ">
								<?php
								echo sprintf('<span class="powerhour-product-image"><img src="%s" alt="%s" class="wp-post-image" /></span>', esc_url(wc_placeholder_img_src()), esc_html__('Awaiting product image', 'power-hour')); ?>
							</a><?php
							} ?>

						<?php
						if ($default_quickview == "yes") { ?>
							<div class="powerhour-woo-buttons-holder">
								<ul>
									<?php
									if (class_exists('WPCleverWoosq')) { ?>
										<li class="quick-view-icon"><?php echo do_shortcode('[woosq id="' . $product->get_id() . '"]') ?></li>
									<?php
									}
									?>
								</ul>
							</div>
						<?php
						}
						?>
					</div>
				</div>
			</div>
			<div class="col-md-8">
				<div class="product-caption">
					<h5 class="woocommerce-loop-product__title th13">
						<a href="<?php echo the_permalink(); ?>" class="powerhour-product-title-link ">
							<?php echo esc_html($product->get_name()); ?>
						</a>
					</h5>

					<div class="price-detail">
						<span class="price">
							<?php echo $product->get_price_html(); ?>
						</span>
					</div>

					<div class="container-rating">
						<?php
						$rating_count = $product->get_rating_count();
						if ($rating_count >= 0) {
							$average      = $product->get_average_rating();
						?>
							<div class="star-rating">
								<?php echo wc_get_rating_html($average, $rating_count); ?>
							</div>
						<?php } ?>
					</div>
					<div class="powerhour-woo-buttons-holder">
						<ul>
							<li>
								<?php
								if ($product->get_id()) {
									if ($product->is_type('variable')) { ?>
										<a href="<?php echo esc_url($product->get_permalink()); ?>" class="powerhour-button btn powerhour-add-to-cart btn  " data-product_id="<?php echo get_the_ID(); ?>" data-product_sku="<?php echo esc_attr($product->get_sku()); ?>" data-product_name="<?php the_title(); ?>">
											<?php echo esc_html__('Select Options', 'power-hour'); ?>
										</a>
									<?php } elseif ($product->is_type('grouped')) { ?>
										<a href="<?php echo esc_url($product->get_permalink()); ?>" class="powerhour-button btn powerhour-add-to-cart btn  " data-product_id="<?php echo get_the_ID(); ?>" data-product_sku="<?php echo esc_attr($product->get_sku()); ?>" data-product_name="<?php the_title(); ?>">
											<?php echo esc_html__('View products', 'power-hour'); ?>
										</a>
									<?php } elseif ($product->is_type('external')) { ?>
										<a rel="nofollow" href="<?php echo esc_url($product->add_to_cart_url()); ?>" class="powerhour-button btn powerhour-add-to-cart btn  " data-quantity="<?php echo esc_attr(isset($quantity) ? $quantity : 1); ?>'" data-product_id="<?php echo get_the_ID(); ?>" data-product_sku="<?php echo esc_attr($product->get_sku()); ?>" target="_blank">
											<?php echo esc_html__('Our Product', 'power-hour'); ?>
										</a>
									<?php } else {	?>
										<a href="<?php echo esc_url($product->add_to_cart_url()); ?>" class="ajax_add_to_cart add_to_cart_button powerhour-button btn powerhour-add-to-cart btn  " data-product_id="<?php echo get_the_ID(); ?>" data-product_sku="<?php echo esc_attr($product->get_sku()); ?>" data-product_name="<?php the_title(); ?>">
											<?php echo esc_html__('Add to Cart', 'power-hour'); ?>
										</a>
									<?php }
								} else { ?>
									<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="added_to_cart powerhour-button btn wc-forward powerhour-button btn powerhour-add-to-cart btn  " title="<?php esc_attr_e('View Cart', 'power-hour') ?>">
										<?php echo esc_html__('View cart', 'power-hour'); ?>
									</a>
								<?php
								}
								?>
							</li>

							<?php
							if (class_exists('YITH_WCWL')) {
							?>
								<li>
									<?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
								</li>

							<?php 	} ?>
						</ul>
					</div>
					<?php
					if (!empty(get_the_excerpt())) {
					?>
						<div class="powerhour-product-description">
							<?php
							the_excerpt();
							?>
						</div>
					<?php
					}
					?>
				</div>
			</div>
		</div>
	</div>
</div>