<?php

/**
 * Template part for displaying the header navigation menu
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

global $powerhour_options;
$default_cart_icon = isset($powerhour_options['display_header_cart_button']) ? $powerhour_options['display_header_cart_button'] : 'yes';
$display_user_icon = isset($powerhour_options['display_user_icon_header']) && $powerhour_options['display_user_icon_header'] == 'yes' ? "yes" : '';

?>

<nav id="site-navigation" class="navbar deafult-header navbar-expand-xl navbar-light p-0" aria-label="<?php esc_attr_e('Main menu', 'power-hour'); ?>" <?php
																																					if (power_hour()->is_amp()) {
																																					?> [class]=" siteNavigationMenu.expanded ? 'main-navigation nav--toggle-sub nav--toggle-small nav--toggled-on' : 'main-navigation nav--toggle-sub nav--toggle-small' " <?php
																																																																														}
																																																																															?>>

	<a class="navbar-brand " href="<?php echo esc_url(home_url('/')); ?>">
		<?php
		if (function_exists('get_field') || class_exists('ReduxFramework')) {
			// $powerhour_options = get_option('power-hour-options');
			$is_yes = function_exists('get_field') ? get_field('acf_key_header_switch') : '';
			$acf_logo = function_exists('get_field') ? get_field('header_logo') : '';

			if ($is_yes === 'yes' && !empty($acf_logo['url'])) {
				$options = $acf_logo['url'];
			} else if (isset($powerhour_options['header_radio'])) {
				if ($powerhour_options['header_radio'] == 1) {
					$logo_text = $powerhour_options['header_text'];
					echo esc_html($logo_text);
				}
				if ($powerhour_options['header_radio'] == 2) {
					$options = $powerhour_options['powerhour_logo']['url'];
				}
			}

			if (isset($options) && !empty($options)) {
				echo '<img class="img-fluid logo" src="' . esc_url($options) . '" alt="' . esc_attr('logo', 'power-hour') . '">';
			}
		} elseif (has_header_image()) {
			$image = wp_get_attachment_image_src(get_theme_mod('custom_logo'), 'full');
			if (has_custom_logo()) {
				echo '<img class="img-fluid logo" src="' . esc_url($image) . '" alt="' . esc_attr('logo', 'power-hour') . '">';
			} else {
				bloginfo('name');
			}
		} else {
			$logo_url = get_template_directory_uri() . '/assets/images/logo.svg';
			echo '<img class="img-fluid logo" src="' . esc_url($logo_url) . '" alt="' . esc_attr('logo', 'power-hour') . '">';
		} ?>
	</a>

	<div id="navbarSupportedContent" class="collapse navbar-collapse new-collapse">
		<div id="powerhour-menu-container" class="menu-all-pages-container">
			<?php
			if (power_hour()->is_primary_nav_menu_active()) {
				power_hour()->display_primary_nav_menu(array(
					'menu_class' 	=> 'sf-menu navbar-nav ml-auto',
					'item_spacing'  => 'discard'
				));
			}
			?>
		</div>
	</div>
	<div class="powerhour-header-right">
		<?php
		$display_search = true;
		if (class_exists('ReduxFramework')) {
			if (isset($powerhour_options['header_display_search']) && $powerhour_options['header_display_search'] == 'yes') {
				$display_search = true;
			} else {
				$display_search = false;
			}
		}
		?>

		<div class="powerhour-shop-btn-holder">
			<ul class="list-inline">
				<?php if (class_exists('WooCommerce')) { ?>
					<?php if ($display_user_icon == "yes") { ?>
						<li class="powerhour-woo-menu-user">
							<?php
							$user_login = false;
							if (is_user_logged_in()) {
								$user_login = true;
							} ?>

							<div class="powerhour-users-settings user-btn powerhour-usermenu-dropdown">
								<a class="dropdown-toggle">
								    <i class="fas fa-user"></i>
								</a> <?php
										if (!$user_login) { ?>
									<div class="powerhour-sub-dropdown powerhour-user-dropdown dropdown-menu">
										<?php
											if (isset($powerhour_options['powerhour_signin_link'])) {
												$powerhour_signin_link = get_page_link($powerhour_options['powerhour_signin_link']);
											} else {
												$powerhour_signin_link = '#';
											}
											if (isset($powerhour_options['powerhour_signin_title'])) {
												$powerhour_signin_title = $powerhour_options['powerhour_signin_title'];
											} ?>

										<a class="powerhour-list-link  powerhour-sub-card" href="<?php echo esc_url($powerhour_signin_link); ?>">
											<div class="media align-items-center">
												<span class="m-0 ">
													<?php if (!empty($powerhour_signin_title)) {
														echo esc_html($powerhour_signin_title);
													} else {
														echo esc_html__('Sign In', 'power-hour');
													}  ?>
												</span>
											</div>
										</a>
										<?php
											if (isset($powerhour_options['powerhour_signup_link'])) {
												$powerhour_signup_link = get_page_link($powerhour_options['powerhour_signup_link']);
											} else {
												$powerhour_signup_link = "#";
											}

											if (isset($powerhour_options['powerhour_signup_title'])) {
												$powerhour_signup_title = $powerhour_options['powerhour_signup_title'];
											} ?>

										<a class="powerhour-list-link  powerhour-sub-card" href="<?php echo esc_url($powerhour_signup_link); ?>">
											<div class="media align-items-center">
												<span class="m-0 ">
													<?php if (!empty($powerhour_signup_title)) {
														echo esc_html($powerhour_signup_title);
													} else {
														echo esc_html__('Sign Up', 'power-hour');
													}  ?>
												</span>
											</div>
										</a>
									</div>
								<?php
										} else {
											if (isset($powerhour_options['powerhour_profile_link']) && !empty($powerhour_options['powerhour_profile_link'])) {
												$powerhour_profile_link = get_page_link($powerhour_options['powerhour_profile_link']);
											} else {
												$powerhour_profile_link =  get_permalink(get_option('woocommerce_myaccount_page_id'));
											} ?>
									<div class="powerhour-sub-dropdown powerhour-user-dropdown dropdown-menu">
										<?php
											$powerhour_myaccount_title = $powerhour_options['powerhour_profile_title'];  ?>
										<a class="powerhour-list-link  powerhour-sub-card" href="<?php echo esc_url($powerhour_profile_link); ?>">
											<div class="media align-items-center">
												<span class="m-0 ">
													<?php if (!empty($powerhour_options['powerhour_profile_title'])) {
														echo esc_html($powerhour_options['powerhour_profile_title']);
													} else {
														echo esc_html__('My Account', 'power-hour');
													}  ?>
												</span>
											</div>
										</a>

										<a class="powerhour-list-link  powerhour-sub-card" href="<?php echo wp_logout_url(home_url()); ?>" id="btn-button2">
											<div class="media align-items-center">
												<span class="m-0 ">
													<?php if (!empty($powerhour_options['powerhour_logout_title'])) {
														echo esc_html($powerhour_options['powerhour_logout_title']);
													} else {
														echo esc_html__('Logout', 'power-hour');
													}  ?>
												</span>
											</div>
										</a>
									</div>
								<?php
										}
								?>
							</div>

						</li>
					<?php } ?>

					<?php if ($default_cart_icon == 'yes') { ?>
						<li class="cart-btn">
							<div class="cart_count">
								<div class="powerhour-cart dropdown-hover">
									<a href="javascript:void(0);" class="dropdown-cart">
									    <i class="fas fa-shopping-cart"></i>
										<div class="basket-item-count">
											<span class="cart-items-count count mini-cart-count">
												<?php echo (WC()->cart) ? WC()->cart->get_cart_contents_count() : ''; ?>
											</span>
										</div>
									</a>

									<?php
									remove_all_actions('powerhour_add_extra_footer');
									add_action('powerhour_add_extra_footer', function () { ?>
										<div class="dropdown-menu-mini-cart ">
											<div class="powerhour-menu-header">
												<h5 class="cart-header"><?php esc_html_e('Shopping Cart ', 'power-hour'); ?> (<span class="powerhour-cart-count"><?php echo  WC()->cart->get_cart_contents_count()  ?></span>)</h5>
												<a href="javascript:void(0);" class="dropdown-close">
													<i class="fas fa-times"></i>
												</a>
											</div>
											<div class="widget_shopping_cart_content ">
												<?php
												if (function_exists("woocommerce_mini_cart") &&  WC()->cart) {
													woocommerce_mini_cart();
												}
												?>
											</div>
										</div>
									<?php
									}); ?>
								</div>
							</div>
						</li>
					<?php } ?>
				<?php } ?>

				<?php if ($display_search) { ?>
					<li>
						<div class="search_count">
							<a href="javascript:void(0);" id="btn-search">
								<i class="fa fa-search"></i>
								<?php
									if (!empty($powerhour_options['header_search_text'])){?>
								    <span class="search-text ml-2">
										<?php echo esc_html($powerhour_options['header_search_text']);
									}
									?>
								</span>
							</a>
							<div class="search">
								<button id="btn-search-close" class="btn btn--search-close" aria-label="Close search form">
									<i class="fa fa-times"></i>
								</button>
								<?php get_search_form(); ?>
							</div>
						</div>
					</li> <?php
				} ?>
		</div> <?php
				?>
		<?php if (power_hour()->is_primary_nav_menu_active()) { ?>
			<button class="navbar-toggler custom-toggler ham-toggle" type="button">
				<span class="menu-btn d-inline-block" id="menu-btn">
					<span class="line one"></span>
					<span class="line two"></span>
					<span class="line three"></span>
				</span>
			</button>
		<?php } ?>
	</div>
</nav><!-- #site-navigation -->