<?php

/**
 * Template part for displaying the header navigation menu
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

$powerhour_options = get_option('power-hour-options');
?>
<div class="container-fluid">
	<div class="row align-items-center">
		<div class="col-sm-12">
			<nav class="powerhour-menu-wrapper mobile-menu">
				<div class="navbar">

					<a class="navbar-brand " href="<?php echo esc_url(home_url('/')); ?>">
						<?php
						if (function_exists('get_field') || class_exists('ReduxFramework')) {
							$powerhour_options = get_option('power-hour-options');
							$is_yes = function_exists('get_field') ? get_field('acf_key_header_switch') : '';
							$acf_logo = function_exists('get_field') ? get_field('header_logo') : '';

							if ($is_yes === 'yes' && !empty($acf_logo['url'])) {
								$options = $acf_logo['url'];
							} else if (isset($powerhour_options['header_radio'])) {
								if ($powerhour_options['header_radio'] == 1) {
									$logo_text = $powerhour_options['header_text'];
									echo esc_html($logo_text);
								}
								if ($powerhour_options['header_radio'] == 2) {
									$options = $powerhour_options['powerhour_mobile_logo']['url'];
								}
							}

							if (isset($options) && !empty($options)) {
								echo '<img class="img-fluid logo" src="' . esc_url($options) . '" alt="' . esc_attr('logo', 'power-hour') . '">';
							}
						} elseif (has_header_image()) {
							$image = wp_get_attachment_image_src(get_theme_mod('custom_logo'), 'full');
							if (has_custom_logo()) {
								echo '<img class="img-fluid logo" src="' . esc_url($image) . '" alt="' . esc_attr('logo', 'power-hour') . '">';
							} else {
								bloginfo('name');
							}
						} else {
							$logo_url = get_template_directory_uri() . '/assets/images/logo-white.svg';
							echo '<img class="img-fluid logo" src="' . esc_url($logo_url) . '" alt="' . esc_attr('logo', 'power-hour') . '">';
						} ?>
					</a>
					<?Php if (power_hour()->is_primary_nav_menu_active()) { ?>
						<button class="navbar-toggler custom-toggler ham-toggle" type="button">
							<span class="menu-btn d-inline-block" id="menu-btn">
								<span class="line one"></span>
								<span class="line two"></span>
								<span class="line three"></span>
							</span>
						</button>
					<?php } ?>
				</div>

				<div class="c-collapse">
					<div class="menu-new-wrapper row align-items-center">
						<div class="menu-scrollbar verticle-mn yScroller col-lg-12">
							<div class="powerhour-full-menu">
								<?php
								if (power_hour()->is_primary_nav_menu_active()) {
									power_hour()->display_primary_nav_menu(array('menu_id' => 'top-menu', 'menu_class' => 'navbar-nav',));
								}
								?>
							</div>
						</div>
					</div>
				</div>
			</nav><!-- #site-navigation -->
		</div>
	</div>
</div>