<?php

/**
 * Template part for displaying the footer info
 *
 * @package power_hour
 */

namespace PowerHour\Utility;
$year = date('Y');

if (class_exists('ReduxFramework')) {

	$powerhour_options = get_option('power-hour-options');
?>
	<div class="copyright-footer">
		<div class="container">
			<div class="row">
				<?php if ($powerhour_options['display_copyright'] == 'yes') {  ?>
					<div class="col-sm-12 m-0 text-<?php echo esc_attr($powerhour_options['footer_copyright_align']); ?>">
						<div class="pt-3 pb-3">
							<?php
							if (isset($powerhour_options['footer_copyright'])) {  ?>
								<span class="copyright">
									<?php
									$copyright = str_replace("{{year}}", $year, $powerhour_options['footer_copyright']);
									echo html_entity_decode($copyright);
									?>
								</span>
							<?php
							} else {	?>
								<span class="copyright"><a target="_blank" rel="nofollow" href="<?php echo esc_url(__('https://themeforest.net/user/iqonicthemes/portfolio/', 'power-hour')); ?>"> <?php printf(esc_html__('© 2025', 'power-hour'), 'power-hour'); ?><strong><?php printf(esc_html__(' power-hour ', 'power-hour'), 'power-hour'); ?></strong><?php printf(esc_html__('. All Rights Reserved.', 'power-hour'), 'power-hour'); ?></a></span>
							<?php
							} ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	</div><!-- .site-info -->

<?php } else { ?>

	<div class="copyright-footer">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<div class="pt-3 pb-3">
						<span class="copyright">
							<?php echo esc_html__("© $year", 'power-hour'); ?>
							<strong><?php printf(esc_html__(' Powerhour ', 'power-hour'), 'power-hour'); ?></strong>
							<?php printf(esc_html__('. All Rights Reserved.', 'power-hour'), 'power-hour'); ?></span>
					</div>
				</div>
			</div>
		</div>
	</div><!-- .site-info -->
<?php }
