<?php
/**
 * Template part for displaying the page header of the currently displayed page
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

if ( is_404() ) {
	?>
	<header class="page-header">
		<h3 class="page-title">
			<?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'power-hour' ); ?>
		</h3>
	</header><!-- .page-header -->
	<?php
} elseif ( is_home() && ! have_posts() ) {
	?>
	<header class="page-header">
		<h3 class="page-title">
			<?php esc_html_e( 'Nothing Found', 'power-hour' ); ?>
		</h3>
	</header><!-- .page-header -->
	<?php
} elseif ( is_home() && ! is_front_page() ) {
	?>
	<header class="page-header">
		<h3 class="page-title">
			<?php single_post_title(); ?>
		</h3>
	</header><!-- .page-header -->
	<?php
} elseif ( is_search() ) {
	?>
	<header class="page-header">
		<h3 class="page-title">
			<?php
			printf(
				/* translators: %s: search query */
				esc_html__( 'Search Results for: %s', 'power-hour' ),
				'<span>' . get_search_query() . '</span>'
			);
			?>
		</h3>
</header><!-- .page-header -->
	<?php
} elseif ( is_archive() ) {
	?>
	<header class="page-header">
		<?php
		the_archive_title( '<h3 class="page-title">', '</h3>' );
		the_archive_description( '<div class="archive-description">', '</div>' );
		?>
	</header><!-- .page-header -->
	<?php
}
