<?php

/**
 * Template part for displaying a post's taxonomy terms
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

$taxonomies = wp_list_filter(
	get_object_taxonomies($post, 'objects'),
	array(
		'public' => true,
	)
);
$post_tag = get_the_tags();
if ($post_tag) {
?>
	<ul class="powerhour-blogtag list-inline">
		<li class="powerhour-label"><?php esc_html_e("Tags:", "power-hour") ?></li>
		<?php foreach ($post_tag as $cat) { ?>
			<li>
				<a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
			</li>
		<?php } ?>
	</ul>
<?php } ?>