<?php
/**
 * Template part for displaying a post's content
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

?>

	<?php
	if (is_single()) {
		the_content();
	} else {
		the_excerpt();
	}

	if (is_single()) { 

		$post_slug = '';
		$post_tag = get_the_tags();
		if ($post_tag) { 
			   ?>
			<ul class="powerhour-blogtag list-unstyled"> 
			    <li class="powerhour-comment-count">
		              <?php
					$comments_number = get_comments_number();
					echo esc_html($comments_number);
					if ($comments_number == 1) {
						esc_html_e(' Comment', 'power-hour');
					} else {
						esc_html_e(' Comments', 'power-hour');
					}
		               ?>
	            </li> 
				   <?php 
				foreach ($post_tag as $cat) { ?>
					<li><a href="<?php get_category_link($cat->cat_ID) ?>"><?php echo esc_html($cat->name); ?></a></li> <?php 
				} ?>
			</ul>
		      <?php 
		} 
		  ?>
		
		<!--   .navigation -->
		<?php 
		$prev_post = get_previous_post();
		$next_post = get_next_post();

		//   -----------Previous post----------
		if ( ! empty( $prev_post ) ): ?>
			<a class="blogdetail-prev-btn" href="<?php echo get_permalink( $prev_post->ID ); ?>">
				<svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
				    <path d="M2.42249 8.15674V11.4263H20.7507V8.15674H2.42249Z" fill="#222222"/>
				    <path d="M11.1515 16.8491L4.63528 9.79116L11.1494 2.73326L8.78609 0.503418L1.23916 8.67733C0.656973 9.30509 0.656973 10.2794 1.23916 10.9072L8.78609 19.0811L11.1515 16.8491Z" fill="#222222"/>
				</svg>
			</a>
		   <?php 
		endif; 

		//   -----------Next Post----------
		if ( ! empty( $next_post ) ): ?>
			<a class="blogdetail-next-btn" href="<?php echo get_permalink( $next_post->ID ); ?>">
				<svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
				    <path d="M18.5775 8.15674V11.4263L0.249262 11.4263V8.15674L18.5775 8.15674Z" fill="#222222"/>
				    <path d="M9.84852 16.8491L16.3647 9.79116L9.85067 2.73326L12.2139 0.503418L19.7609 8.67733C20.3431 9.30509 20.3431 10.2794 19.7609 10.9072L12.2139 19.0811L9.84852 16.8491Z" fill="#222222"/>
				</svg>
			</a>
		    <?php 
		endif; ?>
		   <?php 
	} 
	  ?>
</div><!-- .entry-content -->
