<?php

/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

use WP_Query;

use function Patchwork\Config\get;

$powerhour_options = get_option('power-hour-options');
$post_section = power_hour()->post_style();
$powerhour_icon =  get_field('key_pjros1245');

get_header();
?>
<div class="site-content-contain">
   <div id="content" class="site-content">
      <div id="primary" class="content-area">
         <main id="main" class="site-main">
            <div class = "container powerhour-Team-detail">
               <div class="powerhour-info <?php echo esc_attr($post_section['row_reverse']); ?>"> <?php
                  if (have_posts()) {      
                     while (have_posts()) {
                        the_post();
                        $powerhour_key = '';
                        if(function_exists('get_field')){
                           $powerhour_key = get_field('iqonic_team_detail');
                        } ?>
                        <div class="row powerhour-info align-items-center"> 
                           <div class="col-lg-6 col-12 text-center">
                              <?php the_post_thumbnail(); ?>
                           </div>
                           <div class="col-lg-6 col-12">
                              <div class="powerhour_designation">
                                 <?php echo get_field('iqonic_team_designation'); ?>
                              </div>
                              <div class="powerhour-team-info-title">
                                 <h2 class="title">
                                    <span><?php the_title(); ?></span>
                                 </h2> 
                              </div>
                              <div class="info share">
                                 <span> <?php
                                    $powerhour_facebook  = $powerhour_icon['iqonic_team_facebook'];
                                    $powerhour_twitter  = $powerhour_icon['iqonic_team_twitter'];
                                    $powerhour_google  = $powerhour_icon['iqonic_team_google'];
                                    $powerhour_github  = $powerhour_icon['iqonic_team_github'];
                                    $powerhour_insta  = $powerhour_icon['iqonic_team_insta'];

                                    if(!empty($powerhour_facebook)) { ?>
                                       <a href="<?php echo esc_url($powerhour_facebook); ?>">
                                          <i class="fab fa-facebook" aria-hidden="true"></i>
                                       </a> <?php
                                    }
                                    if(!empty($powerhour_twitter)) { ?>
                                       <a href="<?php echo esc_url($powerhour_twitter); ?>">
                                          <i class="fab fa-twitter" aria-hidden="true"></i>
                                       </a> <?php
                                    } 
                                    if(!empty($powerhour_google)) { ?>
                                       <a href="<?php echo esc_url($powerhour_google); ?>">
                                          <i class="fab fa-google" aria-hidden="true"></i>
                                       </a> <?php
                                    } 
                                    if(!empty($powerhour_github)) { ?>
                                       <a href="<?php echo esc_url($powerhour_github); ?>">
                                          <i class="fab fa-github" aria-hidden="true"></i>
                                       </a> <?php
                                    }
                                    if(!empty($powerhour_insta)) { ?>
                                       <a href="<?php echo esc_url($powerhour_insta); ?>">
                                          <i class="fab fa-instagram" aria-hidden="true"></i>
                                       </a> <?php
                                    } ?>
                                 </span>
                              </div>
                                 <?php
                              the_content();
                              printf($powerhour_key);
                                ?>
                           </div>
                        </div>  <?php
                     }
                  } ?>
               </div>
            </div>
         </main>
      </div>
   </div>
</div>
<?php
get_footer();
