<?php

/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package power_hour
 */

namespace PowerHour\Utility;
$powerhour_options = get_option('power-hour-options');
$is_sidebar = power_hour()->is_primary_sidebar_active();
$post_section = power_hour()->post_style();
get_header();
$powerhour_layout = '';
if (isset($powerhour_options['service_page'])) {
	$powerhour_layout = $powerhour_options['service_page'];
}
?>
<div class="site-content-contain">
   <div id="content" class="site-content">
      <div id="primary" class="content-area">
         <main id="main" class="site-main">
            <div class = "container powerhour-Service-detail">
               <div class="powerhour-info row <?php echo esc_attr($post_section['row_reverse']); ?>"> <?php
               if ($is_sidebar) {
                  echo '<div class="col-xl-8 col-sm-12 powerhour-blog-main-list">';
               } else if ($powerhour_layout != '2' && $powerhour_layout != '3') {
                  echo '<div class="col-lg-12 col-sm-12 powerhour-blog-main-list">';
               }
                  if (have_posts()) {      

                     while (have_posts()) {
                        
                        the_post();
                        ?>
                       
                        <div class="row powerhour-info"> 
                           <!-- Image -->
                           <div class="col-lg-12 col-12">
                              <div class="service-img">
                                 <?php if(!empty(the_post_thumbnail())) { the_post_thumbnail(); } ?>
                              </div>
                           </div>

                           <div class="col-lg-12 col-12">
                              <div class="service-content">
                                 
                                 <div class="powerhour-service-title">
                                    <!-- Title -->
                                    <h3 class="title">
                                       <?php $title = get_the_title(); 
                                       $service = explode(' ',$title);
                                       $title = ''; 
                                    
                                       foreach($service as $word){
                                          if($word == end($service)){
                                             $title .= " " . "<span class='highlighted-text-wrap'><span class='highlighted-text'>".$word."</span></span>";
                                          } else {
                                             $title .= " ".$word;
                                          }
                                       } 
                                       echo wp_kses_post($title);
                                          ?>
                                    </h3> 
                                 </div>
                                  <!-- short description -->
                                 <div class="powerhour-service-sort_desc">
                                    <?php echo get_field('field_service_short_desc'); ?>
                                 </div>
                                 <!-- Service Content -->
                                 <div class="service">
                                    <div class="row">                             
                                       <div class="col-12">
                                          <div class="info share">
                                             <?php the_content(); ?>
                                          </div>
                                       </div>
                                    </div>                       
                                 </div>
                              </div>
                           </div>
                        </div> <?php
                     }
                  } ?>
                  <?php if ($is_sidebar || $powerhour_layout != '2' && $powerhour_layout != '3') {
							echo '</div>';
						}
						get_sidebar(); ?>
               </div>
            </div>
         </main>
      </div>
   </div>
</div>
<?php
get_footer();
