<?php

namespace PowerHour\Utility;

$selected_portfolio = [];
if ('portfolio' == get_post_type()) {
    $selected_portfolio = get_post(get_the_ID());
} else {
    $selected_portfolio = !empty($settings['selected_portfolio']) ? get_page_by_path($settings['selected_portfolio'], OBJECT, 'portfolio') : '';
}
$categories = wp_get_post_terms($selected_portfolio->ID, "portfolio_categories");
$tags = wp_get_post_terms($selected_portfolio->ID, "portfolio_tags");
get_header();

?>
<div class="site-content-contain">
    <div id="content" class="site-content">
        <div id="primary" class="content-area">
            <main id="main" class="site-main">
                <div class="container">
                    <div class="powerhour-portfolio-detail"> <?php
                                                                if (have_posts()) {
                                                                    while (have_posts()) { ?>
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="powerhour-portfolio-detail-content"> <?php
                                                                                            the_post(); ?>
                                            <div class="featured-image"> <?php
                                                                            if (has_post_thumbnail()) {
                                                                                the_post_thumbnail();
                                                                            } ?>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="row">
                                            <div class="col-xl-8">
                                                <div class="powerhour-portfolio-member-content powerhour-title-box powerhour-title-box-1">
                                                    <div class="title">
                                                        <h3 class="portfolio-member-title powerhour-title powerhour-heading-title"><?php the_title(); ?></h3>
                                                    </div>

                                                    <div class="content">
                                                        <?php the_excerpt(); ?>
                                                    </div>


                                                </div>
                                            </div>

                                            <div class="col-xl-4">

                                                <div class="meta-container">
                                                    <div class="single-porfolio-category">
                                                        <span class="label"><?php esc_html_e('Author :', 'power-hour'); ?> </span>
                                                        <?php the_author(); ?>
                                                    </div>
                                                    <?php

                                                                        if (!empty($categories)) { ?>
                                                        <div class="single-porfolio-category">
                                                            <span class="label"><?php esc_html_e('Category :', 'power-hour'); ?> </span>
                                                            <?php
                                                                            foreach ($categories as $category) {
                                                                                echo "<a href='" . esc_url(get_term_link($category->term_id)) . "'><span class='label-category'>$category->name</span></a>";
                                                                            }
                                                            ?>
                                                        </div>
                                                    <?php }

                                                                        if (!empty($tags)) { ?>
                                                        <div class="single-porfolio-tags">
                                                            <span class="label"><?php esc_html_e('Tags :', 'power-hour'); ?> </span>
                                                            <?php
                                                                            foreach ($tags as $tag) {
                                                                                echo "<a href='" . esc_url(get_term_link($tag->term_id)) . "'><span class='label-tag'>$tag->name</span></a>";
                                                                            }
                                                            ?>
                                                        </div>
                                                    <?php } ?>

                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>

                                <div>
                                    <?php the_content(); ?>
                                </div>
                        <?php }
                              } ?>
                    </div>
                </div>
            </main>
        </div>
    </div>
</div>
<?php
get_footer();
