<?php
/**
 * Template Name: Creative Post Template
 * Template Post Type: post
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage powerhour
 * @since 1.0
 * @version 1.0
 */
namespace PowerHour\Utility;

get_header(); 

$powerhour_options = get_option('power-hour-options');
$post_section = power_hour()->post_style();
$powerhour_layout = '';
if (isset($powerhour_options['blog_setting'])) {
    $powerhour_layout = $powerhour_options['blog_setting'];
}
?>
<div class="site-content-contain creative-post-template blog-widget">
    <div id="content" class="site-content">
        <div id="primary" class="content-area">
            <main id="main" class="site-main">
                <div class="container">
                    <div class="row <?php echo esc_attr($post_section['row_reverse']); ?>">
                        <?php
                        if (have_posts()) {

                            while (have_posts()) { ?>
                                <?php
                                the_post();
                                get_template_part('template-parts/content/entry_creative_post', get_post_type(), $post_section['post']);
                            }
                            if (!is_singular()) {
                                if (isset($powerhour_options['display_pagination'])) {
                                    $options = $powerhour_options['display_pagination'];
                                    if ($options == "yes") {
                                        get_template_part('template-parts/content/pagination');
                                    }
                                } else {
                                    get_template_part('template-parts/content/pagination');
                                }
                            }
                        } else {
                            get_template_part('template-parts/content/error');
                        }
                        ?>
                    </div>
                </div>
            </main><!-- #primary -->
        </div>
    </div>
</div>
<?php get_footer();