<?php

namespace PowerHour\Utility;

/**
 * Template Name: Sidebar Stack
 * Template Post Type: portfolio
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @since 1.0
 * @version 1.0
 */

power_hour()->powerhour_singleportfolio();
power_hour()->powerhour_scrollsticky();

get_header();
$gallery_image_ids =  get_post_meta(get_the_ID(), "iqonic_gallery_selected_images", true);
$gallery_image_ids = !empty($gallery_image_ids) ? explode(",", trim($gallery_image_ids, ",")) : '';
$categories = wp_get_post_terms(get_the_ID(), "portfolio_categories");

?>
<div id="primary" class="content-area">
    <main id="main" class="site-main">
        <div class="container powerhour-container-fluid">
            <div class="row">
                <div class="single-portfolio-widget sidebar-stack">
                    <div class="row m-0 ">
                        <div class="col-lg-8">
                            <div class="row m-0">
                                <?php
                                foreach ($gallery_image_ids as $id) {
                                    $thumb_img_src_full = wp_get_attachment_image_src($id, "full");
                                    $thumb_img_src_full = $thumb_img_src_full ? $thumb_img_src_full[0] : '#';
                                    $srcset = wp_get_attachment_image_srcset($id);
                                ?>
                                    <div class="col-lg-12 pdetail-5 centered-img">
                                        <a href="<?php echo esc_url($thumb_img_src_full); ?>">
                                            <?php echo wp_get_attachment_image($id, "power-hour-600x573 portfolio-image", false, ['srcset' => $srcset]); ?>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="sticky-sidebar">
                                <div class="portfolio-detail-main wow">
                                    <div class="portfolio-info-main">
                                        <h3 class="portfolio-title">
                                            <?php echo get_the_title(); ?>
                                        </h3>
                                        <p class="powerhour-desc">
                                            <?php
                                            echo get_the_excerpt();
                                            ?>
                                            <br>
                                            <br>
                                        </p>
                                    </div>
                                </div>
                                <!-- meta title end -->
                                <div class="meta-container">

                                    <div class="single-porfolio-category">
                                        <span class="label">
                                            <?php esc_html_e('Client Name :', 'power-hour'); ?></span>
                                        <span class="client-name">
                                            <?php
                                            $key = get_field('key_pjros12gdfgd', get_the_ID());
                                            echo esc_html($key['iqonic_portfolio_client']);
                                            ?></span>
                                    </div>

                                    <div class="single-porfolio-category">
                                        <span class="label"><?php esc_html_e('Category :', 'power-hour'); ?> </span>
                                        <?php
                                        if ($categories) {
                                            foreach ($categories as $category) {
                                                if (!empty($category->name)) {
                                                    echo "<a href='" . get_term_link($category->term_id) . "'><span class='label-category'>$category->name</span></a>";
                                                }
                                            }
                                        }
                                        ?>
                                    </div>
                                    <div class="single-porfolio-category">
                                        <span class="label"><?php esc_html_e('Date :', 'power-hour'); ?></span>
                                        <?php power_hour()->iqonic_blog_portfolio_time_link(); ?>
                                    </div>

                                    <div class="single-porfolio-category">
                                        <span class="label"><?php esc_html_e('Address :', 'power-hour'); ?></span>
                                        <span class="label-address">
                                            <?php
                                            $key = get_field('key_pjros12gdfgd', get_the_ID());
                                            echo esc_html($key['iqonic_portfolio_address']);
                                            ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
</div><!-- #primary -->
</main><!-- #main -->
</div><!-- .container -->


<?php get_footer();
