<?php

namespace PowerHour\Utility;

/**
 * Template Name: Sidebar Masonry
 * Template Post Type: portfolio
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @since 1.0
 * @version 1.0
 */

power_hour()->powerhour_single_portfolio();
get_header();
$gallery_image_ids =  get_post_meta(get_the_ID(), "iqonic_gallery_selected_images", true);
$gallery_image_ids = !empty($gallery_image_ids) ? explode(",", trim($gallery_image_ids, ",")) : '';
$categories = wp_get_post_terms(get_the_ID(), "portfolio_categories");

?>
<div id="primary" class="content-area">
    <main id="main" class="site-main">
        <div class="container powerhour-container-fluid">
            <div class="row sidebar-masonry">
                <div class="col-lg-12">
                    <div class="iqonic-masonry-block iqonic-metro-block">
                        <div class="iqonic-masonry-grid style-two ">
                            <div class=" grid-sizer"></div>
                            <?php
                            $iqonic_masonary = 1;


                            foreach ($gallery_image_ids as $img) :

                                if ($iqonic_masonary === 1 || $iqonic_masonary === 6) {
                                    $iqonic_grid = "iqonic-masonry-item s-25 landscape";
                                    if (!empty($img)) {
                                        $full_image = wp_get_attachment_image_src($img, "power-hour-full-landscape");
                                    }
                                } else {
                                    $iqonic_grid = "iqonic-masonry-item s-25 portrait";
                                    if (!empty($img)) {
                                        $full_image = wp_get_attachment_image_src($img, "power-hour-min-portrait");
                                    }
                                }

                                $image_url = '';
                                if (isset($full_image[0])) {
                                    $image_url = $full_image[0];
                                }
                            ?>
                                <div class="<?php echo esc_html($iqonic_grid); ?>">
                                    <div class="box">
                                        <a class="iq-image-popup" href="<?php echo esc_url($image_url); ?>" title="images">
                                            <img src="<?php echo esc_url($image_url); ?>" alt="image" />
                                        </a>
                                        <div class="inner">
                                        </div>
                                    </div>
                                </div>
                            <?php


                                $iqonic_masonary++;
                            endforeach;  ?>
                        </div>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="portfolio-detail-main wow">
                        <div class="portfolio-info-main">
                            <h3 class="portfolio-title">
                                <?php echo get_the_title(); ?>
                            </h3>
                            <p class="powerhour-desc">
                                <?php
                                echo get_the_excerpt();
                                ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <!-- meta title end -->
                    <div class="meta-container">

                        <div class="single-porfolio-category">
                            <span class="label">
                                <?php esc_html_e('Client Name :', 'power-hour'); ?></span>
                            <span class="client-name">
                                <?php
                                $key = get_field('key_pjros12gdfgd', get_the_ID());
                                echo esc_html($key['iqonic_portfolio_client']);
                                ?></span>
                        </div>

                        <div class="single-porfolio-category">
                            <span class="label"><?php esc_html_e('Category :', 'power-hour'); ?> </span>
                            <?php
                            if (!empty($categories)) {
                                foreach ($categories as $category) {
                                    if (!empty($category->name)) {
                                        echo "<a href='" . get_term_link($category->term_id) . "'><span class='label-category'>$category->name</span></a>";
                                    }
                                }
                            }
                            ?>
                        </div>
                        <div class="single-porfolio-category">
                            <span class="label"><?php esc_html_e('Date :', 'power-hour'); ?></span>
                            <?php
                            echo sprintf("%s", iqonic_blog_time_link());
                            ?>
                        </div>
                        <div class="single-porfolio-category">
                            <span class="label"><?php esc_html_e('Address :', 'power-hour'); ?></span>
                            <span class="label-address">
                                <?php
                                $key = get_field('key_pjros12gdfgd', get_the_ID());
                                echo esc_html($key['iqonic_portfolio_address']);
                                ?></span>
                        </div>
                    </div>
                </div>
            </div>

        </div><!-- #primary -->
    </main><!-- #main -->
</div><!-- .container -->


<?php get_footer();
