<?php

namespace PowerHour\Utility;

/**
 * Template Name: Masonry
 * Template Post Type: portfolio
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @since 1.0
 * @version 1.0
 */

power_hour()->powerhour_singleportfolio();
power_hour()->powerhour_masonary();

get_header();
$gallery_image_ids =  get_post_meta(get_the_ID(), "iqonic_gallery_selected_images", true);
$gallery_image_ids = !empty($gallery_image_ids) ? explode(",", trim($gallery_image_ids, ",")) : '';
$categories = wp_get_post_terms(get_the_ID(), "portfolio_categories");
?>

<div id="primary" class="content-area">
    <main id="main" class="site-main">
        <div class="container powerhour-container-fluid sidebar-masonry single-portfolio-widget">
            <div class="row mt-0">
                <div class="col-lg-12">
                    <div class="iqonic-masonry-block iqonic-metro-block">
                        <div class="iqonic-masonry-grid masonary" data-horizontalorder="false" data-gutter="0">
                            <div class=" grid-sizer"></div>

                            <?php
                            $loop = array('powerhour-one', 'powerhour-two', 'powerhour-three', 'powerhour-four', 'powerhour-five', 'powerhour-six', 'powerhour-seven');
                            $i = 0;
                            if (!empty($gallery_image_ids)) {
                                foreach ($gallery_image_ids as $id) {
                                    $class = $loop[$i++ % 7];
                                    if ($class == 'powerhour-two' || $class == 'powerhour-seven') {
                                        $full_image = wp_get_attachment_image_src($id, "power-hour-square");
                                    } else {
                                        $full_image = wp_get_attachment_image_src($id, "power-hour-portrait");
                                    }

                                    $image_url = '';
                                    if (!empty($full_image[0])) {
                                        $image_url = $full_image[0];
                                    }
                                      ?>
                            
                                    <div class="iqonic-masonry-item s-25 square">
                                        <div class="iqonic-portfolio-box">
                                            <?php if (!empty($image_url)) : ?>
                                                <img class="portfolio-image" src="<?php echo esc_url($image_url); ?>" alt="image" />
                                            <?php endif; ?>
                                            <div class="iqonic-port-overlay">
                                                <div class="portfolio-content">
                                                    <?php
                                                    if (!empty($image_html)) {
                                                        echo esc_url($image_html);
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                     <?php
                                        } 
                                    } ?>
                        </div>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="portfolio-detail-main wow">
                        <div class="portfolio-info-main">
                            <h3 class="portfolio-title">
                                <?php echo get_the_title(); ?>
                            </h3>
                            <p class="powerhour-desc">
                                <?php
                                echo get_the_excerpt();
                                ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <!-- meta title end -->
                    <div class="meta-container">
                        <div class="single-porfolio-category">
                            <span class="label">
                                <?php esc_html_e('Client Name :', 'power-hour'); ?></span>
                            <span class="client-name">
                                <?php
                                $key = get_field('key_pjros12gdfgd', get_the_ID());
                                echo esc_html($key['iqonic_portfolio_client']);
                                ?></span>
                        </div>

                        <div class="single-porfolio-category">
                            <span class="label"><?php esc_html_e('Category :', 'power-hour'); ?> </span>
                            <?php
                            if (!empty($categories)) {
                                foreach ($categories as $category) {
                                    if (!empty($category->name)) {
                                        echo "<a href='" . get_term_link($category->term_id) . "'><span class='label-category'>$category->name</span></a>";
                                    }
                                }
                            }
                            ?>
                        </div>
                        <div class="single-porfolio-category">
                                    <span class="label"><?php esc_html_e('Date :', 'power-hour'); ?></span>
                                  <?php power_hour()->iqonic_blog_portfolio_time_link();?>
                                </div>
                        <div class="single-porfolio-category">
                            <span class="label"><?php esc_html_e('Address :', 'power-hour'); ?></span>
                            <span class="label-address">
                                <?php
                                $key = get_field('key_pjros12gdfgd', get_the_ID());
                                echo esc_html($key['iqonic_portfolio_address']);
                                ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- #primary -->
    </main><!-- #main -->
</div><!-- .container -->


<?php get_footer();
