<?php
function powerhour_import_files()
{
    return array(
        array(
            'import_file_name'             => esc_html__('All Content', 'power-hour'),
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit(get_template_directory()) . 'inc/Import/Demo/powerhour_redux.json',
                    'option_name' => 'power-hour-options',
                ),
            ),
            'local_import_file'            => trailingslashit(get_template_directory()) . 'inc/Import/Demo/powerhour-content.xml',
            'local_import_widget_file'     => trailingslashit(get_template_directory()) . 'inc/Import/Demo/powerhour-widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/Import/Demo/powerhour-export.dat',

            'import_preview_image_url'     => get_template_directory_uri() . '/screenshot.png',
            'import_notice' => esc_html__('DEMO IMPORT REQUIREMENTS: Memory Limit of 128 MB and max execution time (php time limit) of 300 seconds. ', 'power-hour') . '</br></br>' . esc_html__('Based on your INTERNET SPEED it could take 5 to 25 minutes. ', 'power-hour'),
            'preview_url'                  => 'https://powerhour-wordpress.iqonic.design/',
        ),
    );
}
add_filter('pt-ocdi/import_files', 'powerhour_import_files');

function powerhour_after_import_setup($selected_import)
{
    global $wp_filesystem;

    // Assign menus to their locations.
    $locations = get_theme_mod('nav_menu_locations'); // registered menu locations in theme
    $menus = wp_get_nav_menus(); // registered menus

    if ($menus) {
        foreach ($menus as $menu) { // assign menus to theme locations

            if ($menu->name == 'Menu 1') {
                $locations['primary'] = $menu->term_id;
            }
        }
    }
    set_theme_mod('nav_menu_locations', $locations); // set menus to locations 

    if ('All Content' === $selected_import['import_file_name']) {

        $front_page_id = get_page_by_title('Mental Health');
        $blog_page_id  = get_page_by_title('Blog');

        update_option('show_on_front', 'page');
        update_option('page_on_front', $front_page_id->ID);
        update_option('page_for_posts', $blog_page_id->ID);
    }

    $enable_edit_with_elementor = [
        "post",
        "page",
        "team",
        "service",
        "testimonial",
        "iqonic_hf_layout"
    ];
    update_option('elementor_cpt_support', $enable_edit_with_elementor);

    // icon issue
    add_option('elementor_experiment-e_font_icon_svg', 'inactive');

    // Set Quick View Default value 
    update_option('woosq_button_type', 'link');
    update_option('woosq_button_position', '0');

    // yith wishlist
		update_option('yith_wcwl_button_position','shortcode');
        update_option('yith_wcwl_add_to_wishlist_text', '');
        update_option('yith_wcwl_add_to_cart_text', '');
        update_option('yith_wcwl_browse_wishlist_text', '');

    //change woocommerce default shop page
    $id = get_page_by_path('shop-2');
    if ($id) {
        $id = $id->ID;
        update_option('woocommerce_shop_page_id', $id);
    }

    // save woof setting


    $woof_setting_file =  trailingslashit(get_template_directory()) . 'inc/Import/Demo/powerhour_woof_settings.json';
    if (file_exists($woof_setting_file)) {
        $content =  $wp_filesystem->get_contents($woof_setting_file);
        if (!empty($content)) {
            $woof_options = json_decode($content, true);
            foreach ($woof_options as $option_name => $option_data) {
                if (is_serialized($option_data)) {
                    $option_data = unserialize($option_data);
                }
                update_option($option_name, $option_data);
            }
        }
    }

    // remove default post
    wp_delete_post(1, true);
}
add_action('pt-ocdi/after_import', 'powerhour_after_import_setup');
