<?php

/**
 * PowerHour\Utility\Woocommerce\Component class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Woocommerce;

use PowerHour\Utility\Component_Interface;
use PowerHour\Utility\Templating_Component_Interface;
use function add_action;
use function PowerHour\Utility\power_hour;

/**
 * Class for managing Woocommerce UI.
 *
 * Exposes template tags:
 * * `power_hour()->the_comments( array $args = array() )`
 *
 * @link https://wordpress.org/plugins/amp/
 */
class Component implements Component_Interface, Templating_Component_Interface
{
	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Woocommerce slug.
	 */

	public $powerhour_option;

	public $user_is_view_grid;
	public $user_is_col_no;
	

	public function get_slug(): string
	{
		return 'woocommerce';
	}
	function __construct()
	{
		add_filter('woocommerce_gallery_thumbnail_size', function ($size) {
			return array(300, 300);
		});

		$this->powerhour_option = get_option('power-hour-options');
		add_filter('woof_sort_terms_before_out', array($this, 'powerhour_woof_hide_zero_term'));
	}

	/**
	 * Adds the action and filter hooks to integrate with WordPress.
	 */

	public function initialize()
	{
		add_filter("woof_products_query", function ($query) {
			$_SESSION['powerhour_woof_query_ajax'] = $query;
			return $query;
		});

		add_filter('woocommerce_show_page_title', '__return_false');
		remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
		add_action('woocommerce_before_shop_loop_item_title', array($this, 'powerhour_loop_product_thumbnail'), 10);

		remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);

		// WooCommerce Checkout Fields Hook
		add_filter('woocommerce_checkout_fields',  array($this, 'custom_wc_checkout_fields'));

		//woo edit billing adress field from my account
		add_filter( 'woocommerce_billing_fields', array($this, 'powerhour_edit_billing_fields'),10,1 );

		// Single
		remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
		add_action('woocommerce_single_product_summary',  array($this, 'woocommerce_my_single_title'), 5);
		add_action('after_setup_theme', array($this, 'powerhour_add_woocommerce_support'));
		remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
		remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10,0);
		remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

		add_action('woocommerce_before_main_content', array($this, 'powerhour_woocommerce_output_content_wrapper_start'));
		add_action('woocommerce_after_main_content', array($this, 'powerhour_woocommerce_output_content_wrapper_end'));

		// Remove add to cart
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');
		remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 20);

		// Remove product title
		remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);

		// Remove product price
		remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);

		add_filter('get_the_archive_title', array($this, 'powerhour_product_archive_title'));

		/* Rating Create For Product Loop */
		remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);

		add_filter('woocommerce_add_to_cart_fragments', array($this, 'powerhour_refresh_mini_cart_count'));

		remove_action('woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_button_view_cart', 10);
		remove_action('woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_proceed_to_checkout', 20);
		add_action('woocommerce_widget_shopping_cart_buttons', array($this, 'custom_widget_cart_btn_view_cart'), 21);
		add_action('woocommerce_widget_shopping_cart_buttons', array($this, 'custom_widget_cart_checkout'), 12);

		add_filter('woocommerce_sale_flash', array($this, 'lw_hide_sale_flash'));

		/* products loop_columns */
		add_filter('loop_shop_columns', array($this, 'powerhour_loop_columns'), 21);

		/* wishlist title hide */
		add_filter('yith_wcwl_wishlist_params', array($this, 'powerhour_wishlist_remove_title'), 10, 3);

		/* hide terms and conditions toggle */
		add_action('wp_enqueue_scripts', array($this, 'powerhour_disable_terms'), 1000);

		/* woocommerce redirection after login registration */
		add_filter('woocommerce_registration_redirect', array($this, 'powerhour_after_login_registration'), 10, 1);
		add_filter('woocommerce_login_redirect', array($this, 'powerhour_after_login_registration'), 10, 1);
		add_filter('wc_get_template_part', array($this, 'powerhour_wc_template_part'), 10, 3);

		// add_filter('woocommerce_privacy_policy_page_id',array($this, 'powerhour_privacy_policy_page_id'), 10, 1);

		add_filter('loop_shop_per_page', array($this, 'powerhour_product_perpage'), 99999);

		add_action('woocommerce_before_checkout_form', array($this, 'powerhour_woocomerce_page_header'), -999);
		add_action('woocommerce_before_cart', array($this, 'powerhour_woocomerce_page_header'));
		add_action('powerhour_order_summary_before', array($this, 'powerhour_woocomerce_page_header'));

		add_filter('woocommerce_get_script_data', function ($params) {
			if (isset($params['i18n_view_cart'])) {
				$params['i18n_view_cart'] = '<span>' . $params['i18n_view_cart'] . '</span>';
			}
			return $params;
		});
		add_action('woocommerce_after_main_content', array($this, 'powerhour_woo_notice_massage'),99);

		add_filter('woocommerce_quantity_input_args', array($this,'cart_min_quantity'),10,2);

		if (has_filter('woocommerce_checkout_update_order_review_expired', true)) {
			add_filter('woocommerce_update_order_review_fragments', function ($ar) {
				$ar['form.woocommerce-checkout'] = "<div clas='woocommerce-notices-wrapper'>" . $ar['form.woocommerce-checkout'] . '</div>';
				return $ar;
			});
		}
	}

	public function template_tags(): array
	{
		return array(
			'get_single_product_dependent_script' 	=> array($this, 'get_single_product_dependent_script'),
			'powerhour_load_woocomerce_script' 	=> array($this, 'powerhour_load_woocomerce_script'),
			'powerhour_ajax_product_load_scripts' 	=> array($this, 'powerhour_ajax_product_load_scripts'),
			'powerhour_mini_cart_content' 			=> array($this, 'powerhour_mini_cart_content'),
		);
	}

	public function powerhour_mini_cart_content() {
		global $powerhour_options;
		if($powerhour_options['display_header_cart_button'] == 'yes') { ?>
			<div class="dropdown-menu-mini-cart">
				<div class="powerhour-menu-header">
					<h5 class="cart-header"><?php esc_html_e('Shopping Cart ', 'power-hour'); ?> (<span class="powerhour-cart-count"><?php echo  WC()->cart->get_cart_contents_count()  ?></span>)</h5>
					<a href="javascript:void(0);" class="dropdown-close">
						<i class="fas fa-times"></i>
					</a>
				</div>
				<div class="2 widget_shopping_cart_content">
					<?php
					if (function_exists("woocommerce_mini_cart") &&  WC()->cart) {
						woocommerce_mini_cart();
					}
					?>
				</div>
			</div>
		<?php }
	}


	public function powerhour_load_woocomerce_script()
	{
		wp_enqueue_script("woocomerce-product-dependency", get_template_directory_uri() . '/assets/js/woocommerce.min.js',  array('jquery'), "1.0.0", true);
	}
	public function powerhour_ajax_product_load_scripts(){
		wp_enqueue_script("woocomerce-product-loadmore", get_template_directory_uri() . '/assets/js/ajax-product-load.min.js',  array('jquery'), "1.0.0", true);
	}
	public function powerhour_woo_notice_massage()
	{
?>
		<div class="powerhour-modal css-prefix-model-woo">
			<div class="modal fade" id="<?php echo esc_attr('woo-modal'); ?>" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
					<div class="modal-content">
						<div class="modal-body">
							<p class="powerhour-model-text">

							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
		<script type="text/javascript">
			jQuery(function(jQuery) {
				// On "added_to_cart" live event
				jQuery(document.body).on('added_to_cart', function(a, b, c, d) {
					let prod_name = '“'+d.data('product_name') + '”  has been added to your cart'; // Get the product name
					let notice_model = new bootstrap.Modal(document.querySelector('.css-prefix-model-woo>.modal'));
					jQuery('.css-prefix-model-woo .modal .powerhour-model-text').html(prod_name);
					notice_model.show();
				});
			});
		</script>
	<?php
	}

	public function powerhour_yith_wcwl_dequeue_font_awesome_styles()
	{
		wp_deregister_style('yith-wcwl-font-awesome');
	}

	public function powerhour_privacy_policy_page_id() {
		$page = get_page_by_path('privacy-policy');
		if($page) {
			return $page->ID;
		}
		return '';
	}

	public function get_single_product_dependent_script()
	{
		wp_enqueue_style('swiper-bundle', get_template_directory_uri() . '/assets/css/vendor/swiper-bundle.min.css', array(), '1.0', "all");
		wp_enqueue_script('swiper-bundle', get_template_directory_uri() . '/assets/js/vendor/swiper-bundle.min.js', array(), '1.0', true);
		wp_enqueue_script('products-swiper', get_template_directory_uri() . '/assets/js/products-swiper.min.js', array(), '1.0', true);
	}

	/**
	 * Gets template tags to expose as methods on the Template_Tags class instance, accessible through `power_hour()`.
	 *
	 * @return array Associative array of $method_name => $callback_info pairs. Each $callback_info must either be
	 *               a callable or an array with key 'callable'. This approach is used to reserve the possibility of
	 *               adding support for further arguments in the future.
	 */

	public function lw_hide_sale_flash()
	{
		return false;
	}

	function powerhour_product_archive_title($title)
	{
		if (is_post_type_archive('product')) $title = esc_html__("Shop", 'power-hour');
		return $title;
	}

	function powerhour_add_woocommerce_support()
	{
		add_theme_support('woocommerce');
		add_theme_support('wc-product-gallery-zoom');
		add_theme_support('wc-product-gallery-lightbox');
		add_theme_support('wc-product-gallery-slider');
		// Declare WooCommerce support.
	}

	// overwrite existing output content wrapper function
	function powerhour_woocommerce_output_content_wrapper_start()
	{
		if (is_singular()) {
			echo '<div class="container">
						<div class="row" >
							<div class="col-sm-12" >';
		}
	}

	function powerhour_woocommerce_output_content_wrapper_end()
	{
		if (is_singular()) {
			echo '</div><!-- Col -->
						</div><!-- Close Row -->
					</div><!-- Close Container -->
				';
		}
		echo '</main>';
		echo '</div>';
	}

	function woocommerce_my_single_title()
	{
	?>
		<h3 class="product_title entry-title">
			<span class="powerhour-product-title">
				<?php echo the_title() ?>
			</span>
		</h3>
		<?php
	}

	function powerhour_loop_product_thumbnail($args = array())
	{
		$powerhour_option = get_option('power-hour-options');

		if (is_shop() && (isset($powerhour_option['woocommerce_shop']) && $powerhour_option['woocommerce_shop'] == '1')  ||   $this->user_is_view_grid === '0') {
			get_template_part('template-parts/wocommerce/entry', 'listing');
		} else {
			get_template_part('template-parts/wocommerce/entry');
		}
	}

	// Change the format of fields with type, label, placeholder, class, required, clear, label_class, options
	function custom_wc_checkout_fields($fields)
	{
		//BILLING
		$fields['billing']['billing_first_name']['label'] = false;
		$fields['billing']['billing_first_name']['placeholder'] = "First Name *";

		$fields['billing']['billing_last_name']['label'] = false;
		$fields['billing']['billing_last_name']['placeholder'] = "Last Name *";

		$fields['billing']['billing_company']['label'] = false;
		$fields['billing']['billing_company']['placeholder'] = "Company Name (optional)";

		$fields['billing']['billing_country']['label'] = false;
		$fields['billing']['billing_country']['placeholder'] = 'Country *';

		$fields['billing']['billing_address_1']['label'] = false;

		$fields['billing']['billing_city']['label'] = false;
		$fields['billing']['billing_city']['placeholder'] = 'City *';

		$fields['billing']['billing_state']['label'] = false;
		$fields['billing']['billing_state']['placeholder'] = 'State *';

		$fields['billing']['billing_postcode']['label'] = false;
		$fields['billing']['billing_postcode']['placeholder'] = 'Postcode *';

		$fields['billing']['billing_phone']['label'] = false;
		$fields['billing']['billing_phone']['placeholder'] = "Phone Number *";
		
		$fields['billing']['billing_email']['label'] = false;
		$fields['billing']['billing_email']['placeholder'] = "E-mail Address *";

		return $fields;
	}

	// refresh mini cart ------------//
	function powerhour_refresh_mini_cart_count($fragments)
	{
		ob_start();
		$empty = '';
		if (empty(WC()->cart->get_cart_contents_count())) {
			$empty = 'style=display:none';
		}
		?>
			<div id="mini-cart-count" <?php echo esc_attr($empty); ?> class="cart-items-count count">
				<?php echo (WC()->cart->get_cart_contents_count() > 9) ? '9+' : WC()->cart->get_cart_contents_count(); ?>
			</div>
		<?php
		$fragments['#mini-cart-count'] = ob_get_clean();
		return $fragments;
	}

	// Mini cart View Cart Button
	function custom_widget_cart_btn_view_cart()
	{
		echo power_hour()->powerhour_get_woo_comment_btn($tag = "a",  $label = 'View Cart', $show_icon = false, $attr = array(
			'href' => wc_get_cart_url(),
			'class' => 'checkout wc-forward view_cart sample',
		));
	}

	//Mini Cart Checkout Button
	function custom_widget_cart_checkout()
	{
		echo power_hour()->powerhour_get_woo_comment_btn($tag = "a",  $label = 'Checkout', $show_icon = false, $attr = array(
			'href' => wc_get_checkout_url(),
			'class' => 'checkout wc-forward',
		));
	}

	/* products loop_columns */
	function powerhour_loop_columns()
	{
		if (isset($_COOKIE['product_view']) &&$_COOKIE['product_view']['is_grid'] == '2') {
			return $_COOKIE['product_view']['col_no'];
		} elseif ( isset($_COOKIE['product_view']['is_grid']) && $_COOKIE['product_view']['is_grid'] == '1') {
			return 1;
		}

		return 3; // 3 products per row
	}


	// function powerhour_loop_columns_test() {
	// 	if (isset($_COOKIE['product_view'])) {
	// 		$product_view = json_decode($_COOKIE['product_view'], true);
	
	// 		if (is_array($product_view)) {
	// 			if (isset($product_view['is_grid']) && $product_view['is_grid'] == '2') {
	// 				return isset($product_view['col_no']) ? $product_view['col_no'] : 3;
	// 			} elseif (isset($product_view['is_grid']) && $product_view['is_grid'] == '1') {
	// 				return 1;
	// 			}
	// 		}
	// 	}
	
	// 	return 3; // default 3 products per row
	// }

	/* wishlist title hide */
	function powerhour_wishlist_remove_title($args, $action, $action_params)
	{
		if (isset($args['wishlist_meta']) && $args['wishlist_meta']['is_default'] && !empty($args['wishlist_meta']['wishlist_name'])) {
			$args['page_title'] = $args['wishlist_meta']['wishlist_name'];
		}

		return $args;
	}

	/* hide terms and conditions toggle */
	function powerhour_disable_terms()
	{
		wp_add_inline_script('wc-checkout', "jQuery( document ).ready( function() { jQuery( document.body ).off( 'click', 'a.woocommerce-terms-and-conditions-link' ); } );");
	}

	/* woocommerce redirection after login & registration */
	function powerhour_after_login_registration($powerhour_redirection_url)
	{
		$powerhour_redirection_url = esc_url(get_permalink(get_option('woocommerce_myaccount_page_id')) . 'my-account');
		return $powerhour_redirection_url;
	}

	public function powerhour_wc_template_part($template, $slug, $name)
	{
		if (is_shop() || is_product_category() || is_product_tag()) {
			$template_page = isset($_COOKIE['product_view']['is_grid']) && $_COOKIE['product_view']['is_grid'] >= '2' ? 'entry.php' : 'entry-listing.php';
			return trailingslashit(get_stylesheet_directory()) . 'template-parts/wocommerce/' . $template_page;
		}
		return $template;
	}

	public function powerhour_product_perpage($per_page)
    {
        global $powerhour_options;
        $is_loadmore_pagination = isset($powerhour_options['powerhour_woocommerce_display_pagination']) && $powerhour_options['powerhour_woocommerce_display_pagination'] == 'pagination';

        if (isset($powerhour_options['woocommerce_product_per_page'])) {
            if (isset($_REQUEST['loaded_paged'])  &&  !$is_loadmore_pagination) {
                return $_REQUEST['loaded_paged'] * (int)$powerhour_options['woocommerce_product_per_page'];
            }
            return (int)$powerhour_options['woocommerce_product_per_page'];
        }
        return $per_page;
    }
	
	public function powerhour_woocomerce_page_header()
	{
		$links = array(
			array(
				'name' => esc_html__('Shopping Cart', 'power-hour'),
				'class' => is_cart() ? 'active' : '',
			),
			array(
				'name' => esc_html__('Checkout', 'power-hour'),
				'class' => is_checkout() && empty(is_wc_endpoint_url('order-received'))  ? 'active' : '',
			),
			array(
				'name' => esc_html__('Order Summary', 'power-hour'),
				'class' => is_checkout() && !empty(is_wc_endpoint_url('order-received'))  ? 'active' : '',
			),
		);

		?>
			<div class="powerhour-page-header">
				<ul class="powerhour-page-items">
					<?php
					foreach ($links as $key => $link) {
					?>
						<li class="powerhour-page-item <?php echo esc_attr($link['class']) ?>">
							<span class="powerhour-pre-heading"> <?php echo esc_html($key + 1) ?> </span>
							<span class="css-prefix-page-link ">
								<?php
								echo esc_html($link['name']);
								?>
							</span>
						</li>
					<?php
					}
					?>
				</ul>
			</div>



	<?php
	}

	public function powerhour_woof_hide_zero_term($val)
	{
		$new_term_arr = [];
		foreach ($val as $key => $value) {
			if ($value['count'] > 0) {
				$new_term_arr[$key] = $value;
			}
		}
		return $new_term_arr;
	}

	public function cart_min_quantity($args, $product) {
		$args['min_value'] = 0;
		return $args;
	}

	function powerhour_edit_billing_fields( $fields ) {
		$fields[ 'billing_state' ]['placeholder'] = '';
		return $fields;
	}
}
