<?php

/**
 * PowerHour\Utility\Redux_Framework\Options\User class
 *
 * @package power-hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class Woocommerce extends Component
{

	public function __construct()
	{
		$this->set_widget_option();
	}

	protected function set_widget_option()
	{
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('WooCommerce ', 'power-hour'),
			'icon'  => 'el el-shopping-cart',
			'customizer_width' => '500px',
		));


		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Shop Page', 'power-hour'),
			'id'    => 'Woocommerce',
			'subsection' => true,
			'fields' => array(
				array(
					'id'        => 'woocommerce_shop',
					'type'      => 'image_select',
					'title'     => esc_html__('Shop page Setting', 'power-hour'),
					'subtitle'  => wp_kses(__('Choose among these structures (Product Listing, Product Grid) for your shop section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.', 'power-hour'), array('br' => array())),
					'options'   => array(
						'1' => array('title' => esc_html__('Product Listing', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/single-column.jpg'),
						'2' => array('title' => esc_html__('Two Columns', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/two-column.jpg'),
						'3' => array('title' => esc_html__('Three Columns', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/three-column.jpg'),
						'4' => array('title' => esc_html__('Four Columns', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/four-column.jpg'),
					),
					'default'   => '3',
				),

				array(
					'id'        => 'woocommerce_shop_sidebar',
					'type'      => 'image_select',
					'title'     => esc_html__('Shop Page Sidebar Setting', 'power-hour'),
					'options'   => array(
						'1' => array('title' => esc_html__('Full Width', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/single-column.jpg'),
						'4' => array('title' => esc_html__('Right Sidebar', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/right-side.jpg'),
						'5' => array('title' => esc_html__('Left Sidebar', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/left-side.jpg'),
					),
					'default'   => '5',
				),

				array(
					'id' => 'woocommerce_product_per_page',
					'type' => 'slider',
					'title' => esc_html__('Set Product Per Page', 'power-hour'),
					'desc' => esc_html__('Here This option provide set post per paged item', 'power-hour'),
					'min' => 1,
					'step' => 1,
					'max' => 99,
					'default' => 12
				),
			)
		));
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Product Page', 'power-hour'),
			'id'    => 'product_page',
			'subsection' => true,
			'fields' => array(

				array(
					'id' => 'product_display_banner',
					'type' => 'button_set',
					'title' => esc_html__('Display Banner on Product Page', 'power-hour'),
					'subtitle' => esc_html__('This Option Display The Banner Of The Product', 'power-hour'),
					'options' => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default' => esc_html__('yes', 'power-hour')
				),
				array(
					'id' => 'powerhour_show_related_product',
					'type' => 'button_set',
					'title' => esc_html__('Display Related Product On Single Page', 'power-hour'),
					'subtitle' => esc_html__('This Option Display RElated Product On Single Page', 'power-hour'),
					'options' => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default' => esc_html__('yes', 'power-hour')
				),

			)
		));
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Shop Page Products Setting', 'power-hour'),
			'id'    => 'single_page',
			'subsection' => true,
			'fields' => array(


				array(
					'id'        => 'powerhour_display_product_name',
					'type'      => 'button_set',
					'title'     => esc_html__('Display Name', 'power-hour'),
					'subtitle' => esc_html__('Here This option provide Name Of The Product', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default'   => 'yes'
				),

				array(
					'id'        => 'powerhour_display_price',
					'type'      => 'button_set',
					'title'     => esc_html__('Display Price', 'power-hour'),
					'subtitle' => esc_html__('Here This option Display The Price', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default'   => 'yes'
				),

				array(
					'id'        => 'powerhour_display_product_rating',
					'type'      => 'button_set',
					'title'     => esc_html__('Display Rating', 'power-hour'),
					'subtitle' => esc_html__('Display The Ratings', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default'   => 'yes'
				),


				array(
					'id'        => 'powerhour_display_product_addtocart_icon',
					'type'      => 'button_set',
					'title'     => esc_html__('Display AddToCart Icon', 'power-hour'),
					'subtitle' => esc_html__('Display AddToCart Icon', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default'   => 'yes'
				),

				array(
					'id'        => 'powerhour_display_product_wishlist_icon',
					'type'      => 'button_set',
					'title'     => esc_html__('Display Wishlist Icon', 'power-hour'),
					'subtitle' => esc_html__('Display The Wishlist Icon', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default'   => 'yes'
				),


				array(
					'id'        => 'powerhour_display_product_quickview_icon',
					'type'      => 'button_set',
					'title'     => esc_html__('Display QuickView Icon', 'power-hour'),
					'subtitle' => esc_html__('Display QuickView Icon', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default'   => 'yes'
				),
			

				array(
					'id'            => 'powerhour_display_sale_badge_color',
					'type'          => 'color',
					'title'         => esc_html__(' Sale Badge Color', 'power-hour'),
					'subtitle'		=> esc_html__('Color Of The Sale Badge', 'power-hour'),
					'mode'          => 'background',
					'transparent'   => false,
				),

				array(
					'id'            => 'powerhour_display_new_badge_color',
					'type'          => 'color',
					'title'         => esc_html__(' New Badge Color', 'power-hour'),
					'subtitle' 		=> esc_html__('Color Of The New Badge', 'power-hour'),
					'mode'          => 'background',
					'transparent'   => false,
				),


				array(
					'id'            => 'powerhour_display_sold_badge_color',
					'type'          => 'color',
					'title'         => esc_html__(' Sold Badge Color', 'power-hour'),
					'subtitle'      => esc_html__('Color Of The Sold BAdge', 'power-hour'),
					'mode'          => 'background',
					'transparent'   => false,
				),
				'default' => 'yes'
			),
		));

		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Mini Cart Empty Image', 'power-hour'),
			'id'    => 'mini_cart_empty_image',
			'subsection' => true,
			'fields' => array(
				array(
					'id'        => 'powerhour_mini_cart_empty_image',
					'type'      => 'media',
					'url'      => false,
					'read-only' => false,
					'title'     => esc_html__('Upload Image', 'power-hour'),
					'subtitle' => esc_html__('When Mini Cart Is Empty, this image will be shown', 'power-hour'),
					'default'  => array('url' => get_template_directory_uri() . '/assets/images/redux/empty-cart-img.svg'),
				),
			)
		));

		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Header', 'power-hour'),
			'id'    => 'woo_header',
			'subsection' => true,
			'desc' => esc_html__('Note: Following options will work only if the header layout is default', 'power-hour'),
			'fields' => array(
				array(
					'id'        => 'display_user_icon_header',
					'type'      => 'button_set',
					'title'     => esc_html__('Display User Icon', 'power-hour'),
					'subtitle' => esc_html__('Turn on to Show User Icon On Default Header', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default'   => esc_html__('yes', 'power-hour')
				),

				array(
					'id'        => 'display_header_cart_button',
					'type'      => 'button_set',
					'title'     => esc_html__('Display Cart Icon', 'power-hour'),
					'subtitle' => esc_html__('Turn on to Show Cart On Default Header', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default'   => esc_html__('yes', 'power-hour')
				),
			)
		));
	}
}
