<?php

/**
 * PowerHour\Utility\Redux_Framework\Options class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class UserOptions extends Component
{
	public function __construct()
	{
		$this->set_widget_option();
	}

	protected function set_widget_option()
	{
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('User Account Settings', 'power-hour'),
			'id'    => 'user-register-options',
			'fields' => array(
				array(
					'id'    => 'info_custom_headers_options',
					'type'  => 'info',
					'required' 	=> array('header_layout', '=', 'custom'),
					'title' => esc_html__('Note:', 'power-hour'),
					'style' => 'warning',
					'desc'  => esc_html__('This options only works with Default Header Layout', 'power-hour')
				),
				array(
					'id' => 'powerhour_signup_section',
					'type' => 'section',
					'title' =>  esc_html__('Sign Up', 'power-hour'),
					'indent' => true,
					'required' 	=> array('header_layout', '=', 'default'),
				),

				array(
					'id'        => 'powerhour_signup_title',
					'type'      => 'text',
					'title'     => esc_html__('SignUp button title', 'power-hour'),
					'default'     => esc_html__('Sign Up', 'power-hour'),
				),

				array(
					'id'        => 'powerhour_signup_link',
					'type'     => 'select',
					'multi'    => false,
					'data'     => 'pages',
					'title'     => esc_html__('Select Page For SignUp', 'power-hour'),
				),

				array(
					'id' => 'powerhour_signin_section',
					'type' => 'section',
					'title' => esc_html__('Sign In', 'power-hour'),
					'indent' => true,
					'required' 	=> array('header_layout', '=', 'default'),

				),
				array(
					'id'        => 'powerhour_signin_title',
					'type'      => 'text',
					'title'     => esc_html__('SignIn button title', 'power-hour'),
					'default'     => esc_html__('Sign In', 'power-hour'),
				),

				array(
					'id'        => 'powerhour_signin_link',
					'type'     => 'select',
					'multi'    => false,
					'data'     => 'pages',
					'title'     => esc_html__('Select Page For SignIn', 'power-hour'),
				),

				array(
					'id' => 'powerhour_logout_section',
					'type' => 'section',
					'title' => esc_html__('Logout', 'power-hour'),
					'indent' => true,
					'required' 	=> array('header_layout', '=', 'default'),

				),

				array(
					'id'        => 'powerhour_logout_title',
					'type'      => 'text',
					'title'     => esc_html__('Logout Button title', 'power-hour'),
					'default'   =>  esc_html__('Logout', 'power-hour')
				),

				array(
					'id' => 'powerhour_profile_section',
					'type' => 'section',
					'title' => esc_html__('Profile', 'power-hour'),
					'indent' => true,
					'required' 	=> array('header_layout', '=', 'default'),
				),
				array(
					'id'        => 'powerhour_profile_title',
					'type'      => 'text',
					'title'     => esc_html__('Profile button title', 'power-hour'),
					'default'     => esc_html__('Profile', 'power-hour'),
				),

				array(
					'id'        => 'powerhour_profile_link',
					'type'     => 'select',
					'multi'    => false,
					'data'     => 'pages',
					'title'     => esc_html__('Select Page For Profile', 'power-hour'),
				),
			)
		));
	}
}
