<?php

/**
 * PowerHour\Utility\Redux_Framework\Options\Footer class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class Team extends Component
{
	public function __construct()
	{
		$this->set_widget_option();
	}

	protected function set_widget_option()
	{
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Team', 'power-hour'),
			'id'    => 'team',
			'icon'  => 'el el-group',
            'fields'=> array(
                array(
                    'id'      => 'team-member',
                    'type'    => 'editor',
                    'title'   => esc_html__('Title','power-hour'),
                    'subtitle'=> esc_html__('This Title will show up in the single team mamber page','power-hour'),
                    'default' => esc_html__('Meet the exports of Power Hour','power-hour')  
                ),
                array(
                    'id'      => 'team-member-subtitle',
                    'type'    => 'editor',
                    'title'   => esc_html__('Sub Title','power-hour'),
                    'subtitle'=> esc_html__('This Sub Title will show up in the single team mamber page','power-hour'),
                    'default' => esc_html__('About us','power-hour')  
                ),
		)));
	}
}
