<?php
/**
 * PowerHour\Utility\Redux_Framework\Options\Logo class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;
use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class Logo extends Component {

	public function __construct() {
		$this->set_widget_option();
	}

	protected function set_widget_option() {
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Logo','power-hour'),
			'id'    => 'header-logo',
			'icon'  => 'el el-flag',
			'desc'	=> esc_html__('[Note : Following Options will work only if header is default]','power-hour'),
			'fields'=> array(
		
				array(
					'id'       => 'header_radio',
					'type'     => 'button_set',
					'title'    => esc_html__( 'Select Logo Type', 'power-hour' ),
					'subtitle' => esc_html__( 'Select either Text or image for your Logo.', 'power-hour' ),
					'options'  => array(
						'1' => ' Logo as Text',
						'2' => ' Logo as Image',
					),
					'default'  => '2'
				),
		
				array(
					'id'       => 'header_text',
					'type'     => 'text',
					'title'    => esc_html__( 'Logo Text', 'power-hour' ),
					'desc'     => esc_html__( 'Enter the text to be used instead of the logo image', 'power-hour' ),
					'required'  => array( 'header_radio', '=', '1' ),
					'msg'      => esc_html__('Please enter correct value','power-hour' ),
					'default'  => esc_html__('power-hour','power-hour' ),
				),
		
				array(
					'id'            => 'header_color',
					'type'          => 'color',
					'title'         => esc_html__( 'Text Color', 'power-hour' ),
					'subtitle'      => esc_html__( 'Choose Text Color', 'power-hour' ),
					'required'      => array( 'header_radio', '=', '1' ),
					'default'       =>'#ffffff',
					'mode'          => 'background',
					'transparent'   => false
				),
		        array(
					'id' => 'powerhour_header_logo_section',
					'type' => 'section',
					'title'=>  esc_html__('Logo', 'power-hour'),
					'indent' => true,
					'required'  => array( 'header_radio', '=', '2' ),
				) ,
		
				array(
					'id'       => 'powerhour_logo',
					'type'     => 'media',
					'url'      => false,
					'title'    => esc_html__( 'Logo','power-hour'),
					'required' => array( 'header_radio', '=', '2' ),
					'read-only'=> false,
					'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/logo.svg' ),
					'subtitle' => esc_html__( 'Upload Logo image for your Website. Otherwise site title will be displayed in place of Logo.','power-hour'),
				),

				array(
					'id'             => 'logo-dimensions',
					'type'           => 'dimensions',
					'units'          => array( 'em', 'px', '%' ),    // You can specify a unit value. Possible: px, em, %
					'units_extended' => 'true',  // Allow users to select any type of unit
					'title'          => esc_html__( 'Logo (Width/Height) Option', 'power-hour' ),
					'required'  	 => array( 'header_radio', '=', '2' ),
					'subtitle'       => esc_html__( 'Allows you to choose width, height, and/or unit.', 'power-hour' ),
					'desc'           => esc_html__( 'You can enable or disable any piece of this field. Width, Height, or Units.', 'power-hour' ),
				),

		        array(
					'id' 		=> 'powerhour_header_mobile_logo_section',
					'type' 		=> 'section',
					'title'		=>  esc_html__('Mobile Logo', 'power-hour'),
					'indent' 	=> true,
					'required'  => array( 'header_radio', '=', '2' ),
				),

				array(
					'id'       => 'powerhour_mobile_logo',
					'type'     => 'media',
					'url'      => false,
					'title'    => esc_html__( 'Mobile Logo','power-hour'),
					'required' => array( 'header_radio', '=', '2' ),
					'read-only'=> false,
					'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/logo-white.svg' ),
					'subtitle' => esc_html__( 'Upload Logo image for your Website. Otherwise site title will be displayed in place of Logo.','power-hour'),
				),

				array(
					'id'             => 'mobile-logo-dimensions',
					'type'           => 'dimensions',
					'units'          => array( 'em', 'px', '%' ),    // You can specify a unit value. Possible: px, em, %
					'units_extended' => 'true',  // Allow users to select any type of unit
					'title'          => esc_html__( 'Mobile Logo (Width/Height) Option', 'power-hour' ),
					'required'  => array( 'header_radio', '=', '2' ),
					'subtitle'       => esc_html__( 'Allows you to choose width, height, and/or unit.', 'power-hour' ),
					'desc'           => esc_html__( 'You can enable or disable any piece of this field. Width, Height, or Units.', 'power-hour' ),
		
				),

			)
		));
	}
}
