<?php

/**
 * PowerHour\Utility\Redux_Framework\Options\General class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class Header extends Component
{

	public function __construct()
	{
		$this->set_widget_option();
	}

	protected function set_widget_option()
	{
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Header', 'power-hour'),
			'id' => 'header',
			'icon' => 'el el-arrow-up',
			'customizer_width' => '500px',
		));

		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Header Layout', 'power-hour'),
			'id' => 'header_variation',
			'subsection' => true,
			'desc' => esc_html__('This section contains options for Menu .', 'power-hour'),
			'fields' => array(
				array(
					'id' => 'header_layout',
					'type' => 'button_set',
					'title' => esc_html__('Header Layout', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'custom' => esc_html__('Custom', 'power-hour'),
					),
					'default' => 'default'
				),

				array(
					'id'        => 'menu_style',
					'type'      => 'select',
					'title' 	=> esc_html__('Header Layout', 'power-hour'),
					'subtitle' 	=> esc_html__('Select the layout variation that you want to use for header layout.', 'power-hour'),
					'options'	=> (function_exists('iqonic_addons_get_list_layouts')) ? iqonic_addons_get_list_layouts(false, 'header') : '',
					'required' 	=> array('header_layout', '=', 'custom'),
				),

				array(
					'id' => 'header_container',
					'type' => 'button_set',
					'title' => esc_html__('Header container', 'power-hour'),
					'options' => array(
						'container-fluid' => esc_html__('full width', 'power-hour'),
						'container' => esc_html__('Container', 'power-hour'),
					),
					'default' => 'container-fluid',
					'required' 	=> array('header_layout', '=', 'default'),
				),

				array(
					'id' => 'header_hover_style',
					'type' => 'button_set',
					'title' => esc_html__('Header Menu Hover Style', 'power-hour'),
					'options' => array(
						'style-1' => esc_html__('Default', 'power-hour'),
						'style-2' => esc_html__('New', 'power-hour'),
					),
					'default' => 'style-1',
				),


				array(
					'id' => 'header_postion',
					'type' => 'button_set',
					'title' => esc_html__('Header Position', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'over' => esc_html__('Over', 'power-hour'),
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default' => 'default'
				),


				// --------main header background options start----------//

				array(
					'id' => 'powerhour_header_background_type',
					'type' => 'button_set',
					'title' => esc_html__('Background', 'power-hour'),
					'subtitle' => esc_html__('Select the variation for header background', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'color' => esc_html__('Color', 'power-hour'),
						'image' => esc_html__('Image', 'power-hour'),
						'transparent' => esc_html__('Transparent', 'power-hour')
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default' => esc_html__('default', 'power-hour')
				),

				array(
					'id' => 'powerhour_header_background_color',
					'type' => 'color',
					'desc' => esc_html__('Set Background Color', 'power-hour'),
					'required' => array('powerhour_header_background_type', '=', 'color'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'powerhour_header_background_image',
					'type' => 'media',
					'url' => false,
					'desc' => esc_html__('Upload Image', 'power-hour'),
					'required' => array('powerhour_header_background_type', '=', 'image'),
					'read-only' => false,
					'subtitle' => esc_html__('Upload background image for header.', 'power-hour'),
				),

				// --------main header Background options end----------//

				// --------main header Search Options start----------//
				array(
					'id' 		=> 'header_display_search',
					'type' 		=> 'button_set',
					'title' 	=> esc_html__('Display Search Icon', 'power-hour'),
					'desc' 		=> esc_html__('Turn on to display the Search in header.', 'power-hour'),
					'options' 	=> array(
						'yes' 		=> esc_html__('On', 'power-hour'),
						'no' 		=> esc_html__('Off', 'power-hour')
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default'	=> esc_html__('yes', 'power-hour')
				),

				array(
					'id' 		=> 'header_search_text',
					'type' 		=> 'text',
					'desc' 		=> esc_html__('Enter search label', 'power-hour'),
					'required' 	=> array('header_display_search', '=', 'yes'),
					'validate' 	=> 'text',
				),

				array(
					'id'        => 'display_user_icon_header',
					'type'      => 'button_set',
					'title'     => esc_html__('Display User Icon', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default'   => esc_html__('yes', 'power-hour')
				),

				array(
					'id'        => 'display_header_cart_button',
					'type'      => 'button_set',
					'title'     => esc_html__('Display Cart Icon', 'power-hour'),
					'subtitle' => esc_html__('Turn on to Show Cart On Default Header', 'power-hour'),
					'options'   => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default'   => esc_html__('yes', 'power-hour')
				),

				// --------main header Search Options end----------//

				// --------main header Menu options start----------//
				array(
					'id' => 'menu_color',
					'type' => 'button_set',
					'title' => esc_html__('Menu Color Options', 'power-hour'),
					'subtitle' => esc_html__('Select Menu color .', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'custom' => esc_html__('Custom', 'power-hour'),
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default' => esc_html__('default', 'power-hour')
				),
				array(
					'id' => 'header_menu_color',
					'type' => 'color',
					'required' => array('menu_color', '=', 'custom'),
					'desc' => esc_html__('Menu Color', 'power-hour'),
					'mode' => 'background',
					'transparent' => false
				),


				array(
					'id' => 'hover_menu_color',
					'type' => 'color',
					'required' => array('menu_color', '=', 'custom'),
					'desc' => esc_html__('Menu Hover Color', 'power-hour'),
					'mode' => 'background',
					'transparent' => false
				),

				//----sub menu options start---//
				array(
					'id' => 'header_submenu_color_type',
					'type' => 'button_set',
					'title' => esc_html__('Submenu Color Options', 'power-hour'),
					'subtitle' => esc_html__('Select submenu color.', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'custom' => esc_html__('Custom', 'power-hour'),
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default' => esc_html__('default', 'power-hour')
				),

				array(
					'id' => 'submenu_color',
					'type' => 'color',
					'desc' => esc_html__('Submenu Color', 'power-hour'),
					'required' => array('header_submenu_color_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),


				array(
					'id' => 'hover_submenu_color',
					'type' => 'color',
					'desc' => esc_html__('Submenu Hover Color', 'power-hour'),
					'required' => array('header_submenu_color_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'submenu_background_color',
					'type' => 'color',
					'desc' => esc_html__('Submenu Background Color', 'power-hour'),
					'required' => array('header_submenu_color_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'hover_submenu_bg_color',
					'type' => 'color',
					'desc' => esc_html__('Submenu Background Hover Color', 'power-hour'),
					'required' => array('header_submenu_color_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),
				//----sub menu options end----//


				// --------main header Menu options end----------//

				// --------main header responsive Menu Button Options start----------//
				array(
					'id' => 'burger_menu_button_type',
					'type' => 'button_set',
					'title' => esc_html__('Burger Menu', 'power-hour'),
					'subtitle' => esc_html__('Select color for burger Menu', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'custom' => esc_html__('Custom', 'power-hour')
					),
					'required' 	=> array('header_layout', '=', 'default'),
					'default' => 'default'
				),

				array(
					'id' => 'burger_menu_icon',
					'type' => 'color',
					'desc' => esc_html__('Toggle Icon color', 'power-hour'),
					'required' => array('burger_menu_button_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'burger_menu_popup_bg',
					'type' => 'color',
					'desc' => esc_html__('Model Background color', 'power-hour'),
					'required' => array('burger_menu_button_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'burger_menu_color',
					'type' => 'color',
					'desc' => esc_html__('Menu color', 'power-hour'),
					'required' => array('burger_menu_button_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'burger_hover_menu_color',
					'type' => 'color',
					'desc' => esc_html__('Menu hover color', 'power-hour'),
					'required' => array('burger_menu_button_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'burger_submenu_color',
					'type' => 'color',
					'desc' => esc_html__('Sub Menu Color', 'power-hour'),
					'required' => array('burger_menu_button_type', '=', 'custom'),
					'mode' => 'background',
					'transparent' => false
				),


				// --------main header responsive Menu Button Options end----------//
			)
		));

		//-----Sticky Header Options Start---//
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Sticky Header', 'power-hour'),
			'id' => 'power-hour_sticky-header-variation',
			'subsection' => true,
			'desc' => esc_html__('This section contains options for sticky header menu and background color. [note: Following options will work only if the header layout is default]', 'power-hour'),
			'fields' => array(

				array(
					'id' => 'display_sticky_header',
					'type' => 'button_set',
					'title' => esc_html__('Sticky Header', 'power-hour'),
					'subtitle' => esc_html__('Turn on to display sticky header.', 'power-hour'),
					'options' => array(
						'yes' => esc_html__('On', 'power-hour'),
						'no' => esc_html__('Off', 'power-hour')
					),
					'default' => esc_html__('yes', 'power-hour')
				),
				// --------sticky header background options start----------//
				array(
					'id' => 'sticky_header_bg',
					'type' => 'button_set',
					'required' => array('display_sticky_header', '=', 'yes'),
					'title' => esc_html__('Background', 'power-hour'),
					'subtitle' => esc_html__('Select the variation for sticky header background', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'color' => esc_html__('Color', 'power-hour'),
						'image' => esc_html__('Image', 'power-hour'),
						'transparent' => esc_html__('Transparent', 'power-hour')
					),
					'default' => esc_html__('default', 'power-hour')
				),

				array(
					'id' => 'sticky_header_bg_color',
					'type' => 'color',
					'desc' => esc_html__('Set Background Color', 'power-hour'),
					'required' => array('sticky_header_bg', '=', 'color'),
					'mode' => 'background',
					'transparent' => false
				),

				array(
					'id' => 'sticky_header_bg_img',
					'type' => 'media',
					'url' => false,
					'desc' => esc_html__('Upload Image', 'power-hour'),
					'required' => array('sticky_header_bg', '=', 'image'),
					'read-only' => false,
					'subtitle' => esc_html__('Upload background image for sticky header.', 'power-hour'),
				),
				// --------sticky header Background options end----------//
				// --------sticky header Menu options start----------//

				array(
					'id'        => 'sticky_menu_color_type',
					'type'      => 'button_set',
					'required'  => array('display_sticky_header', '=', 'yes'),
					'title'     => esc_html__('Menu Color Options', 'power-hour'),
					'subtitle' => esc_html__('Select Menu color for sticky.', 'power-hour'),
					'options'   => array(
						'default' => esc_html__('Default', 'power-hour'),
						'custom' => esc_html__('Custom', 'power-hour'),
					),
					'default'   => esc_html__('default', 'power-hour')
				),
				array(
					'id'            => 'sticky_menu_color',
					'type'          => 'color',
					'required'  => array('sticky_menu_color_type', '=', 'custom'),
					'desc'     => esc_html__('Menu color', 'power-hour'),
					'mode'          => 'background',
					'transparent'   => false
				),

				array(
					'id'            => 'sticky_menu_hover_color',
					'type'          => 'color',
					'required'  => array('sticky_menu_color_type', '=', 'custom'),
					'desc'     => esc_html__('Menu hover color', 'power-hour'),
					'mode'          => 'background',
					'transparent'   => false
				),

				//----sticky sub menu options start---//
				array(
					'id'        => 'sticky_header_submenu_color_type',
					'type'      => 'button_set',
					'title'     => esc_html__('Submenu Color Options', 'power-hour'),
					'subtitle' => esc_html__('Select submenu color for sticky.', 'power-hour'),
					'required'  => array('display_sticky_header', '=', 'yes'),
					'options'   => array(
						'default' => esc_html__('Default', 'power-hour'),
						'custom' => esc_html__('Custom', 'power-hour'),
					),
					'default'   => esc_html__('default', 'power-hour')
				),

				array(
					'id'            => 'sticky_powerhour_header_submenu_color',
					'type'          => 'color',
					'desc'     => esc_html__('Submenu Color', 'power-hour'),
					'required'  => array('sticky_header_submenu_color_type', '=', 'custom'),
					'mode'          => 'background',
					'transparent'   => false
				),


				array(
					'id'            => 'sticky_powerhour_header_submenu_hover_color',
					'type'          => 'color',
					'desc'     => esc_html__('Submenu Hover Color', 'power-hour'),
					'required'  => array('sticky_header_submenu_color_type', '=', 'custom'),
					'mode'          => 'background',
					'transparent'   => false
				),

				array(
					'id'            => 'sticky_powerhour_header_submenu_background_color',
					'type'          => 'color',
					'desc'     => esc_html__('Submenu Background Color', 'power-hour'),
					'required'  => array('sticky_header_submenu_color_type', '=', 'custom'),
					'mode'          => 'background',
					'transparent'   => false
				),

				array(
					'id'            => 'sticky_header_submenu_background_hover_color',
					'type'          => 'color',
					'desc'     => esc_html__('Submenu Background Hover Color', 'power-hour'),
					'required'  => array('sticky_header_submenu_color_type', '=', 'custom'),
					'mode'          => 'background',
					'transparent'   => false
				),
				// --------sticky header Menu options start----------//sss

				
				
			)
		));
	}
}
