<?php

/**
 * PowerHour\Utility\Redux_Framework\Options\Footer class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class Footer extends Component
{

	public function __construct()
	{
		$this->set_widget_option();
	}

	protected function set_widget_option()
	{
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Footer', 'power-hour'),
			'id' => 'footer',
			'icon' => 'el el-arrow-down',
			'customizer_width' => '500px',
		));

		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Footer Image', 'power-hour'),
			'id' => 'footer-logo',
			'subsection' => true,
			'desc' => esc_html__('This section contains options for footer.', 'power-hour'),
			'fields' => array(
				array(
					'id' => 'footer_layout',
					'type' => 'button_set',
					'title' => esc_html__('Footer Layout', 'power-hour'),
					'options' => array(
						'default' => esc_html__('Default', 'power-hour'),
						'custom' => esc_html__('Custom', 'power-hour'),
					),
					'default' => 'custom',
					
				),

				array(
					'id' => 'display_footer_bg_image',
					'type' => 'button_set',
					'title' => esc_html__('Display Footer Background Image', 'power-hour'),
					'subtitle' => esc_html__('Display Footer Background Image On All page', 'power-hour'),
					'options' => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default' => esc_html__('no', 'power-hour'),
					'required' 	=> array('footer_layout', '=', 'default'),
				),
				array(
					'id' => 'footer_bg_image',
					'type' => 'media',
					'url' => false,
					'title' => esc_html__('Footer Background Image', 'power-hour'),
					'required' => array(
						'display_footer_bg_image', '=', 'yes'
					),
					'read-only' => false,
					'subtitle' => esc_html__('Upload Footer image for your Website.', 'power-hour'),
					'default' => array('url' => get_template_directory_uri() . '/assets/images/redux/footer-img.jpg'),
				),
				
				array(
					'id'        => 'footer_style',
					'type'      => 'select',
					'title' 	=> esc_html__('Footer Layout', 'power-hour'),
					'subtitle' 	=> esc_html__('Select the layout variation that you want to use for Footer.', 'power-hour'),
					'options'	=> (function_exists('iqonic_addons_get_list_layouts')) ? iqonic_addons_get_list_layouts(false, 'footer') : '',
					'required' 	=> array('footer_layout', '=', 'custom'),
				),
				array(
					'id'       => 'logo_footer',
					'type'     => 'media',
					'url'      => false,
					'title'    => esc_html__('Footer Logo', 'power-hour'),
					'read-only' => false,
					'subtitle' => esc_html__('Upload Footer Logo for your Website.', 'power-hour'),
					'default'  => array('url' => get_template_directory_uri() . '/assets/images/logo.png'),
					'required' 	=> array('footer_layout', '=', 'default'),
				),

				
				array(
					'id' => 'change_footer_color',
					'type' => 'button_set',
					'title' => esc_html__('Change Footer Color', 'power-hour'),
					'subtitle' => esc_html__('Turn on to Change Footer Background Color', 'power-hour'),
					'options' => array(
						'0' => esc_html__('Yes', 'power-hour'),
						'1' => esc_html__('No', 'power-hour')
					),
					'required' 	=> array('footer_layout', '=', 'default'),
					'default' => esc_html__('0', 'power-hour')
				),

				array(
					'id' => 'footer_bg_color',
					'type' => 'color',
					'subtitle' => esc_html__('Choose Footer Background Color', 'power-hour'),
					'required' => array('change_footer_color', '=', '0'),
					'mode' => 'background',
					'transparent' => false
				),

			)
		));

		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Footer Option', 'power-hour'),
			'id' => 'footer_section',
			'subsection' => true,
			'desc' => esc_html__('NOTE : This section contains options for Default footer layout.', 'power-hour'),
			'fields' => array(

				array(
					'id' => 'footer_top',
					'type' => 'button_set',
					'title' => esc_html__('Display Footer Top', 'power-hour'),
					'subtitle' => esc_html__('Display Footer Top On All page', 'power-hour'),
					'options' => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default' => esc_html__('yes', 'power-hour')
				),

				array(
					'id' => 'powerhour_footer_width',
					'type' => 'image_select',
					'title' => esc_html__('Footer Layout Type', 'power-hour'),
					'required' => array('footer_top', '=', 'yes'),
					'subtitle' => wp_kses(__('<br />Choose among these structures (1column, 2column and 3column) for your footer section.<br />To fill these column sections you should go to appearance > widget.<br />And add widgets as per your needs.', 'power-hour'), array('br' => array())),
					'options' => array(
						'1' => array('title' => esc_html__('Footer Layout 1', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/footer_first.png'),
						'2' => array('title' => esc_html__('Footer Layout 2', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/footer_second.png'),
						'3' => array('title' => esc_html__('Footer Layout 3', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/footer_third.png'),
						'4' => array('title' => esc_html__('Footer Layout 4', 'power-hour'), 'img' => get_template_directory_uri() . '/assets/images/redux/footer_four.png'),
					),
					'default' => '3',
				),

				array(
					'id' => 'footer_one',
					'type' => 'select',
					'title' => esc_html__('Select 1 Footer Alignment', 'power-hour'),
					'required' => array('footer_top', '=', 'yes'),
					'options' => array(
						'1' => 'Left',
						'2' => 'Right',
						'3' => 'Center',
					),
					'default' => '1',
				),

				array(
					'id' => 'footer_two',
					'type' => 'select',
					'title' => esc_html__('Select 2 Footer Alignment', 'power-hour'),
					'required' => array('footer_top', '=', 'yes'),
					'options' => array(
						'1' => 'Left',
						'2' => 'Right',
						'3' => 'Center',
					),
					'default' => '1',
				),

				array(
					'id' => 'footer_three',
					'type' => 'select',
					'title' => esc_html__('Select 3 Footer Alignment', 'power-hour'),
					'required' => array('footer_top', '=', 'yes'),
					'options' => array(
						'1' => 'Left',
						'2' => 'Right',
						'3' => 'Center',
					),
					'default' => '1',
				),

				array(
					'id' => 'footer_four',
					'type' => 'select',
					'title' => esc_html__('Select 4 Footer Alignment', 'power-hour'),
					'required' => array('footer_top', '=', 'yes'),
					'options' => array(
						'1' => 'Left',
						'2' => 'Right',
						'3' => 'Center',
					),
					'default' => '1',
				),
				
				array(
					'id' => 'footer_five',
					'type' => 'select',
					'title' => esc_html__('Select 5 Footer Alignment', 'power-hour'),
					'required' => array('footer_top', '=', 'yes'),
					'options' => array(
						'1' => 'Left',
						'2' => 'Right',
						'3' => 'Center',
					),
					'default' => '1',
				),
			)
		));

		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Footer Copyright', 'power-hour'),
			'id' => 'footer_copyright',
			'subsection' => true,
			'fields' => array(

				array(
					'id' => 'display_copyright',
					'type' => 'button_set',
					'title' => esc_html__('Display Copyrights', 'power-hour'),
					'options' => array(
						'yes' => esc_html__('Yes', 'power-hour'),
						'no' => esc_html__('No', 'power-hour')
					),
					'default' => esc_html__('yes', 'power-hour')
				),
				array(
					'id' => 'footer_copyright_align',
					'type' => 'select',
					'title' => esc_html__('Copyrights Alignment', 'power-hour'),
					'required' => array('display_copyright', '=', 'yes'),
					'options' => array(
						'left' => 'Left',
						'right' => 'Right',
						'center' => 'Center',
					),
					'default' => 'center',
				),

				array(
					'id' => 'footer_copyright',
					'type' => 'editor',
					'required' => array('display_copyright', '=', 'yes'),
					'title' => esc_html__('Copyrights Text', 'power-hour'),
					'default' => esc_html__('© 2022 Power Hour. All Rights Reserved.', 'power-hour'),
				),
			)
		));


	}
}
