<?php
/**
 * PowerHour\Utility\Redux_Framework\Options\Contact class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class Contact extends Component {

	public function __construct() {
		$this->set_widget_option();
	}

	protected function set_widget_option() {
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Contact', 'power-hour'),
			'id' => 'contact',
			'icon' => 'el el-map-marker',
			'fields' => array(

				array(
					'id' => 'address',
					'type' => 'textarea',
					'title' => esc_html__('Address', 'power-hour'),
					'default' => esc_html__('1234 North Avenue Luke Lane, South Bend, IN 360001', 'power-hour'),
				),

				array(
					'id' => 'phone',
					'type' => 'text',
					'title' => esc_html__('Phone', 'power-hour'),
					'preg' => array(
						'pattern' => '/[^0-9_ -+()]/s',
						'replacement' => ''
					),
					'default' => esc_html__('+0123456789', 'power-hour'),
				),

				array(
					'id' => 'email',
					'type' => 'text',
					'title' => esc_html__('Email', 'power-hour'),
					'validate' => 'email',
					'msg' => esc_html__('custom error message', 'power-hour'),
					'default' => esc_html__('support@example.com', 'power-hour'),
				),
			)
		));
	}
}
