<?php
/**
 * PowerHour\Utility\Redux_Framework\Options\Blog class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class Blog extends Component {

	public function __construct() {
		$this->set_widget_option();
	}

	protected function set_widget_option() {
		Redux::set_section( $this->opt_name, array(
			'title' => esc_html__( 'Blog', 'power-hour' ),
			'id'    => 'blog',
			'icon'  => 'el el-quotes',
			'customizer_width' => '500px',
		) );

		Redux::set_section( $this->opt_name, array(
			'title' => esc_html__('General Blogs','power-hour'),
			'id'    => 'blog-section',
			'subsection' => true,
			'desc'  => esc_html__('This section contains options for blog.','power-hour'),
			'fields'=> array(

				array(
					'id'       => 'blog_default_banner_image',
					'type'     => 'media',
					'url'      => true,
					'title'    => esc_html__( 'Blog Page Default Banner Image','power-hour'),
					'read-only'=> false,
					'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/redux/banner.png' ),
					'subtitle' => esc_html__( 'Upload banner image for your Website. Otherwise blank field will be displayed in place of this section.','power-hour').'<b>'.esc_html__("(Note:Only Display Banner Style Second & Third in Page Banner Setting)","power-hour").'</b>',
				),

				array(
					'id'        => 'blog_setting',
					'type'      => 'image_select',
					'title'     => esc_html__( 'Blog page Setting','power-hour' ),
					'subtitle'  => wp_kses( __( '<br />Choose among these structures (Right Sidebar, Left Sidebar, 1column, 2column and 3column) for your blog section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','power-hour' ), array( 'br' => array() ) ),
					'options'   => array(
						'1' => array( 'title' => esc_html__( 'One Columns','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux//single-column.jpg' ),
						'2' => array( 'title' => esc_html__( 'Two Columns','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux//two-column.jpg' ),
						'3' => array( 'title' => esc_html__( 'Three Columns','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux//three-column.jpg' ),
						'4' => array( 'title' => esc_html__( 'Right Sidebar','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux//right-side.jpg' ),
						'5' => array( 'title' => esc_html__( 'Left Sidebar','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux//left-side.jpg' ),
					),
					'default'   => '1',
				),

				array(
					'id'        => 'display_pagination',
					'type'      => 'button_set',
					'title'     => esc_html__( 'Previous/Next Pagination','power-hour'),
					'subtitle' => esc_html__( 'Turn on to display the previous/next post pagination for blog page.','power-hour'),
					'options'   => array(
						'yes' => esc_html__('On','power-hour'),
						'no' => esc_html__('Off','power-hour')
					),
					'default'   => esc_html__('yes','power-hour')
				),

				array(
					'id'        => 'display_featured_image',
					'type'      => 'button_set',
					'title'     => esc_html__( 'Featured Image on Blog Archive Page','power-hour'),
					'subtitle' => esc_html__( 'Turn on to display featured images on the blog or archive pages.','power-hour'),
					'options'   => array(
						'yes' => esc_html__('On','power-hour'),
						'no' => esc_html__('Off','power-hour')
					),
					'default'   => esc_html__('yes','power-hour')
				),
			)
		));

		Redux::set_section( $this->opt_name, array(
				'title'      => esc_html__( 'Blog Single Post', 'power-hour' ),
				'id'         => 'basic',
				'subsection' => true,
				'fields'     => array(

					array(
						'id'        => 'blog_single_page_setting',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Blog Single page Setting','power-hour' ),
						'subtitle'  => wp_kses( __( '<br />Choose among these structures (Right Sidebar, Left Sidebar and 1column) for your blog section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','power-hour' ), array( 'br' => array() ) ),
						'options'   => array(
							'1' => array( 'title' => esc_html__( 'Full Width','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux/single-column.jpg' ),
							'4' => array( 'title' => esc_html__( 'Right Sidebar','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux/right-side.jpg' ),
							'5' => array( 'title' => esc_html__( 'Left Sidebar','power-hour' ), 'img' => get_template_directory_uri() . '/assets/images/redux/left-side.jpg' ),
						),
						'default'   => '1',
					),

					array(
						'id'        => 'display_comment',
						'type'      => 'button_set',
						'title'     => esc_html__( 'Comments','power-hour'),
						'subtitle' => esc_html__( 'Turn on to display comments.','power-hour'),
						'options'   => array(
							'yes' => esc_html__('On','power-hour'),
							'no' => esc_html__('Off','power-hour')
						),
						'default'   => esc_html__('yes','power-hour')
					),

					/* featured Image hide option */
					array (	
						'id' => 'posts_select',
						'type' => 'select',
						'multi' => true,
						'title' => esc_html__('Select Posts to hide featured images', 'power-hour'),							
						'options' => (function_exists('powerhour_get_post_format_dynamic')) ? powerhour_get_post_format_dynamic() : '',
					),

					array(
						'id' 		=> 'blog_detail_style',
						'type' 		=> 'select',
						'title' 	=> __('Blog Detail Style', 'power-hour'),
						'subtitle' 	=> __('Select this option for blog detail style.', 'power-hour'),
						'options' => array(
							'default' => 'default',
							'1' => 'Title First',
							'2' => 'Image First',
							'3' => 'Overlay Image'
						),
						'default' => 'default'
					),
				))
		);
	}
}
