<?php
/**
 * PowerHour\Utility\Jetpack\Component class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Redux_Framework\Options;

use Redux;
use PowerHour\Utility\Redux_Framework\Component;

class AdditionalCode extends Component {

	public function __construct() {
		$this->set_widget_option();
	}

	protected function set_widget_option() {
		Redux::set_section( $this->opt_name, array(
			'title' => esc_html__( 'Additional Code', 'power-hour' ),
			'id'    => 'additional-Code',
			'icon'  => 'el el-css',
			'desc'  => esc_html__('This section contains options for header.','power-hour'),
			'fields'=> array(

				array(
					'id'       => 'css_code',
					'type'     => 'ace_editor',
					'title'    => esc_html__('CSS Code','power-hour'),
					'subtitle' => esc_html__('Paste your css code here.','power-hour'),
					'mode'     => 'css',
					'desc'     => esc_html__('Paste your custom CSS code here.','power-hour'),
				),

				array(
					'id'       => 'js_code',
					'type'     => 'ace_editor',
					'title'    => esc_html__('JS Code','power-hour'),
					'subtitle' => esc_html__('Paste your js code in footer.','power-hour'),
					'mode'     => 'javascript',
					'theme'   => 'chrome',
					'desc'     => esc_html__('Paste your custom JS code here.','power-hour'),
					'default' => "jQuery(document).ready(function($){\n\n});"
				),
			)
		));
	}
}
