<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\Banner class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class WooCommerce extends Component
{
	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'powerhour_woocommerce_color_options'), 20);
	}

	public function powerhour_woocommerce_color_options()
	{
		if (class_exists('ReduxFramework')) {
			global $powerhour_options;
			$color_var = '';
            if (isset($powerhour_options['powerhour_display_sale_badge_color']) && !empty($powerhour_options['powerhour_display_sale_badge_color'])) {
                $color = $powerhour_options['powerhour_display_sale_badge_color'];
                $color_var .= '.woocommerce .products .product .onsale.powerhour-on-sale { background: ' . $color . ' !important; }';
            }

			if (isset($powerhour_options['powerhour_display_new_badge_color']) && !empty($powerhour_options['powerhour_display_new_badge_color'])) {
                $color = $powerhour_options['powerhour_display_new_badge_color'];
                $color_var .= '.woocommerce .products .product .onsale.powerhour-new { background: ' . $color . ' !important; }';
            }

			if (isset($powerhour_options['powerhour_display_sold_badge_color']) && !empty($powerhour_options['powerhour_display_sold_badge_color'])) {
                $color = $powerhour_options['powerhour_display_sold_badge_color'];
                $color_var .= '.woocommerce .products .product .onsale.powerhour-sold-out { background: ' . $color . ' !important; }';
            }
            
			if(!empty($color_var)) {
				wp_add_inline_style('power-hour-global', $color_var);
			}
		}
	}
}
