<?php
/**
 * PowerHour\Utility\Dynamic_Style\Styles\Logo class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class Logo extends Component
{
	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'powerhour_logo_options'), 20);
	}

	public function powerhour_logo_options() {
        $powerhour_options = get_option('power-hour-options');
        $logo_var = '';
        if($powerhour_options['header_radio'] == 1) {
            if(isset($powerhour_options['header_color'])) {
                $logo = $powerhour_options['header_color'];
                    $logo_var .= "
                    .navbar-light .navbar-brand {
                        color : $logo !important;
                    }"; 
            }  
        }
        wp_add_inline_style( 'power-hour-global', $logo_var );
    }
}
