<?php
/**
 * PowerHour\Utility\Dynamic_Style\Styles\Loader class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class Loader extends Component
{

	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'powerhour_loader_options'), 20);
	}

	public function powerhour_loader_options(){
        $powerhour_options = get_option('power-hour-options');
        $loader_css = '';
            if(isset($powerhour_options['loader_bg_color'])){
                $loader_var = $powerhour_options['loader_bg_color'];
                if( !empty($loader_var) && $loader_var != '#ffffff') {
                    $loader_css .= "
                    #loading {
                        background : $loader_var !important;
                    }"; 
                }
            }            
            wp_add_inline_style( 'power-hour-global', $loader_css );
    }
}
