<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\HeaderSticky class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class HeaderSticky extends Component
{
	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'powerhour_header_sticky_background_style'));
		add_action('wp_enqueue_scripts', array($this, 'powerhour_sticky_sub_menu_color_options'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_sticky_menu_color_options'), 20);
	}

	public function powerhour_header_sticky_background_style()
	{
		$powerhour_option = get_option('power-hour-options');
		$inline_css = '';
		$id = get_queried_object_id();
		if (function_exists('get_field') && get_field('display_header', $id) !== 'default' && get_field('header_sitcky_color_type', $id) !== 'default') {
			if (!empty(get_field('header_sticky_bg', $id))) {
				$inline_css .= '.has-sticky.header-up,.has-sticky.header-down{
						background : ' . get_field('header_sticky_bg', $id) . '!important;
					}';
			}
		} else if (isset($powerhour_option['display_sticky_header']) && $powerhour_option['display_sticky_header'] === 'yes') {
			if (isset($powerhour_option['sticky_header_bg']) && $powerhour_option['sticky_header_bg'] != 'default') {
				$type = $powerhour_option['sticky_header_bg'];
				if ($type == 'color') {
					if (!empty($powerhour_option['sticky_header_bg_color'])) {
						$inline_css .= '.has-sticky.header-up,.has-sticky.header-down{
							background : ' . $powerhour_option['sticky_header_bg_color'] . '!important;
						}';
					}
				}
				if ($type == 'image') {
					if (!empty($powerhour_option['sticky_header_bg_img']['url'])) {
						$inline_css .= '.has-sticky.header-up,.has-sticky.header-down{
							background : url(' . $powerhour_option['sticky_header_bg_img']['url'] . ') !important;
						}';
					}
				}
				if ($type == 'transparent') {
					$inline_css .= '.has-sticky.header-up,.has-sticky.header-down{
						background : transparent !important;
					}';
				}
			}
		}

		wp_add_inline_style('power-hour-global', $inline_css);
	}



	public function powerhour_sticky_menu_color_options()
	{
		$powerhour_option = get_option('power-hour-options');
		$inline_css = '';
		if (isset($powerhour_option['sticky_menu_color_type']) && $powerhour_option['sticky_menu_color_type'] == 'custom') {
			if (isset($powerhour_option['sticky_menu_color']) && !empty($powerhour_option['sticky_menu_color'])) {
				$inline_css .= 'header.header-down .sf-menu > li > a, header.header-up .sf-menu > li > a{
						color : ' . $powerhour_option['sticky_menu_color'] . '!important;
					}';
			}

			if (isset($powerhour_option['sticky_menu_hover_color']) && !empty($powerhour_option['sticky_menu_hover_color'])) {
				$inline_css .= 'header.header-down .sf-menu li:hover > a,header.header-down .sf-menu li.current-menu-ancestor > a,header.header-down .sf-menu  li.current-menu-item > a, header.header-up .sf-menu li:hover > a,header.header-up .sf-menu li.current-menu-ancestor > a,header.header-up .sf-menu  li.current-menu-item > a{
						color : ' . $powerhour_option['sticky_menu_hover_color'] . '!important;
					}';
			}
		}
		wp_add_inline_style('power-hour-global', $inline_css);
	}

	public function powerhour_sticky_sub_menu_color_options()
	{
		$powerhour_option = get_option('power-hour-options');
		$inline_css = '';

		if (isset($powerhour_option['sticky_header_submenu_color_type']) && $powerhour_option['sticky_header_submenu_color_type'] == 'custom') {
			if (isset($powerhour_option['sticky_powerhour_header_submenu_color']) && !empty($powerhour_option['sticky_powerhour_header_submenu_color'])) {
				$inline_css .= 'header.header-down .sf-menu ul.sub-menu a, header.header-up .sf-menu ul.sub-menu a{
                color : ' . $powerhour_option['sticky_powerhour_header_submenu_color'] . ' !important;
            }';
			}

			if (isset($powerhour_option['sticky_powerhour_header_submenu_hover_color']) && !empty($powerhour_option['sticky_powerhour_header_submenu_hover_color'])) {
				$inline_css .= 'header.header-down .sf-menu li.sfHover>a,header.header-down .sf-menu li:hover>a,header.header-down .sf-menu li.current-menu-ancestor>a,header.header-down .sf-menu li.current-menu-item>a,header.header-down .sf-menu ul>li.menu-item.current-menu-parent>a,header.header-down .sf-menu ul li.current-menu-parent>a,header.header-down .sf-menu ul li .sub-menu li.current-menu-item>a,
				header.header-up .sf-menu li.sfHover>a,header.header-up .sf-menu li:hover>a,header.header-up .sf-menu li.current-menu-ancestor>a,header.header-up .sf-menu li.current-menu-item>a,header.header-up .sf-menu ul>li.menu-item.current-menu-parent>a,header.header-up .sf-menu ul li.current-menu-parent>a,header.header-up .sf-menu ul li .sub-menu li.current-menu-item>a{
                color : ' . $powerhour_option['sticky_powerhour_header_submenu_hover_color'] . ' !important;
            }';
			}

			if (isset($powerhour_option['sticky_powerhour_header_submenu_background_color']) && !empty($powerhour_option['sticky_powerhour_header_submenu_background_color'])) {
				$inline_css .= 'header.header-up .sf-menu ul.sub-menu li, header.header-down .sf-menu ul.sub-menu li {
                background : ' . $powerhour_option['sticky_powerhour_header_submenu_background_color'] . ' !important;
            }';
			}

			if (isset($powerhour_option['sticky_header_submenu_background_hover_color']) && !empty($powerhour_option['sticky_header_submenu_background_hover_color'])) {
				$inline_css .= 'header.header-up .sf-menu ul.sub-menu li:hover,header.header-up .sf-menu ul.sub-menu li.current-menu-item ,header.header-up .sf-menu ul.sub-menu li:hover,header.header-up .sf-menu ul.sub-menu li.current-menu-item,
				header.header-down .sf-menu ul.sub-menu li:hover,header.header-down .sf-menu ul.sub-menu li.current-menu-item ,header.header-down .sf-menu ul.sub-menu li:hover,header.header-down .sf-menu ul.sub-menu li.current-menu-item{
                background : ' . $powerhour_option['sticky_header_submenu_background_hover_color'] . ' !important;
            }';
			}

		}
		wp_add_inline_style('power-hour-global', $inline_css);
	}
}
