<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\Header class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;


class Header extends Component
{

	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'powerhour_header_dynamic_style'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_header_background_style'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_menu_color_options'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_sub_menu_color_options'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_burger_menu_color_options'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_action_btn_color_options'), 20);
	}

	public function powerhour_header_dynamic_style()
	{

		$page_id = get_queried_object_id();
		$header_css = '';
		if (function_exists('get_field') && get_field('acf_key_header_switch', $page_id) != 'default') {
			if (get_field('acf_key_header_switch') == 'no') {
				$header_css = 'header#default-header { 
					display : none !important;
				}';
			}
		}
		wp_add_inline_style('power-hour-global', $header_css);
	}

	public function powerhour_header_background_style()
	{
		$powerhour_option = get_option('power-hour-options');
		$dynamic_css = '';

		if (isset($powerhour_option['powerhour_header_background_type'])) {
			if (isset($powerhour_option['powerhour_header_background_type']) && $powerhour_option['powerhour_header_background_type'] != 'default') {
				$type = $powerhour_option['powerhour_header_background_type'];
				if ($type == 'color') {
					if (!empty($powerhour_option['powerhour_header_background_color'])) {
						$dynamic_css = 'header#default-header{
							background : ' . $powerhour_option['powerhour_header_background_color'] . '!important;
						}';
					}
				}
				if ($type == 'image') {
					if (!empty($powerhour_option['powerhour_header_background_image']['url'])) {
						$dynamic_css = 'header#default-header{
							background : url(' . $powerhour_option['powerhour_header_background_image']['url'] . ') !important;
						}';
					}
				}
				if ($type == 'transparent') {
					$dynamic_css = 'header#default-header{
						background : transparent !important;
					}';
				}
			}
		}
		wp_add_inline_style('power-hour-global', $dynamic_css);
	}

	public function powerhour_menu_color_options()
	{

		$powerhour_option =  get_option('power-hour-options');
		$inline_css = '';

		if (!empty($powerhour_option['menu_color']) && $powerhour_option['menu_color'] == "custom") {

			if (isset($powerhour_option['header_menu_color']) && !empty($powerhour_option['header_menu_color'])) {
				$inline_css .= '.sf-menu > li > a{
						color : ' . $powerhour_option['header_menu_color'] . '!important;
					}';
			}

			if (isset($powerhour_option['hover_menu_color']) && !empty($powerhour_option['hover_menu_color'])) {
				$inline_css .= '.sf-menu li:hover > a,.sf-menu li.current-menu-ancestor > a,.sf-menu  li.current-menu-item > a{
						color : ' . $powerhour_option['hover_menu_color'] . ' !important;
					}';
			}
		}



		wp_add_inline_style('power-hour-global', $inline_css);
	}

	public function powerhour_sub_menu_color_options()
	{
		$powerhour_option = get_option('power-hour-options');
		$inline_css = '';
		if (isset($powerhour_option['header_submenu_color_type']) && $powerhour_option['header_submenu_color_type'] == 'custom') {
			if (isset($powerhour_option['submenu_color']) && !empty($powerhour_option['submenu_color'])) {
				$inline_css .= '.sf-menu ul.sub-menu a{
                   		color : ' . $powerhour_option['submenu_color'] . ' !important; }';
			}

			if (isset($powerhour_option['hover_submenu_color']) && !empty($powerhour_option['hover_submenu_color'])) {
				$inline_css .= '.sf-menu li.sfHover>a, .sf-menu li:hover>a,.sf-menu li.current-menu-ancestor>a, .sf-menu li.current-menu-item>a, .sf-menu ul>li.menu-item.current-menu-parent>a,.sf-menu ul li.current-menu-parent>a, .sf-menu ul li .sub-menu li.current-menu-item>a
                					{  color : ' . $powerhour_option['hover_submenu_color'] . ' !important;  }';
			}

			if (isset($powerhour_option['submenu_background_color']) && !empty($powerhour_option['submenu_background_color'])) {
				$inline_css .= '.sf-menu ul.sub-menu li{
                   background : ' . $powerhour_option['submenu_background_color'] . ' !important;  }';
			}

			if (isset($powerhour_option['hover_submenu_bg_color']) && !empty($powerhour_option['hover_submenu_bg_color'])) {
				$inline_css .= '.sf-menu ul.sub-menu li:hover,.sf-menu ul.sub-menu li.current-menu-item{
                   background : ' . $powerhour_option['hover_submenu_bg_color'] . ' !important;   }';
			}
		}
		wp_add_inline_style('power-hour-global', $inline_css);
	}

	public function powerhour_burger_menu_color_options()
	{
		$powerhour_option = get_option('power-hour-options');
		$inline_css = '';

		if (isset($powerhour_option['burger_menu_button_type']) && $powerhour_option['burger_menu_button_type'] == 'custom') {

			if (isset($powerhour_option['burger_menu_icon']) && !empty($powerhour_option['burger_menu_icon'])) {
				$inline_css .= ' .menu-btn .line {
                    background-color : ' . $powerhour_option['burger_menu_icon'] . ' !important;
                }';
			}

			if (isset($powerhour_option['burger_menu_popup_bg']) && !empty($powerhour_option['burger_menu_popup_bg'])) {
				$inline_css .= ' .powerhour-mobile-menu {
                    background : ' . $powerhour_option['burger_menu_popup_bg'] . ' !important;
                }';
			}
			

			if (isset($powerhour_option['burger_menu_color']) && !empty($powerhour_option['burger_menu_color'])) {
				$inline_css .= '.powerhour-mobile-menu .navbar-nav > li > a, .powerhour-mobile-menu .navbar-nav li > .toggledrop svg{ 
					color : ' . $powerhour_option['burger_menu_color'] . ' !important;
				}';
			}


			if (isset($powerhour_option['burger_hover_menu_color']) && !empty($powerhour_option['burger_hover_menu_color'])) {
				$inline_css .= '.powerhour-mobile-menu .navbar-nav li.current-menu-item > .toggledrop svg, .powerhour-mobile-menu .navbar-nav li.current-menu-item > a, .powerhour-mobile-menu .navbar-nav li .sub-menu li:hover > a, .powerhour-mobile-menu .navbar-nav li:hover > .toggledrop svg, .powerhour-mobile-menu .navbar-nav li:hover > a, .powerhour-mobile-menu ul > li.current-menu-ancestor > .toggledrop svg, .powerhour-mobile-menu ul > li.current-menu-ancestor > a, .powerhour-mobile-menu ul li .sub-menu li.current-menu-item > a, .powerhour-mobile-menu ul li .sub-menu li.menu-item.current-menu-ancestor > a{
			        color : ' . $powerhour_option['burger_hover_menu_color'] . ' !important;
				}';
			}

			if (isset($powerhour_option['burger_submenu_color']) && !empty($powerhour_option['burger_submenu_color'])) {
				$inline_css .= '.powerhour-mobile-menu .navbar-nav li .sub-menu li a , .powerhour-mobile-menu .navbar-nav li .sub-menu li svg{
			        color : ' . $powerhour_option['burger_submenu_color'] . ' !important;
				}';
			}
		}
		wp_add_inline_style('power-hour-global', $inline_css);
	}

	public function powerhour_action_btn_color_options()
	{
		$powerhour_option = get_option('power-hour-options');
		$inline_css = '';

		if (isset($powerhour_option['button_color']) && $powerhour_option['button_color'] == 'custom') {

			if (isset($powerhour_option['button_bg_color']) && !empty($powerhour_option['button_bg_color'])) {
				$inline_css .= '
            header .powerhour-shop-btn-holder  #btn-search svg,header .search_count #btn-search{
                color : ' . $powerhour_option['button_bg_color'] . ' !important;
            }';
			}
		}

		if (!empty($inline_css)) {
			wp_add_inline_style('power-hour-global', $inline_css);
		}
	}
}
