<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\General class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class General extends Component
{
	public function __construct()
	{

		add_action('wp_enqueue_scripts', array($this, 'powerhour_create_general_style'), 20);
	}

	public function powerhour_create_general_style()
	{

		$powerhour_option = get_option('power-hour-options');
		$general_var = ':root { ';

		if (isset($powerhour_option['grid_container']) && !empty($powerhour_option['grid_container'])) {
			$general = $powerhour_option['grid_container']['width'];
			$general_var .= ' --content-width: ' . $general . ' !important;';
		}
		$general_var .= '}';
		if ($powerhour_option['body_set_option'] == 1) {
			if (
				isset($powerhour_option['body_color'])  && !empty($powerhour_option['body_color'])
			) {
				$general = $powerhour_option['body_color'];
				$general_var .= ' body { background : ' . $general . ' !important; }';
			}
		}
		if ($powerhour_option['body_set_option'] == 3) {
			if (isset($powerhour_option['body_image']['url']) && !empty($powerhour_option['body_image']['url'])) {
				$general = $powerhour_option['body_image']['url'];
				$general_var .= '
					body { background-image: url(' . $general . ') !important; }';
			}
		}

		if ($powerhour_option['back_to_top_btn'] == 'no') {
			if (isset($powerhour_option['back_to_top_btn']) && !empty($powerhour_option['back_to_top_btn'])) {
				$general_var .= '
					#back-to-top { display: none !important; }';
			}
		}

		wp_add_inline_style('power-hour-global', $general_var);
	}
}
