<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\Footer class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class Footer extends Component
{

	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'powerhour_footer_dynamic_style'), 20);
	}

	public function powerhour_footer_dynamic_style()
	{
		
		$page_id = get_queried_object_id();
		$powerhour_options = get_option('power-hour-options');
		$footer_css = '';
		if (function_exists('get_field') && get_field('acf_key_footer_switch', $page_id) != 'default') {
			if (get_field('acf_key_footer_switch') == 'no') {
				$footer_css = 'footer { 
					display : none !important;
				}';
			}
		} else if (isset($powerhour_options['footer_top'])) {

			if ($powerhour_options['footer_top'] == 'no') {
				$footer_css = '.footer-top { 
					display : none !important;
				}';
			}
		}

		$footer_bg_color = '';
		
		# footer background color options [ Redux & ACF ]
		if (function_exists('get_field') && get_field('field_footer_bg_color') && !empty(get_field('field_footer_bg_color'))) {
			$footer_bg_color = get_field('field_footer_bg_color');
			$footer_css .= ".footer {
						background-color: $footer_bg_color !important;
					}";
		} else {
			if (isset($powerhour_options['change_footer_color']) && $powerhour_options['change_footer_color'] == '0') {
				if (isset($powerhour_options['footer_bg_color']) && !empty($powerhour_options['footer_bg_color'])) {
					
					$footer_bg_color = $powerhour_options['footer_bg_color'];
					$footer_css .= ".footer {
						background-color: $footer_bg_color !important;
					}";
				}
			}
		}

		wp_add_inline_style('power-hour-global', $footer_css);
	}
}
