<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\Banner class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class Color extends Component
{

	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'powerhour_color_options'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_banner_title_color'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_layout_color'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_loader_color'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_bg_color'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_opacity_color'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_header_radio'), 20);
		add_action('wp_enqueue_scripts', array($this, 'powerhour_footer_color'), 20);
	}

	public function powerhour_color_options()
	{

		$powerhour_option = get_option('power-hour-options');
		if (function_exists('get_field') && class_exists('ReduxFramework')) {
			$color_var = ':root { ';
			if (isset(get_field('key_color_pallete')['primary_color']) && !empty(get_field('key_color_pallete')['primary_color']) && get_field('key_color_switch') === "custom") {
				$color = get_field('key_color_pallete')['primary_color'];
				$color_var .= '--color-theme-primary: ' . $color . ' !important;';
			} else {
				if ($powerhour_option['custom_color_switch'] == 'yes' && isset($powerhour_option['primary_color']) && !empty($powerhour_option['primary_color'])) {
					$color = $powerhour_option['primary_color'];
					$color_var .= '--color-theme-primary: ' . $color . ' !important;';
				}
			}

			if (isset(get_field('key_color_pallete')['secondary_color']) && !empty(get_field('key_color_pallete')['secondary_color']) && get_field('key_color_switch') === "custom") {
				$color = get_field('key_color_pallete')['secondary_color'];
				$color_var .= '--color-theme-secondary: ' . $color . ' !important;';
			} else {
				if ($powerhour_option['custom_color_switch'] == 'yes' && isset($powerhour_option['secondary_color']) && !empty($powerhour_option['secondary_color'])) {
					$color = $powerhour_option['secondary_color'];
					$color_var .= '--color-theme-secondary: ' . $color . ' !important;';
				}
			}

			if (isset(get_field('key_color_pallete')['text_color']) && !empty(get_field('key_color_pallete')['text_color']) && get_field('key_color_switch') === "custom") {
				$color = get_field('key_color_pallete')['text_color'];
				$color_var .= '--global-font-color: ' . $color . ' !important;';
			} else {
				if ($powerhour_option['custom_color_switch'] == 'yes' && isset($powerhour_option['text_color']) && !empty($powerhour_option['text_color'])) {
					$color = $powerhour_option['text_color'];
					$color_var .= '--global-font-color: ' . $color . ' !important;';
				}
			}

			if (isset(get_field('key_color_pallete')['title_color']) && !empty(get_field('key_color_pallete')['title_color']) && get_field('key_color_switch') === "custom") {
				$color = get_field('key_color_pallete')['title_color'];
				$color_var .= ' --global-font-title: ' . $color . ' !important;';
			} else {
				if ($powerhour_option['custom_color_switch'] == 'yes' && isset($powerhour_option['title_color']) && !empty($powerhour_option['title_color'])) {
					$color = $powerhour_option['title_color'];
					$color_var .= ' --global-font-title: ' . $color . ' !important;';
				}
			}

			$color_var .= '}';
			wp_add_inline_style('power-hour-global', $color_var);
		}
	}

	public function powerhour_banner_title_color()
	{
		//Set Body Color
		$powerhour_option = get_option('power-hour-options');

		if (!empty($powerhour_option['bg_title_color'])) {
			$bg_title_color = $powerhour_option['bg_title_color'];
		}

		$bn_title_color = "";

		if (!empty($bg_title_color)) {
			$bn_title_color .= "
        .powerhour-breadcrumb-one .title{
            color: $bg_title_color !important;
        }";
		}
		wp_add_inline_style('power-hour-global', $bn_title_color);
	}

	public function powerhour_layout_color()
	{
		//Set Body Color
		$powerhour_option = get_option('power-hour-options');

		if (!empty($powerhour_option['powerhour_layout_color'])) {
			$powerhour_layout_color = $powerhour_option['powerhour_layout_color'];
		}
		$body_accent_color = "";

		if (function_exists('get_field')) {
			$page_id_body_col = get_queried_object_id();
			$key_body_bg_col = get_field('key_body', $page_id_body_col);
			if (isset($key_body_bg_col['body_variation']) && $key_body_bg_col['body_variation'] == 'has_body_color') {
				if (isset($key_body_bg_col['acf_body_color']) && !empty($key_body_bg_col['acf_body_color'])) {
					$body_back_color = $key_body_bg_col['acf_body_color'];
				}
			}
		}

		if (isset($body_back_color) && !empty($body_back_color)) {
			$body_accent_color .= "
        body {
            background-color: $body_back_color !important;
        }";
		} else if (!empty($powerhour_option['layout_set']) && $powerhour_option['layout_set'] == "1" && $key_body_bg_col['body_variation'] != 'default') {
			if (!empty($powerhour_layout_color) && $powerhour_layout_color != '#ffffff') {
				$body_accent_color .= "
            body {
                background-color: $powerhour_layout_color !important;
            }";
			}
		} else {
			$body_accent_color = "";
		}

		wp_add_inline_style('power-hour-style', $body_accent_color);
	}

	public function powerhour_loader_color()
	{
		//Set Loader Background Color
		$powerhour_option = get_option('power-hour-options');

		if (!empty($powerhour_option['loader_color'])) {
			$loader_color = $powerhour_option['loader_color'];
		}
		$ld_color = "";

		if (!empty($loader_color) && $loader_color != '#ffffff') {
			$ld_color .= "#loading {
								background : $loader_color !important;
							}";
		}
		wp_add_inline_style('power-hour-style', $ld_color);
	}

	public function powerhour_bg_color()
	{
		//Set Background Color
		$powerhour_option = get_option('power-hour-options');

		if (!empty($powerhour_option['bg_color'])) {
			$bg_color = $powerhour_option['bg_color'];
		}
		$background_color = "";

		if (!empty($powerhour_option['bg_type']) && $powerhour_option['bg_type'] == "1") {
			if (!empty($bg_color) && $bg_color != '#ffffff') {
				$background_color .= "
            .powerhour-bg-over {
                background : $bg_color !important;
            }";
			}
		}
		wp_add_inline_style('power-hour-style', $background_color);
	}

	public function powerhour_opacity_color()
	{
		//Set Background Opacity Color
		$powerhour_option = get_option('power-hour-options');

		if (!empty($powerhour_option['bg_opacity']) && $powerhour_option['bg_opacity'] == "3") {
			$bg_opacity = $powerhour_option['opacity_color']['rgba'];
		}
		$op_color = "";

		if (!empty($powerhour_option['bg_opacity']) && $powerhour_option['bg_opacity'] == "3") {
			if (!empty($bg_opacity) && $bg_opacity != '#ffffff') {
				$op_color .= "
        .breadcrumb-video::before,.breadcrumb-bg::before, .breadcrumb-ui::before {
            background : $bg_opacity !important;
        }";
			}
		}
		wp_add_inline_style('power-hour-style', $op_color);
	}

	public function powerhour_header_radio()
	{
		//Set Text Logo Color
		$powerhour_option = get_option('power-hour-options');

		if (!empty($powerhour_option['header_color'])) {
			$logo = $powerhour_option['header_color'];
		}
		$logo_color = "";

		if (!empty($powerhour_option['header_radio']) && $powerhour_option['header_radio'] == "1") {
			if (!empty($logo) && $logo != '#ffffff') {
				$logo_color .= "
            .logo-text {
                color : $logo !important;
            }";
			}
		}
		wp_add_inline_style('power-hour-style', $logo_color);
	}

	public function powerhour_footer_color()
	{
		//Set Footer Background Color
		$powerhour_option = get_option('power-hour-options');

		if (!empty($powerhour_option['change_footer_color']) && $powerhour_option['change_footer_color'] == "0") {
			$f_color = $powerhour_option['footer_color'];
		}
		$footer_color = "";
		if (function_exists('get_field') && !empty(get_field('footer_background_color'))) {
			$f_back_color = get_field('footer_background_color');

			$footer_color .= "
                    .powerhour-over-dark-90 {
                        background : $f_back_color !important;
                    }";
		} else if (!empty($powerhour_option['change_footer_color']) && $powerhour_option['change_footer_color'] == "0") {
			if (!empty($f_color) && $f_color != '#ffffff') {
				$footer_color .= "
            .powerhour-over-dark-90 {
                background : $f_color !important;
            }";
			}
		} else {
			$footer_color = '';
		}

		wp_add_inline_style('power-hour-style', $footer_color);
	}
}
