<?php
/**
 * PowerHour\Utility\Dynamic_Style\Styles\BodyContainer class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class BodyContainer extends Component
{

	public function __construct()
	{
		if (class_exists('ReduxFramework')) {
			add_action('wp_enqueue_scripts', array( $this,'powerhour_container_width'), 21);
		}
	}

	public function powerhour_container_width()
	{
		$powerhour_options = get_option('power-hour-options');

		$box_container_width = "";

		if (isset($powerhour_options['opt-slider-label']) && !empty($powerhour_options['opt-slider-label'])) {

			$container_width = $powerhour_options['opt-slider-label'];

			$box_container_width = "body.iq-container-width .container,
        							body.iq-container-width .elementor-section.elementor-section-boxed>
        							.elementor-container { max-width: " . $container_width . "px; } ";
		}


		wp_add_inline_style('power-hour-style',
			$box_container_width
		);
	}
}
