<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\Banner class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class Banner extends Component
{

    public function __construct()
    {
        add_action('wp_enqueue_scripts', array($this, 'powerhour_banner_dynamic_style'), 20);
        add_action('wp_enqueue_scripts', array($this, 'powerhour_opacity_color'), 20);
        add_action('wp_enqueue_scripts', array($this, 'powerhour_featured_hide'), 20);
        add_action('wp_enqueue_scripts', array($this, 'powerhour_breadcrumb_bgimage'), 20);
    }

    public function powerhour_breadcrumb_bgimage()
    {
        $page_id = get_queried_object_id();
        $powerhour_options = get_option('power-hour-options');
        $dynamic_css = '';
        $id = '';
        if(function_exists('get_field')){
        $id = get_field('acf_blog_detail_style', $page_id);
        }

        if ($id == 3) {
            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($page_id), "full");
            if (!empty($full_image[0])) {

                $dynamic_css .=
                    '.powerhour-breadcrumb-one{
                        background-image: url(' . $full_image[0] . ') !important;
                        background-attachment: fixed !important;

                }';
            }
            wp_add_inline_style('power-hour-global', $dynamic_css);
        } elseif ($powerhour_options['blog_detail_style'] == 3 && get_post_type() == 'post') {
            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($page_id), "full");
            if (!empty($full_image[0])) {

                $dynamic_css .=
                    '.powerhour-breadcrumb-one{
                        background-image: url(' . $full_image[0] . ') !important;
                }';
            }
            wp_add_inline_style('power-hour-global', $dynamic_css);
        }
    }

    public function powerhour_banner_dynamic_style()
    {
        $page_id = get_queried_object_id();
        $powerhour_options = get_option('power-hour-options');
        $dynamic_css = '';

        if (function_exists('get_field') && get_field('field_display_banner', $page_id) != 'default') {
            if (get_field('field_display_banner', $page_id) == 'no') {

                $dynamic_css .=
                    '.powerhour-breadcrumb-one { display: none !important; }
                    .content-area .site-main {padding : 0 !important; }';
            }
        } else if (isset($powerhour_options['display_banner'])) {
            if ($powerhour_options['display_banner'] == 'no') {
                $dynamic_css .=
                    '.powerhour-breadcrumb-one { display: none !important; }
                    .content-area .site-main {padding : 0 !important; }';
            }
        }
        $key = (function_exists('get_field')) ? get_field('field_display_breadcrumb', $page_id) : "";
        if (isset($key['display_title']) && $key['display_title'] != 'default'  && $key['display_title'] == 'no') {
            $dynamic_css .=
                '.powerhour-breadcrumb-one .title { display: none !important; }';
        } else if (isset($powerhour_options['display_title'])) {

            if ($powerhour_options['display_title'] == 'no') {
                $dynamic_css .=
                    '.powerhour-breadcrumb-one .title { display: none !important; }';
            }
        }
        
        if (isset($key['display_breadcumb']) && $key['display_breadcumb'] != 'default'  && $key['display_breadcumb'] == 'no') {
            $dynamic_css .=
                '.powerhour-breadcrumb-one .breadcrumb { display: none !important; }';
        } else if (isset($powerhour_options['display_breadcumb'])) {

            if ($powerhour_options['display_breadcumb'] == 'no') {
                $dynamic_css .=
                    '.powerhour-breadcrumb-one .breadcrumb { display: none !important; }';
            }
        }

        if (isset($powerhour_options['bg_title_color'])) {

            if ($powerhour_options['bg_title_color'] == 'yes') {
                $dynamic = $powerhour_options['bg_title_color'];
                $dynamic_css .=
                    '.powerhour-breadcrumb-one .title { color: ' . $dynamic . ' !important; }';
            }
        }
        if (isset($powerhour_options['bg_type'])) {
            $opt = $powerhour_options['bg_type'];
            if ($opt == '1') {
                if (isset($powerhour_options['bg_color']) && !empty($powerhour_options['bg_color'])) {
                    $dynamic = $powerhour_options['bg_color'];
                    $dynamic_css .=
                        '.powerhour-breadcrumb-one { background: ' . $dynamic . ' !important; }';
                }
            }
            if ($opt == '2') {
                if (isset($powerhour_options['banner_image']['url'])) {
                    $dynamic = $powerhour_options['banner_image']['url'];
                    $dynamic_css .=
                        '.powerhour-breadcrumb-one { background-image: url(' . $dynamic . ') !important; }';
                }
            }
        }

        wp_add_inline_style('power-hour-global', $dynamic_css);
    }
    public function powerhour_opacity_color()
    {
        //Set Background Opacity Color
        $powerhour_options = get_option('power-hour-options');

        if (!empty($powerhour_options['bg_opacity']) && $powerhour_options['bg_opacity'] == "3") {
            $bg_opacity = $powerhour_options['opacity_color']['rgba'];
        }
        $dynamic_css = '';

        if (!empty($powerhour_options['bg_opacity']) && $powerhour_options['bg_opacity'] == "3") {
            if (!empty($bg_opacity) && $bg_opacity != '#ffffff') {
                $dynamic_css .= "
            .breadcrumb-video::before,.breadcrumb-bg::before, .breadcrumb-ui::before {
                background : $bg_opacity !important;
            }";
            }
        }
        wp_add_inline_style('power-hour-global', $dynamic_css);
    }

    public function powerhour_featured_hide() {
        $powerhour_options = get_option('power-hour-options');
        $featured_hide = '';
        $post_format = "";

        if(isset($powerhour_options['posts_select'])) {
            $posts_format = $powerhour_options['posts_select'];
            $post_format = get_post_format();

            if(in_array(get_post_format(),$posts_format)) {
                $featured_hide .= '.powerhour-blog-main-list .format-'.$post_format.' .powerhour-blog-box .powerhour-blog-image img { display : none !important }';
            }
            wp_add_inline_style('power-hour-global', $featured_hide);
        }
    }
}
