<?php

/**
 * PowerHour\Utility\Dynamic_Style\Styles\AdditionalCode class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Dynamic_Style\Styles;

use PowerHour\Utility\Dynamic_Style\Component;
use function add_action;

class AdditionalCode extends Component
{

    public function __construct()
    {
        add_action('wp_enqueue_scripts', array($this, 'powerhour_inline_css'), 20);
        add_action('wp_enqueue_scripts', array($this, 'powerhour_inline_js'), 20);
    }

    public function powerhour_inline_css()
    {
        $powerhour_options = get_option('power-hour-options');
        $custom_style = "";

        if (!empty($powerhour_options['css_code'])) {

            $powerhour_css_code = $powerhour_options['css_code'];
            $custom_style = $powerhour_css_code;
        }
        wp_add_inline_style('power-hour-global', $custom_style);
    }

    public function powerhour_inline_js()
    {
        $powerhour_option = get_option('power-hour-options');

        $custom_js = "";
        if (!empty($powerhour_option['powerhour_js_code'])) {

            $powerhour_js_code = $powerhour_option['powerhour_js_code'];

            $custom_js = $powerhour_js_code;
            wp_register_script('power-hour-custom-js', '', [], '', true);
            wp_enqueue_script('power-hour-custom-js');
            wp_add_inline_script('power-hour-custom-js', wp_specialchars_decode($custom_js));
        }
    }
}
