<?php

/**
 * PowerHour\Utility\Actions\Component class
 *
 * @package power_hour
 */

namespace PowerHour\Utility\Actions;

use PowerHour\Utility\Component_Interface;
use PowerHour\Utility\Templating_Component_Interface;
use function add_action;

/**
 * Class for managing comments UI.
 *
 * Exposes template tags:
 * * `power_hour()->the_comments( array $args = array() )`
 *
 * @link https://wordpress.org/plugins/amp/
 */
class Component implements Component_Interface, Templating_Component_Interface
{
	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */
	public function get_slug(): string
	{
		return 'actions';
	}
	public function initialize()
	{
	}
	/**
	 * Gets template tags to expose as methods on the Template_Tags class instance, accessible through `power_hour()`.
	 *
	 * @return array Associative array of $method_name => $callback_info pairs. Each $callback_info must either be
	 *               a callable or an array with key 'callable'. This approach is used to reserve the possibility of
	 *               adding support for further arguments in the future.
	 */
	public function template_tags(): array
	{
		return array(
			'powerhour_get_blog_readmore_link' => array($this, 'powerhour_get_blog_readmore_link'),
			'powerhour_get_blog_readmore' => array($this, 'powerhour_get_blog_readmore'),
			'powerhour_get_comment_btn' => array($this, 'powerhour_get_comment_btn'),
			'powerhour_get_comment_reply' => array($this, 'powerhour_get_comment_reply'),
			'powerhour_get_woo_comment_btn' => array($this, 'powerhour_get_woo_comment_btn'),
		);
	}

	//** Blog Read More Button Link **//
	public function powerhour_get_blog_readmore_link()
	{
		echo '<div class="blog-button">		
				<a class="powerhour-button powerhour-button-link" href="' . get_the_permalink() . '">' . esc_html__('Read More', 'power-hour') . ' 
					
				</a>
			</div>';
	}


	//** Blog Read More Button **//
	public function powerhour_get_blog_readmore($link, $label)
	{
		echo '<div class="blog-button"><a class="powerhour-button" href="' . esc_url($link) . '">' . esc_html($label) . '</a></div>';
	}


	//** Comment Submit Button **//
	public function powerhour_get_comment_btn()
	{
		return '<button name="submit" type="submit" id="submit" class="submit powerhour-button" value="' . esc_attr__('Post Comment' . 'power-hour') . '" >
				<span class="powerhour-main-btn">
				<span class="text-btn">' . esc_html__('Post Comment', 'power-hour') . '</span></span>
				</button>';
	}

	//** Comment Reply Button **//
	public function powerhour_get_comment_reply($depth)
	{
		if ($depth < get_option('thread_comments_depth') && comments_open()) {
			$reply_to = esc_html__("Reply to ", "power-hour");
			$reply_to .= get_comment_author(); ?>
			<div class="reply powerhour-reply powerhour-button-style-2">
				<a rel="nofollow" class="comment-reply-link powerhour-button powerhour-button-link" href="<?php echo get_the_permalink(); ?>?replytocom=<?php comment_ID(); ?>#respond" data-commentid="<?php comment_ID(); ?>" data-postid="<?php the_ID(); ?>" data-belowelement="div-comment-<?php comment_ID(); ?>" data-respondelement="respond" data-replyto="<?php echo esc_attr($reply_to); ?>" aria-label="<?php echo esc_attr($reply_to); ?>">
					<?php echo esc_html__('Reply', 'power-hour'); ?>
				</a>
			</div>
<?php }
	}

	public function powerhour_get_woo_comment_btn($tag = 'a',  $label = 'Post Comment', $show_icon = true, $attr = array())
	{

		$icon = $show_icon ? '<i class="" aria-hidden="true"></i>' : '';

		$classes = isset($attr['class']) ? $attr['class'] : '';

		$attr_render = '';
		// $attr_render= ($tag=='button')? '' :'';

		foreach ($attr as $key => $value) {
			if ($key != 'class') {
				$attr_render .= $key . '=' . $value . ' ';
			}
		}

		return '<' . tag_escape($tag) . '  class="powerhour-button btn ' . esc_attr($classes) . '  " ' . esc_attr($attr_render) . '  >
				' . esc_html($label) .
			$icon .
			' </' . tag_escape($tag) . '>';
	}
}
