<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

use Elementor\Plugin;

?>
<!doctype html>
<html <?php language_attributes(); ?> class="no-js">

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
  <?php $powerhour_option = get_option('power-hour-options'); ?>
  <link rel="profile" href="<?php echo is_ssl() ? 'https:' : 'http:' ?>//gmpg.org/xfn/11">
  <?php
  if (!function_exists('has_site_icon') || !wp_site_icon()) {
  ?>
    <link rel="shortcut icon" href="<?php echo esc_url(get_template_directory_uri() . '/assets/images/redux/favicon.png'); ?>" />
  <?php
  }
  ?>
  <?php wp_head(); ?>
</head>
<?php
//--- class setting for vertical menu start---// 
$site_classes = '';
$has_sticky = '';
$header_hover ='';
$default_header_container = '';
if (class_exists('ReduxFramework')) {
  //site-class
  $site_classes .= 'powerhour';
  //sticky-default header
  if (isset($powerhour_option['display_sticky_header']) && $powerhour_option['display_sticky_header'] == 'yes') {
    $has_sticky = ' has-sticky';
  }

  // header hover
  if (isset($powerhour_option['header_hover_style']) && $powerhour_option['header_hover_style'] === 'style-2') { 
      $header_hover = 'sub-menu-hover';
     } 

 
  // header container
  if (isset($powerhour_option['header_layout']) && $powerhour_option['header_layout'] == 'default') {
    $default_header_container = !empty($powerhour_option['header_container']) ? $powerhour_option['header_container'] : 'container-fluid';
  }
  //loader
  if (isset($powerhour_option['display_loader']) && $powerhour_option['display_loader'] === 'yes') {
    if (!empty($powerhour_option['loader_gif']['url'])) {
      $bgurl = $powerhour_option['loader_gif']['url'];
    }
  }
} else {
  $has_sticky = ' has-sticky';
  $default_header_container = 'container-fluid';
}
// position
if (function_exists('get_field') && class_exists('ReduxFramework')) {
  $id = (get_queried_object_id()) ? get_queried_object_id() : '';
  $h_position = !empty($id) ? get_post_meta($id, 'header_postion', true) : '';
  if ($h_position === 'over') {
    $site_classes .= ' header-over';
  } else {
    if (isset($powerhour_option['header_postion']) && $powerhour_option['header_postion'] == 'over') {
      $site_classes .= ' header-over';
    }
  }
}

?>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>

  <!-- loading -->
  <?php
  $bgurl = '';
  if (class_exists('ReduxFramework')) {
    if (isset($powerhour_option['display_loader']) && $powerhour_option['display_loader'] === 'yes') {
      if (!empty($powerhour_option['loader_gif']['url'])) {
        $bgurl = $powerhour_option['loader_gif']['url'];
      }
    }
  } else {
    $bgurl = get_template_directory_uri() . '/assets/images/redux/loader.gif';
  }
  if (!empty($bgurl)) {
  ?>
    <div id="loading">
      <div id="loading-center">
        <img src="<?php echo esc_url($bgurl); ?>" alt="<?php esc_attr_e('loader', 'power-hour'); ?>">
      </div>
    </div>
  <?php } ?>
  <!-- loading End -->
  <div id="page" class="site <?php echo esc_attr(trim($site_classes)); ?>">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'power-hour'); ?></a>
    <?php
    $is_default_header = true;
    $header_response = '';
    if (function_exists('get_field') && class_exists('ReduxFramework')) {
      $id = (get_queried_object_id()) ? get_queried_object_id() : '';
      $header_display = !empty($id) ? get_post_meta($id, 'display_header', true) : '';
      $header_layout = !empty($id) ? get_post_meta($id, 'header_layout_type', true) : '';
      $header_name = !empty($id) ? get_post_meta($id, 'header_layout_name', true) : '';

      if ($header_display === 'yes' && $header_layout === 'custom' && !empty($header_name)) {
        $is_default_header = false;
        $header = $header_name;
        $has_sticky = '';
        $my_layout = get_page_by_path($header, '', 'iqonic_hf_layout');
        $header_response =  Plugin::instance()->frontend->get_builder_content_for_display($my_layout->ID);
      } else if (isset($powerhour_option['header_layout']) && $powerhour_option['header_layout'] == 'custom') {
        $is_default_header = false;
        $header = $powerhour_option['menu_style'];
        $has_sticky = '';
        $my_layout = get_page_by_path($header, '', 'iqonic_hf_layout');
        $header_response =  Plugin::instance()->frontend->get_builder_content_for_display($my_layout->ID);
      }
    } ?>

    <header class="header-default<?php echo esc_attr($has_sticky);?> <?php echo esc_attr($header_hover);?>" id="default-header">
      <?php
      if (!$is_default_header && !empty($header_response)) {
        echo function_exists('iqonic_return_elementor_res') ? iqonic_return_elementor_res($header_response) : $header_response;
      } else {
        $is_default_header = true;
      }
      if ($is_default_header) {
      ?>
        <div class="<?php echo esc_attr($default_header_container); ?>">
          <div class="row">
            <div class="col-md-12">
              <?php
              get_template_part('template-parts/header/navigation');
              ?>
            </div>
          </div>
        </div>  
      <?php
      }
      ?>
    </header><!-- #masthead -->
    
    <?php if ($is_default_header) : ?>
      <div class="powerhour-mobile-menu">
        <?php get_template_part('template-parts/header/navigation', 'mobile'); ?>
      </div>
    <?php endif; ?>
    <?php get_template_part('template-parts/breadcrumb/breadcrumb'); ?>