<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package power_hour
 */

namespace PowerHour\Utility;

use Elementor\Plugin;

$footer_class = '';
$powerhour_options = get_option('power-hour-options');
if (isset($powerhour_options['display_footer_bg_image'])) {
	$options = $powerhour_options['display_footer_bg_image'];
	if ($options == "yes") {
		if (isset($powerhour_options['footer_bg_image']['url'])) {
			$bgurl = $powerhour_options['footer_bg_image']['url'];
		}
	}
}
?>
<?php
do_action('powerhour_add_extra_footer');

$is_default = true;
if (function_exists('get_field') && class_exists('ReduxFramework')) {
	$id = (get_queried_object_id()) ? get_queried_object_id() : '';
	$footer_display = !empty($id) ? get_post_meta($id, 'display_footer', true) : '';
	$footer_layout = !empty($id) ? get_post_meta($id, 'footer_layout_type', true) : '';
	$footer_name = !empty($id) ? get_post_meta($id, 'footer_layout_name', true) : '';
	$year = date('Y');

	if ($footer_display === 'yes' && $footer_layout !== 'default' && !empty($footer_name)) {
		$is_default = false;
		$footer = $footer_name;
		$my_layout = get_page_by_path($footer, '', 'iqonic_hf_layout');
		$footer_response =  Plugin::instance()->frontend->get_builder_content_for_display($my_layout->ID);
		$footer_response = str_replace("{{year}}", $year, $footer_response);
		echo function_exists('iqonic_return_elementor_res') ? iqonic_return_elementor_res($footer_response) : $footer_response;
	} else if (isset($powerhour_options['footer_layout']) && $powerhour_options['footer_layout'] == 'custom' && !empty($powerhour_options['footer_style'])) {
		$is_default = false;
		$footer = isset($powerhour_options['footer_style']) ? $powerhour_options['footer_style']:'';
		$my_layout = get_page_by_path($footer, '', 'iqonic_hf_layout');
		$footer_response =  Plugin::instance()->frontend->get_builder_content_for_display($my_layout->ID);
		$footer_response = str_replace("{{year}}", $year, $footer_response);
		echo function_exists('iqonic_return_elementor_res') ? iqonic_return_elementor_res($footer_response) : $footer_response;
	}
}

if ($is_default) { ?>
	<footer id="colophon" class="footer " <?php if (!empty($bgurl)) { ?> style="background-image: url(<?php echo esc_url($bgurl); ?> ) !important;" <?php } ?>>
		<?php
		get_template_part('template-parts/footer/widget');
		get_template_part('template-parts/footer/info');
		?>

	</footer><!-- #colophon -->
      <?php 
} ?>
<!-- === back-to-top === -->
<div id="back-to-top">
	<a class="top" id="top" href="#top">
		<svg width="20" height="34" viewBox="0 0 20 34" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.8781 7.79639H18.2375V9.95265H13.8781V7.79639Z" fill="#222222" />
			<path d="M1.34442 7.79639H5.70384V9.95265H1.34442V7.79639Z" fill="#222222" />
			<path d="M8.97375 0.249512L11.1535 0.249512V4.56204H8.97375V0.249512Z" fill="#222222" />
			<path d="M8.15637 15.4229H11.4259V33.7511H8.15637V15.4229Z" fill="#222222" />
			<path d="M16.8489 24.1517L9.79098 17.6355L2.73308 24.1496L0.503235 21.7863L8.67715 14.2394C9.30491 13.6572 10.2792 13.6572 10.907 14.2394L19.0809 21.7863L16.8489 24.1517Z" fill="#222222" />
		</svg>
	</a>
</div>
<!-- === back-to-top End === -->
</div><!-- #page -->
<?php wp_footer(); ?>
</body>

</html>