<?php

namespace PowerHour\Utility;

/**
 * Template Name: Centered Stack
 * Template Post Type: portfolio
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress

 * @since 1.0
 * @version 1.0
 */
power_hour()->powerhour_singleportfolio();

get_header();

$gallery_image_ids =  get_post_meta(get_the_ID(), "iqonic_gallery_selected_images", true);
$gallery_image_ids = !empty($gallery_image_ids) ? explode(",", trim($gallery_image_ids, ",")) : '';
$categories = wp_get_post_terms(get_the_ID(), "portfolio_categories");
?>
<div id="primary" class="content-area">
    <main id="main" class="site-main pt-0">
        <div class="single-portfolio-widget centered-stack">
            <div class="container-fluid powerhour-img-full">
                <?php echo wp_get_attachment_image(get_post_thumbnail_id(), "full", false, ['srcset' => wp_get_attachment_image_srcset(get_post_thumbnail_id())]); ?>
            </div>
            <div class="container powerhour-container-fluid">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="portfolio-detail-main wow animated">
                            <div class="portfolio-info-main">
                                <h3 class="portfolio-title">
                                    <?php echo get_the_title(); ?>
                                </h3>
                                <p class="powerhour-desc">
                                    <?php
                                    echo get_the_excerpt();
                                    ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <?php the_content(); ?>
                        </div>

                    </div>
                    <div class="col-lg-4">
                        <!-- meta title end -->
                        <div class="meta-container">

                            <div class="single-porfolio-category">
                                <span class="label">
                                    <?php esc_html_e('Client Name :', 'power-hour'); ?></span>
                                <span class="client-name">
                                    <?php
                                    $key = get_field('key_pjros12gdfgd', get_the_ID());
                                    echo esc_html($key['iqonic_portfolio_client']);
                                    ?></span>
                            </div>

                            <div class="single-porfolio-category">
                                <span class="label"><?php esc_html_e('Category :', 'power-hour'); ?> </span>
                                <?php
                                if (!empty($categories)) {
                                    foreach ($categories as $category) {
                                        if (!empty($category->name)) {
                                            echo "<a href='" . get_term_link($category->term_id) . "'><span class='label-category'>$category->name</span></a>";
                                        }
                                    }
                                }
                                ?>
                            </div>
                            <div class="single-porfolio-category">
                                <span class="label"><?php esc_html_e('Date :', 'power-hour'); ?></span>
                                <?php power_hour()->iqonic_blog_portfolio_time_link(); ?>
                            </div>
                            <div class="single-porfolio-category">
                                <span class="label"><?php esc_html_e('Address :', 'power-hour'); ?></span>
                                <span class="label-address">
                                    <?php
                                    $key = get_field('key_pjros12gdfgd', get_the_ID());
                                    echo esc_html($key['iqonic_portfolio_address']);
                                    ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php
                    if (!empty($gallery_image_ids)) {
                        foreach ($gallery_image_ids as $id) {
                            $thumb_img_src_full = wp_get_attachment_image_src($id, "full");
                            $thumb_img_src_full = $thumb_img_src_full ? $thumb_img_src_full[0] : '#';
                            $srcset = wp_get_attachment_image_srcset($id);
                    ?>

                            <div class="col-lg-12 centered-img">
                                <a href="<?php echo esc_url($thumb_img_src_full); ?>">
                                    <?php echo wp_get_attachment_image($id, "full", false); ?>
                                </a>
                            </div>
                    <?php }
                    } ?>
                </div>
            </div><!-- #primary -->
        </div>
    </main><!-- #main -->
</div><!-- .container -->

<?php get_footer();
