(function (jQuery) {
    "use strict";
    jQuery(document).on("woof_ajax_done", woof_ajax_done_handler);

    jQuery(document).ready(function () {
        /*------------------------
        Wocommerce Change btn Grid View
        --------------------------*/
        change_view_btn_event();
        /*-----------------------------------
        Wocommerce Product Skeleton Structure
        -------------------------------------*/
        jQuery.ajax({
            url: powerhour_loadmore_params.ajaxurl, // AJAX handler
            data: {
                'action': 'load_skeleton',
            },
            type: 'GET',
            success: function (res) {
                localStorage.setItem('product_grid_skeleton', res['data']['skeleton-grid']);
                localStorage.setItem('product_list_skeleton', res['data']['skeleton-list']);
            }
        });
        jQuery(document.body).on('woosq_loaded', function (event) {
            jQuery('.thumbnails').addClass('iq-rtl-direction');
        });

        orig = jQuery.fn.css;
        var ev = new jQuery.Event('stylechanged'),
            orig = jQuery.fn.css;
        jQuery.fn.css = function () {
            var ret = orig.apply(this, arguments);
            jQuery(this).trigger(ev);
            return ret; // must include this
        }

        setTimeout(function () {
            jQuery('.woof_info_popup').on('stylechanged', function () {
                jQuery(this).append('<div class="powerhour-show-loader-overlay"></div>');
            });
        }, 500);

    });

    /*Woocommerce JS Starts Here */

    /*------------------------
    Add to cart with plus minus
    --------------------------*/
    jQuery(document).on('click', 'button.plus, button.minus', function () {

        jQuery('button[name="update_cart"]').removeAttr('disabled');

        var qty = jQuery(this).closest('.quantity').find('.qty');

        if (qty.val() == '') {
            qty.val(0);
        }
        var val = parseFloat(qty.val());

        var max = parseFloat(qty.attr('max'));
        var min = parseFloat(qty.attr('min'));
        var step = parseFloat(qty.attr('step'));

        // Change the value if plus or minus
        if (jQuery(this).is('.plus')) {
            if (max && (max <= val)) {
                qty.val(max);
            } else {
                qty.val(val + step);
            }
        } else {
            if (min && (min >= val)) {

                qty.val(min);
            } else if (val >= 1) {

                qty.val(val - step);
            }
        }
    });

    /*------------------------
    Close Panel And Menu When Click Outside
    --------------------------*/

    jQuery(window).on('click', function (e) {
        let target = jQuery(e.target);
        if (!target.closest(".search_form_wrap.iq-show").length) {
            jQuery('.search_form_wrap.iq-show').removeClass('iq-show');
        }

        if (!target.closest(".header-user-rights.iq-show").length) {
            jQuery('.header-user-rights.iq-show').removeClass('iq-show');
        }
        if (!target.closest(".powerhour-woo-sidebar.woo-sidebar-open").length && !target.hasClass('powerhour-filter-button') && !target.parent().hasClass('powerhour-filter-button')) {
            jQuery('.powerhour-woo-sidebar.woo-sidebar-open').removeClass('woo-sidebar-open');
            jQuery('body').removeClass('woof-overlay');
        }
    });

    /*------------------------
    shop sidebar toggle button
    --------------------------*/
    if (jQuery('.shop-filter-sidebar').length > 0) {
        jQuery(document).on('click', '.shop-filter-sidebar', function () {
            jQuery('body').find('.powerhour-woo-sidebar').toggleClass('woo-sidebar-open');
            jQuery('body').toggleClass('woof-overlay');

        });
    }

    /*-----------------------------------------------------------------------
    Nice select 
    -------------------------------------------------------------------------*/
    jQuery(document).ready(function($) {
        if ($('select').length > 0) {
            $('select').each(function () {
                $(this).select2({
                    width: '100%',
                    dropdownParent: $(this).parent()
                });
            });
            $('.select2-container').addClass('wide');
        }
    });
    

    /*-----------------------------------------------------------------------
    quickview nice select
    -------------------------------------------------------------------------*/
    jQuery(document.body).on('woosq_loaded woosq_close',function(){
        jQuery('select').each(function () {
            jQuery('#woosq-popup select').select2({
                width: '100%',
            });
        });
        jQuery('.select2-container').addClass('wide');
    });

    /*------------------------
    Cart btn 
    --------------------------*/
    if (jQuery(document).find('.dropdown-hover').length > 0) {
        jQuery(document).on('click', ".dropdown-hover a.dropdown-cart", function () {
            jQuery(".dropdown-menu-mini-cart").addClass('cart-show');
        });
        jQuery(document).on('click', ".dropdown-close", function () {
            jQuery(".dropdown-menu-mini-cart").removeClass('cart-show');
        });
        jQuery('body').mouseup(function (e) {
            if (jQuery(e.target).parents('.dropdown-menu-mini-cart').length === 0) {
                jQuery(".dropdown-menu-mini-cart").removeClass('cart-show');
            }
        });

        jQuery(document).on('click', ".powerhour-users-settings a.dropdown-toggle", function (e) {
            jQuery(e.target).closest('a.dropdown-toggle').next('.powerhour-user-dropdown').fadeIn(300)
            jQuery(e.target).closest('a.dropdown-toggle').next('.powerhour-user-dropdown').toggleClass('show')
        });

        jQuery(document).on('click','body', function (e) {
            if (jQuery(e.target).parents('.powerhour-users-settings a.dropdown-toggle').length === 0) {
                jQuery(".powerhour-user-dropdown").fadeIn(300);
                jQuery(".powerhour-user-dropdown").removeClass('show');
            }
        });
    }

    jQuery(document).on('change input', 'input.qty', function () {
        set_quanity(jQuery(this));
    });

    //cart products count on plus minus
    jQuery(document).on('removed_from_cart added_to_cart', function (e) {
        set_quanity(jQuery('input.qty'));
        jQuery('.powerhour-cart-count').text(jQuery('.mini-cart-count').first().text().trim());
    });

    jQuery('.mini-cart-count').each (function() {
        if(jQuery(this).text().trim() == 0) {
            jQuery('.mini-cart-count').css('display','none');
        }
    });


})(jQuery);

// Wocomerce Set Quantiy Input
function set_quanity(this_) {
	if (!this_.hasClass('qty')) {
		this_ = this_.siblings('input.qty');
	}
	let current = this_.attr('name');

	let item_hash = current ? current.replace(/cart\[([\w]+)\]\[qty\]/g, "$1") : false;
	if (!item_hash)
		return

	let item_quantity = this_.val();
	let currentVal = parseFloat(item_quantity);

	jQuery.ajax({
		type: 'POST',
		url: powerhour_loadmore_params.ajaxurl,
		data: {
			action: 'qty_cart',
			hash: item_hash,
			quantity: currentVal
		},
		success: function (res) {
			jQuery(document.body).trigger('wc_fragment_refresh');
			jQuery('.powerhour-cart-count').html(res['data']['quantity']);
			jQuery('.mini-cart-count').html(res['data']['quantity']);
			jQuery('.mini-cart-count').each (function() {
				if(jQuery(this).text().trim() == 0) {
					jQuery('.mini-cart-count').css('display','none');
				} else {
					jQuery('.mini-cart-count').css('display','block');
				}
			});
		}
	});
}

var can_loaded_product_view = true;

function getCookie(name) {
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) return parts.pop().split(';').shift();
}

function setCookie(cName, cValue, expDays = 1) {
    let date = new Date();
    date.setTime(date.getTime() + (expDays * 24 * 60 * 60 * 1000));
    const expires = "expires=" + date.toUTCString();
    let domain = "domain=" + isSubdomain() ? "." + window.location.hostname : "" + window.location.hostname + ";";
    document.cookie = cName + "=" + cValue + "; " + expires + "; Path=/;" + domain;
}

function ajax_product(all_products, skeleton_view) {
    jQuery.ajax({
        url: window.location.href,
        data: {
            loaded_paged: powerhour_loadmore_params.current_page
        },
        type: 'POST',
        beforeSend: function (xhr) {
            if (skeleton_view == 'product_grid_skeleton') {
                let col_no = getCookie('product_view[col_no]');
                var grid_skeleton_structure = jQuery(localStorage.getItem(skeleton_view)).siblings('.column-' + col_no);

                for (let index = 0; index < col_no; index++) {
                    all_products.append(grid_skeleton_structure.clone());
                }
            } else {
                all_products.append(jQuery(localStorage.getItem(skeleton_view)));
            }
            can_loaded_product_view = false;
            jQuery('.woocommerce-pagination').addClass('hide');
            jQuery('.woocommerce-pagination').removeClass('show');
        },
        success: function (res) {
            if (res) {
                res = jQuery(res);
                jQuery('.products').replaceWith(res.find('.products'));
                all_products.find('.skeleton-main').remove();
                loadmore_product();
                can_loaded_product_view = true;
                
                //hide pagination on loading products
                jQuery('.woocommerce-pagination').removeClass('hide');
                jQuery('.woocommerce-pagination').addClass('show');
            }
            // initialize entry listning wishlist page
			wp.hooks.doAction("yith_wcwl_init_add_to_wishlist_components")
        }
    });
}

var isSubdomain = function (url = window.location.hostname) {
    var regex = new RegExp(/^([a-z]+\:\/{2})?([\w-]+\.[\w-]+\.\w+)$/);
    return !!url.match(regex); // make sure it returns boolean
}
function change_view_btn_event() {
    jQuery('.powerhour-view-grid,.powerhour-listing').on('click', function () {

        let btn = jQuery(this);
        let products = btn.parents('.sorting-wrapper').next('.products');

        if (btn.hasClass('active') || jQuery("#woof_html_buffer").is(':visible') || !can_loaded_product_view) // Condition for Remove Same Button Click Event  And Chech Woof Ajax in on Load
            return;

        setCookie('product_view[col_no]', btn.hasClass('powerhour-view-grid') ? btn.data('grid') : '1');
        setCookie('product_view[is_grid]', btn.hasClass('powerhour-view-grid') ? '2' : '1');

        jQuery('.powerhour-product-view-buttons .btn').removeClass('active');
        btn.addClass('active');

        if (btn.hasClass('powerhour-listing')) {
             //Condition for check switch to list to grid
            products.find('.product').fadeOut(0, function () {
                jQuery(this).remove()
            });
            btn.parents('.product-grid-style').removeClass('product-grid-style').addClass('product-list-style')
            ajax_product(products, 'product_list_skeleton'); // Call Ajax Function for  get and Append data
        } else {
            if (btn.parents('.product-grid-style').length != 1) { //Condition for check switch to list to grid
                products.find('.product').fadeOut(0, function () {
                    jQuery(this).remove()
                });
                btn.parents('.product-list-style').removeClass('product-list-style').addClass('product-grid-style')
                ajax_product(products, 'product_grid_skeleton'); // Call Ajax Function for  get and Append data
            }
        }

        setTimeout(function () {
            if (typeof btn.data('grid') != 'undefined') {
                products.removeClass('columns-2 columns-3 columns-4').addClass('columns-' + btn.data('grid'));
            } else {
                products.removeClass(' columns-2 columns-3 columns-4');
            }
            products.addClass('animated-product');

        }, 100);
        setTimeout(function () {
			
			products.removeClass('animated-product');
			

		}, 500);
        products.removeClass('animated-product');

    });
}

function woo_ordering() {
    if (jQuery('select').length > 0) {
        jQuery('select').each(function () {
            jQuery(this).select2({
                width: '100%',
                dropdownParent: jQuery(this).parent()
            });
        });
        jQuery('.select2-container').addClass('wide');
    }
}

function woof_ajax_done_handler(e) {
    change_view_btn_event();
    loadmore_product(jQuery('.powerhour-product-main-list').data('options'));

    powerhour_loadmore_params.current_page = 1;

    jQuery.ajax({
        url: powerhour_loadmore_params.ajaxurl,
        data: {
            'action': 'fetch_woof_filter_ajax_query',
        },
        type: 'POST',
        success: function (res) {
            res = JSON.parse(res);
            if (res) {
                powerhour_loadmore_params.posts = res['query'];
                powerhour_loadmore_params.max_page = res['max_page'];
            }
        }
    });

    woo_ordering();
}