(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        callOwl();
    });
})(jQuery);
function callOwl() {
    jQuery('.owl-carousel').each(function () {
        var jQuerycarousel = jQuery(this);
        jQuerycarousel.owlCarousel({
            items: jQuerycarousel.data("items"),
            loop: jQuerycarousel.data("loop"),
            margin: jQuerycarousel.data("margin"),
            nav: jQuerycarousel.data("nav"),
            dots: jQuerycarousel.data("dots"),
            autoplay: jQuerycarousel.data("autoplay"),
            center: (jQuerycarousel.data("center")) ? jQuerycarousel.data("center") : false,
            autoplayTimeout: jQuerycarousel.data("autoplay-timeout"),
            navText: ['<div class="powerhour-leftarrow"><div class="left-arrow tringle"></div><i class="fas fa-chevron-left"></i> </div>', '<div class="powerhour-rightarrow"><div class="right-arrow tringle"></div><i class="fas fa-chevron-right"></i></div>'],
            responsiveClass: true,
            responsive: {
                // breakpoint from 0 up
                0: {
                    items: jQuerycarousel.data("items-mobile-sm"),
                    nav: false,
                    dots: true
                },
                // breakpoint from 480 up
                480: {
                    items: jQuerycarousel.data("items-mobile"),
                    nav: false,
                    dots: true
                },
                // breakpoint from 786 up
                786: {
                    items: jQuerycarousel.data("items-tab"),
                    nav: false,
                    dots: true
                },
                // breakpoint from 1023 up
                1023: {
                    items: jQuerycarousel.data("items-laptop"),
                    nav: false,
                    dots: true
                },
                1199: {
                    items: jQuerycarousel.data("items"),
                }
            }
        });
    });
    if (jQuery('.powerhour-gallery.style-one').length > 0) {
        jQuery('.powerhour-gallery.style-one .owl-carousel').on('change.owl.carousel changed.owl.carousel', function (e) {
            if (e.property.name != 'position') return;
            var current = e.relatedTarget.current();
            var items = jQuery(this).find('.owl-stage').children();
            var add = e.type == 'changed';

            items.eq(e.relatedTarget.normalize(current + 2)).toggleClass('after', add);
            items.eq(e.relatedTarget.normalize(current - 2)).toggleClass('before', add);
        });

        jQuery('.powerhour-gallery .owl-carousel').trigger('next.owl.carousel');

    }
    if (jQuery('.single-portfolio-slider').length > 0) {
        jQuery('.single-portfolio-slider.owl-dot').each(function () {
            console.log(jQuery(this).children('span'));
            jQuery(this).children('span').text(jQuery(this).index() + 1);
        });
    }
    window.dispatchEvent(new Event('resize'));
}