/**
 * File custom.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

 (function($) {
	"use strict";

	jQuery(document.body).on('woosq_loaded', ()=>{
		wp.hooks.doAction("yith_wcwl_init_add_to_wishlist_components")
	});
	
	$(window).on('load', function (e) {

		/*---------------------------------------------------------------------
		   Scroll
		-----------------------------------------------------------------------*/
		var position = $(window).scrollTop();
		$('#back-to-top').fadeOut();
		$(window).scroll(function () {
			// -----sticky menu
			if ($('.has-sticky').length > 0) {
				var scroll = $(window).scrollTop();
				if (scroll < position) {
					$('.has-sticky').addClass('header-up');
					$('body').addClass('header--is-sticky');
					$('.has-sticky').removeClass('header-down');
				} else {
					$('.has-sticky').addClass('header-down');
					$('.has-sticky').removeClass('header-up ');
					$('body').removeClass('header--is-sticky');
				}
				if (scroll == 0) {
					$('.has-sticky').removeClass('header-up');
					$('.has-sticky').removeClass('header-down');
					$('body').removeClass('header--is-sticky');
				}
				position = scroll;
			}
			//back-to top
			if ($(this).scrollTop() > 250) {
				$('#back-to-top').fadeIn(1400);
			} else {
				$('#back-to-top').fadeOut(400);
			}
		});

		// scroll body to 0px on click
		$('#top').on('click', function () {
			$('top').tooltip('hide');
			$('body,html').animate({
				scrollTop: 0
			}, 800);
			return false;
		});

		/*---------------------------
		Vertical Menu
		---------------------------*/

		if ($('.c-collapse').length > 0) {

			$('nav.mobile-menu .sub-menu').css('display', 'none ');
			$('nav.mobile-menu #top-menu li .dropdown').hide();
			$('nav.mobile-menu .sub-menu').prev().prev().addClass('submenu');
			$('nav.mobile-menu .sub-menu').before('<span class="toggledrop"><i class="fas fa-caret-down"></i></span>');

			$('nav.mobile-menu .widget i,nav.mobile-menu .top-menu i').on('click', function () {
				$(this).next('.children, .sub-menu').slideToggle();
			});

			$('nav.mobile-menu #top-menu .menu-item .toggledrop').off('click');
			$('nav.mobile-menu .menu-item .toggledrop').on('click', function () {
				if ($(this).closest(".menu-is--open").length == 0) {
					$('nav.mobile-menu .menu-item').removeClass('menu-is--open');
				}
				if ($(this).parent().find("ul").length > 1) {
					$(this).parent().addClass('menu-is--open');
				}
				$('nav.mobile-menu .menu-item:not(.menu-is--open) .children,nav.mobile-menu .menu-item:not(.menu-is--open) .sub-menu').slideUp();
				if (!$(this).next('.children, .sub-menu').is(':visible') || $(this).parent().hasClass("menu-is--open")) {
					$(this).next('.children, .sub-menu').slideToggle();
				}
				$(this).toggleClass('active');
				$('nav.mobile-menu .menu-item').removeClass('menu-clicked');
				$(this).parent().addClass('menu-clicked');

				$('nav.mobile-menu .menu-item').removeClass('current-menu-ancestor');
			});
		}

		/*------------------------
		 main menu toggle
		--------------------------*/

		$(document).on("click", '.custom-toggler', function () {
			if ($('.powerhour-mobile-menu ').hasClass('menu-open')) {
				$('.powerhour-mobile-menu ').toggleClass('open-delay');
				setTimeout(function () {
					$('.powerhour-mobile-menu ').toggleClass('menu-open');
					$('.powerhour-mobile-menu ').toggleClass('open-delay');
				}, 1000);
			} else {
				$('.powerhour-mobile-menu ').toggleClass('menu-open');
			}
			$('.opn-menu').toggleClass('powerhour-open');
		});

		$(document).on("click", '.ham-toggle', function () {
			$('.ham-toggle .menu-btn').toggleClass('is-active');
		});
		$(document).on("click", '.mob-toggle', function () {
			$('body').toggleClass('overflow-hidden');
		});

		/*------------------------
		Page Loader
		--------------------------*/
		$("#load").fadeOut();
		$("#loading").delay(0).fadeOut("slow");


	});


	$(document).ready(function () {

		$('ul.sf-menu').superfish({
			delay: 500,
			onBeforeShow: function (ul) {
				var elem = $(this);
				var elem_offset = 0,
					elem_width = 0,
					ul_width = 0;
				// Add class if menu at the edge of the window
				if (elem.length == 1) {
					var page_width = $('#page.site').width(),
						elem_offset = elem.parents('li').eq(0).offset().left,
						elem_width = elem.parents('li').eq(0).outerWidth(),
						ul_width = elem.outerWidth();

					if (elem.hasClass('iqonic-megamenu-container')) {
						if (elem.hasClass('iqonic-full-width')) {
							$('.iqonic-megamenu-container.iqonic-full-width').css({ 'left': -elem_offset });
						}
						if (elem.hasClass('iqonic-container-width')) {
							let containerOffset = (elem.closest('.elementor-container').length > 0) ? elem.closest('.elementor-container').offset() : elem.parents('li').eq(0).closest('header .container-fluid nav,header .container nav').offset();
							$('.iqonic-megamenu-container.iqonic-container-width').css({
								'left': -(elem_offset - containerOffset.left)
							});
						}
					}

					if (elem_offset + elem_width + ul_width > page_width - 5 && elem_offset - ul_width > 0) {
						elem.addClass('open-submenu-main');
						elem.css({
							'left': 'auto',
							'right': '0'
						});
					} else {
						elem.removeClass('open-submenu-main');
						elem.css({});
					}
				}
				if (elem.parents("ul").length > 1) {
					var page_width = $('#page.site').width();
					elem_offset = elem.parents("ul").eq(0).offset().left;
					elem_width = elem.parents("ul").eq(0).outerWidth();
					ul_width = elem.outerWidth();

					if (elem_offset + elem_width + ul_width > page_width - 5 && elem_offset - ul_width > 0) {
						elem.addClass('open-submenu-left');
						elem.css({
							'left': 'auto',
							'right': '100%'
						});
					} else {
						elem.removeClass('open-submenu-left');
					}
				}
			},
		});

		if ($('.columns-2,.columns-3,.columns-4,.columns-5,.columns-6').length > 0) {
			$('.columns-2,.columns-3,.columns-4,.columns-5,.columns-6').on('mouseenter', function () {
				let navWidth = $('nav').width();
				let leftPos = 0 - $(this).position().left;
				$(this).find("ul.sub-menu:first").css({
					"width"		: navWidth,
					"left"		: leftPos,
					"right"		: "auto",
					"max-width"	: "none"
				});
			});
		}
		/*------------------------
		Searchstyle Bar
		--------------------------*/
		if ($(".search__input").length > 0 && $(".search").length > 0) {
			$(document).on('click', '#btn-search', function () {
				$('.search').toggleClass('search--open');
			});
			$(document).on('click', '#btn-search-close', function () {
				$('.search').toggleClass('search--open');
			});
		}
		
		/*---------------------------
		Sidebar
		---------------------------*/
		$('body').mouseup(function (e) {
			if ($(e.target).closest(".powerhour-menu-side-bar").length === 0) {
				$("body").removeClass("side-bar-open");
			}
		});

		$(".powerhour-menu-side-bar").mouseenter(function () {
			$("body").addClass("body-scroll-hidden");
		});

		$(".powerhour-menu-side-bar").mouseleave(function () {
			$("body").removeClass("body-scroll-hidden");
		});

		$(window).scroll(function () {
			let scroll = $(window).scrollTop();
			if (scroll >= 10 && $("body").hasClass("side-bar-open")) {
				$("body").removeClass("side-bar-open");
			}
		});

		$(".navbar-toggler").click(function () {
			if ($(window).width() < 1200) {
				$('body').toggleClass('overflow-hidden');
			}
		});
		$(window).on('resize', function () {
			if ($(window).width() > 1200) {
				if ($('body').hasClass('overflow-hidden')) {
					$('body').removeClass('overflow-hidden');
				}
			} else {
				if ($('.navbar-toggler').hasClass('moblie-menu-active')) {
					$('body').addClass('overflow-hidden');
				}
			}
		});

		/*------------------------
				Wow Animation
		--------------------------*/
		if (jQuery(".wow").length > 0) {
			var wow = new WOW({
				boxClass: 'wow',
				animateClass: 'animated',
				offset: 0,
				mobile: true,
				live: true
			});
			wow.init();
		}

		/*================
		masonry
		=====================*/
		if (jQuery('.iqonic-masonry-grid').length > 0) {
			jQuery('.iqonic-masonry-grid').each(function () {
				let $this = jQuery(this);
				let horizontal = $this.data("horizontal-order");
				// let horizontal = jQuery(this).data("gutter");
				jQuery(".iqonic-masonry-block").imagesLoaded(function () {
					$this.masonry({
						columnWidth: ".grid-sizer",
						itemSelector: ".iqonic-masonry-item",
						horizontalOrder: horizontal,
						// gutter: 10
					});
				});
			});
		}

	});

}(jQuery));


document.addEventListener('DOMContentLoaded', () => {
	if (jQuery('.powerhour-menu-box').length > 0) {
		const moblieMenu = document.querySelector('.powerhour-menu-box');

		moblieMenu.addEventListener('click', () => {
			const active = moblieMenu.classList.toggle('moblie-menu-active');
		})
	}
});