<div class="wpbooked-settings-prewrap">
	<div class="wrap wpbooked-settings-wrap"><?php

	if (get_transient('wpbooked_show_new_tags',false)):
		$show_new_tags = true;
	else:
		$show_new_tags = false;
	endif;

	$calendars = get_terms('wpbooked_custom_calendars','orderby=slug&hide_empty=0');
	$booked_none_assigned = true;
	$default_calendar_id = false;

	if (!empty($calendars)):

		if (!current_user_can('manage_booked_options')):

			$booked_current_user = wp_get_current_user();
			$calendars = wpbooked_filter_agent_calendars($booked_current_user,$calendars);

			if (empty($calendars)):
				$booked_none_assigned = true;
			else:
				$first_calendar = array_slice($calendars, 0, 1);
				$default_calendar_id = array_shift($first_calendar)->term_id;
				$booked_none_assigned = false;
			endif;

		else:
			$booked_none_assigned = false;
		endif;

	endif;

	if (!current_user_can('manage_booked_options') && $booked_none_assigned):

		echo '<div style="text-align:center;">';
			echo '<br><br><h3>'.esc_html__('There are no calendars assigned to you.','wpbooked').'</h3>';
			echo '<p>'.esc_html__('Get in touch with the Administration of this site to get a calendar assigned to you.','wpbooked').'</p>';
		echo '</div>';

	else: ?>

		<div class="topSavingState savingState"><i class="fa-solid fa-circle-notch fa-spin"></i>&nbsp;&nbsp;<?php esc_html_e('Updating, please wait...','wpbooked'); ?></div>

		<div class="wpbooked-settings-title"><?php echo esc_html__('Booked Settings','wpbooked'); ?></div>

		<div id="wpbooked-admin-panel-container">

			<?php $booked_settings_tabs = [];
			
			$booked_settings_tabs[] = [
				'access' => 'admin',
				'slug' => 'general',
				'content' => '<i class="fa-solid fa-gear"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('General','wpbooked') . '</span>'
			];
			
			$booked_settings_tabs[] = [
				'access' => 'agent',
				'slug' => 'defaults',
				'content' => '<i class="fa-solid fa-clock"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('Time Slots','wpbooked') . '</span><span class="savingState">&nbsp;&nbsp;&nbsp;<i class="fa-solid fa-circle-notch fa-spin"></i></span>'
			];
			
			$booked_settings_tabs[] = [
				'access' => 'agent',
				'slug' => 'custom-timeslots',
				'content' => '<i class="fa-solid fa-clock"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('Custom Time Slots','wpbooked') . '</span><span class="savingState">&nbsp;&nbsp;&nbsp;<i class="fa-solid fa-circle-notch fa-spin"></i></span>'
			];
			
			$booked_settings_tabs[] = [
				'access' => 'agent',
				'slug' => 'custom-fields',
				'content' => '<i class="fa-solid fa-pencil"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('Custom Fields','wpbooked') . '</span>'
			];
			
			$booked_settings_tabs[] = [
				'access' => 'admin',
				'slug' => 'email-settings',
				'content' => '<i class="fa-solid fa-envelope"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('Emails','wpbooked') . '</span>'
			];
			
			if ( class_exists('woocommerce') ):
			
				$booked_settings_tabs[] = [
					'access' => 'admin',
					'slug' => 'woocommerce-settings',
					'content' => '<i class="fa-solid fa-cart-shopping"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('WooCommerce','wpbooked') . '</span>'
				];
				
			endif;
			
			$booked_settings_tabs[] = [
				'access' => 'admin',
				'slug' => 'calendar-feeds',
				'content' => '<i class="fa-solid fa-calendar-days"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('Calendar Feeds','wpbooked') . '</span>'
			];
			
			$booked_settings_tabs[] = [
				'access' => 'admin',
				'slug' => 'export-appointments',
				'content' => '<i class="fa-solid fa-arrow-up-right-from-square"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('Export','wpbooked') . '</span>'
			];
			
			$booked_settings_tabs[] = [
				'access' => 'admin',
				'slug' => 'shortcodes',
				'content' => '<i class="fa-solid fa-code"></i><span class="wpbooked-tab-text ">&nbsp;&nbsp;'.esc_html__('Shortcodes','wpbooked') . '</span>'
			];
			
			$booked_settings_tabs = apply_filters( 'wpbooked_settings_tabs', $booked_settings_tabs );

			$tab_counter = 1;

			$new_items_in_tabs = array();

			foreach($booked_settings_tabs as $tab_data):
				if ($tab_data['access'] == 'admin' && current_user_can('manage_booked_options') || $tab_data['access'] == 'agent'):
					if ($tab_counter == 1): ?><ul class="wpbooked-admin-tabs WPbookedClearFix"><?php endif;
					?><li<?php if ($tab_counter == 1): ?> class="active"<?php endif; ?>><a href="#<?php echo esc_attr($tab_data['slug']); ?>"><?php echo wp_kses($tab_data['content'],array('i'=>array('class'=>array()),'span'=>array('class'=>array()))); ?><?php if (in_array($tab_data['slug'],$new_items_in_tabs)): wpbooked_new_tag($show_new_tags); endif; ?></a></li><?php
					$tab_counter++;
				endif;
			endforeach;

			?></ul>

			<div class="form-wrapper">
				
				<?php foreach($booked_settings_tabs as $tab_data):

					if ($tab_data['access'] == 'admin' && current_user_can('manage_booked_options') || $tab_data['access'] == 'agent'):

						switch ($tab_data['slug']):

							case 'general': ?>

								<form action="options.php" class="wpbooked-settings-form" method="post">

									<?php settings_fields('wpbooked_plugin-group'); ?>

									<div id="wpbooked-general" class="tab-content">

										<h1 style="display:none;"></h1>

										<?php settings_errors(); ?>

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Booking Type', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('You have the option to choose between "Registered" and "Guest" booking. Registered booking will require all appointments to be wpbooked by a registered user (default). Guest booking will allow anyone with a name and email address to book an appointment.','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_booking_type';
												$booking_type = get_option($option_name,'registered'); ?>
												<div class="select-box">
													<select data-condition="booking_type" name="<?php echo esc_html($option_name); ?>">
														<option value="registered"<?php echo esc_html($booking_type == 'registered' ? ' selected="selected"' : ''); ?>><?php esc_html_e('Registered Booking','wpbooked'); ?></option>
														<option value="guest"<?php echo esc_html($booking_type == 'guest' ? ' selected="selected"' : ''); ?>><?php esc_html_e('Guest Booking','wpbooked'); ?></option>
													</select>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<?php $selected_value = get_option('wpbooked_registration_name_requirements',array('wpbooked_require_name')); $selected_value = (isset($selected_value[0]) ? $selected_value[0] : false); ?>
										<div class="section-row">
											<div class="section-head">

											<?php $section_title = esc_html__('Booking Options', 'wpbooked'); ?>
											<h3><?php echo esc_attr($section_title); ?></h3>

											<p style="margin:1.2em 0 10px;">
												<input style="margin:-5px 5px 0 0;" id="wpbooked_require_name" name="wpbooked_registration_name_requirements[]" value="require_name"<?php if (!$selected_value || $selected_value == 'require_name'): echo ' checked="checked"'; endif; ?> type="radio">
												<label class="checkbox-radio-label" for="wpbooked_require_name"><strong><?php esc_html_e('Require "Name" only','wpbooked'); ?></strong> &mdash; <?php esc_html_e('Require your customers to enter their name in a single text field.','wpbooked'); ?></label><br>
											</p>
											<p style="margin:0 0 10px;">
												<input style="margin:-5px 5px 0 0;" id="wpbooked_require_surname" name="wpbooked_registration_name_requirements[]" value="require_surname"<?php if ($selected_value == 'require_surname'): echo ' checked="checked"'; endif; ?> type="radio">
												<label class="checkbox-radio-label" for="wpbooked_require_surname"><strong><?php esc_html_e('Require "First Name" and "Last Name"','wpbooked'); ?></strong> &mdash; <?php esc_html_e('Require your customers to enter their first and last name in two text fields.','wpbooked'); ?></label><br>
											</p>

											</div>
										</div>

										<?php $selected_value = get_option('wpbooked_require_guest_email_address',false); ?>
										<div class="condition-block booking_type" data-condition-val="guest" style="<?php if ($booking_type == 'guest'): ?>display:block; <?php endif; ?>">
											<div class="section-row">
												<div class="section-head">

												<?php $section_title = esc_html__('Guest Booking Options', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>

												<p style="margin:1.2em 0 10px;">
													<input style="margin:-4px 5px 0 0;" id="wpbooked_require_guest_email_address" name="wpbooked_require_guest_email_address" value="true"<?php if ($selected_value): echo ' checked="checked"'; endif; ?> type="checkbox">
													<label class="checkbox-radio-label" for="wpbooked_require_guest_email_address"><strong><?php esc_html_e('Require Email Address','wpbooked'); ?></strong> &mdash; <?php esc_html_e('Require your guests to enter their email address.','wpbooked'); ?></label>
												</p>

												</div>
											</div>
										</div>

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Appointment Booking Redirect', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>

												<?php $option_name = 'wpbooked_appointment_redirect_type'; $selected_value = get_option($option_name,false);

												$booked_redirect_type = $selected_value;

												$detected_page_error = false;
												$detected_page = wpbooked_get_profile_page();
												if (!$detected_page):
													$detected_page_error = true;
												endif; ?>

												<p style="margin:1.2em 0 10px;"><input style="margin:-4px 5px 0 0;" data-condition="redirect_type" id="redirect_type_none" name="<?php echo esc_html($option_name); ?>" value=""<?php if (!$selected_value): echo ' checked="checked"'; endif; ?> type="radio">
												<label class="checkbox-radio-label" for="redirect_type_none"><?php 
												// translators: %s represents the action to be taken. Example: "No Redirect"
													echo sprintf( esc_html__('%s Refresh the calendar list after booking.','wpbooked'), '<strong>' . esc_html__('No Redirect','wpbooked') . '</strong> &mdash; ' ); 
												?></label></p>

												<div class="condition-block booking_type" data-condition-val="registered" style="<?php if ($booking_type == 'registered'): ?>display:block; <?php endif; ?>">
													<p style="margin:0 0 10px;">
														<input style="margin:-4px 5px 0 0;" data-condition="redirect_type" id="redirect_type_detect" name="<?php echo esc_html($option_name); ?>" value="booked-profile"<?php if ($selected_value == 'booked-profile'): echo ' checked="checked"'; endif; ?> type="radio">
														<label class="checkbox-radio-label" for="redirect_type_detect"><?php
															// translators: %s represents the action to be taken. Example: "Auto-Detect Profile Page"
															echo sprintf( esc_html__('%s Auto-detect the page with the [wpbooked-profile] shortcode.','wpbooked'), '<strong>' . esc_html__('Auto-Detect Profile Page','wpbooked') . '</strong> &mdash; ' ); 
															if (!$detected_page_error && $detected_page): ?>&nbsp;&nbsp;&mdash;&nbsp;&nbsp;<strong><?php 
															// translators: %s represents the action to be taken. Example: "Page Permalink".
															echo sprintf(esc_html__('Detected Page: %s','wpbooked'),'<a href="'.esc_url(get_permalink($detected_page)).'">'.esc_url(get_permalink($detected_page)).'</a>'); 
															?></strong><?php endif; ?></label>
													</p>
												</div>

												<?php if ($detected_page_error): ?>
												<div style="margin:0 0 10px;">
													<div class="condition-block redirect_type" data-condition-val="booked-profile" style="<?php if ($booked_redirect_type == 'booked-profile'): ?>display:block; <?php endif; ?>line-height:30px; padding:0 0 0 30px; margin:-5px 0 10px;">
														<?php
															// translators: %s represents the action to be taken. Example: "Important:",%s represents the action to be taken. Example: "create a page url",%s represents the action to be taken. Example: "[wpbooked-profile] shortcode" 
															echo sprintf(esc_html__( '%1$s We were not able to auto-detect. You need to %2$s with the %3$s shortcode.','wpbooked' ),'<strong style="color:#DB5933;">'.esc_html__('Important:','wpbooked').'</strong>','<strong><a href="'.esc_url(get_admin_url()).'post-new.php?post_type=page">'.esc_html__('create a page','wpbooked').'</a></strong>','<code>[wpbooked-profile]</code>'); ?></div>
												</div>
												<?php endif; ?>

												<p style="margin:0;">
													<input style="margin:-4px 5px 0 0;" data-condition="redirect_type" id="redirect_type_page" name="<?php echo esc_html($option_name); ?>" value="page"<?php if ($selected_value == 'page'): echo ' checked="checked"'; endif; ?> type="radio">
													<label class="checkbox-radio-label" for="redirect_type_page"><?php 
													// translators: %s represents the action to be taken. Example: "Choose Specific Page"
													echo sprintf( esc_html__('%s Choose a redirect page.','wpbooked'), '<strong>' . esc_html__('Choose Specific Page','wpbooked') . '</strong> &mdash; ' ); ?></label>
												</p>

												<?php $option_name = 'wpbooked_appointment_success_redirect_page';

												$pages = get_posts(array(
													'post_type' => 'page',
													'orderby'	=> 'name',
													'order'		=> 'asc',
													'posts_per_page' => 500
												));

												$selected_value = get_option($option_name); ?>
												<div style="padding:15px 0 0 0;" class="condition-block redirect_type select-box<?php if ($booked_redirect_type == 'page'): ?> default<?php endif; ?>" data-condition-val="page">
													<select name="<?php echo esc_html($option_name); ?>">
														<option value=""<?php echo esc_html(!$selected_value ? ' selected="selected"' : ''); ?>><?php echo esc_html__('Choose a page','wpbooked').'...'; ?></option>
														<?php if(!empty($pages)) :

															foreach($pages as $p) :
																$entry_id = $p->ID;
																$entry_title = get_the_title($entry_id); ?>
																<option value="<?php echo esc_html($entry_id); ?>"<?php echo esc_html($selected_value == $entry_id ? ' selected="selected"' : ''); ?>><?php echo esc_html($entry_title); ?></option>
															<?php endforeach;

														endif; ?>
													</select>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<div class="condition-block booking_type<?php if ($booking_type == 'registered'): ?> default<?php endif; ?>" data-condition-val="registered">

											<div class="section-row">
												<div class="section-head">
													<?php $section_title = esc_html__('Login Redirect', 'wpbooked'); ?>
													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('If you would like the login form to redirect somewhere else (instead of reloading the same page), you can choose a page here.','wpbooked'); ?></p>

													<?php $option_name = 'wpbooked_login_redirect_page';

													$pages = get_posts(array(
														'post_type' => 'page',
														'orderby'	=> 'name',
														'order'		=> 'asc',
														'posts_per_page' => 500
													));

													$selected_value = get_option($option_name); ?>
													<div class="select-box">
														<select name="<?php echo esc_html($option_name); ?>">
															<option value=""><?php esc_html_e('Redirect to the same page','wpbooked'); ?></option>
															<?php if(!empty($pages)) :
																foreach($pages as $p) :
																	$entry_id = $p->ID;
																	$entry_title = get_the_title($entry_id); ?>
																	<option value="<?php echo esc_html($entry_id); ?>"<?php echo esc_html($selected_value == $entry_id ? ' selected="selected"' : ''); ?>><?php echo esc_html($entry_title); ?></option>
																<?php endforeach;

															endif; ?>
														</select>
													</div><!-- /.select-box -->
												</div><!-- /.section-body -->
											</div><!-- /.section-row -->

											<div class="section-row">
												<div class="section-head">
													<?php $section_title = esc_html__('Custom Login Tab Content', 'wpbooked'); ?>
													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('If you would like the login form to include a custom message (above the login form), you can add that here.','wpbooked'); ?></p>

													<?php $option_name = 'wpbooked_custom_login_message';
													$custom_content_value = get_option($option_name);

													wp_editor( $custom_content_value, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 250,'teeny' => true) );

													?>
												</div><!-- /.section-body -->
											</div><!-- /.section-row -->

										</div>

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Time Slot Intervals', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('Choose the intervals you need for your appointment time slots. This will only affect the way default time slots are entered.','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_timeslot_intervals';
												$selected_value = get_option( $option_name, 5 );

												$interval_options = apply_filters( 'wpbooked_timeslot_interval_sizes', array(
													'120'	=> esc_html__('Every 2 hours','wpbooked'),
													'60' 	=> esc_html__('Every 1 hour','wpbooked'),
													'30' 	=> esc_html__('Every 30 minutes','wpbooked'),
													'15' 	=> esc_html__('Every 15 minutes','wpbooked'),
													'10' 	=> esc_html__('Every 10 minutes','wpbooked'),
													'5' 	=> esc_html__('Every 5 minutes','wpbooked'),
												) ); ?>

												<div class="select-box">
													<select name="<?php echo esc_html($option_name); ?>">
														<?php foreach($interval_options as $current_value => $option_title):
															echo '<option value="'.esc_html($current_value).'"' . ($selected_value == $current_value ? ' selected' : ''). '>' . esc_html($option_title) . '</option>';
														endforeach; ?>
													</select>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Appointment Buffer', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('To prevent appointments from getting wpbooked too close to the current date and/or time, you can set an appointment buffer. Available appointments time slots will be pushed up to a new date and time depending on which buffer amount you choose below.','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_appointment_buffer';
												$selected_value = get_option($option_name);

												$interval_options = array(
													'0' 				=> esc_html__('No buffer','wpbooked'),
													'1' 				=> esc_html__('1 hour','wpbooked'),
													'2' 				=> esc_html__('2 hours','wpbooked'),
													'3' 				=> esc_html__('3 hours','wpbooked'),
													'4' 				=> esc_html__('4 hours','wpbooked'),
													'5' 				=> esc_html__('5 hours','wpbooked'),
													'6' 				=> esc_html__('6 hours','wpbooked'),
													'12' 				=> esc_html__('12 hours','wpbooked'),
													'24' 				=> esc_html__('24 hours','wpbooked'),
													'48' 				=> esc_html__('2 days','wpbooked'),
													'72' 				=> esc_html__('3 days','wpbooked'),
													'96' 				=> esc_html__('5 days','wpbooked'),
													'144' 				=> esc_html__('6 days','wpbooked'),
													'168' 				=> esc_html__('1 week','wpbooked'),
													'336' 				=> esc_html__('2 weeks','wpbooked'),
													'504' 				=> esc_html__('3 weeks','wpbooked'),
													'672' 				=> esc_html__('4 weeks','wpbooked'),
													'840' 				=> esc_html__('5 weeks','wpbooked'),
													'1008' 				=> esc_html__('6 weeks','wpbooked'),
													'1176' 				=> esc_html__('7 weeks','wpbooked'),
													'1344' 				=> esc_html__('8 weeks','wpbooked'),
												); ?>

												<div class="select-box">
													<select name="<?php echo esc_html($option_name); ?>">
														<?php foreach($interval_options as $current_value => $option_title):
															echo '<option value="'.esc_html($current_value).'"' . ($selected_value == $current_value ? ' selected' : ''). '>' . esc_html($option_title) . '</option>';
														endforeach; ?>
													</select>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<?php $date_format = get_option('date_format'); ?>

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Prevent Appointments Before Date', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('To prevent appointments from getting wpbooked before a certain date, you can choose that date below.','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_prevent_appointments_before';
												$selected_value = get_option($option_name); ?>

												<div class="select-box">
													<input type="text" placeholder="<?php esc_html_e("Choose a date","booked"); ?>..." class="wpbooked_prevent_appointments_before" name="<?php echo esc_html($option_name); ?>" value="<?php echo esc_html($selected_value); ?>">
													<span class="<?php echo esc_html($option_name); ?>-formatted" style="padding-left:15px; font-weight:600; font-size:15px;"><?php echo ( $selected_value ? esc_html(ucwords( date_i18n( $date_format,strtotime($selected_value) ) )) : '' ); ?></span>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Prevent Appointments After Date', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('To prevent appointments from getting wpbooked after a certain date, you can choose that date below.','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_prevent_appointments_after';
												$selected_value = get_option($option_name); ?>

												<div class="select-box">
													<input type="text" placeholder="<?php esc_html_e("Choose a date","booked"); ?>..." class="wpbooked_prevent_appointments_after" name="<?php echo esc_html($option_name); ?>" value="<?php echo esc_html($selected_value); ?>">
													<span class="<?php echo esc_html($option_name); ?>-formatted" style="padding-left:15px; font-weight:600; font-size:15px;"><?php echo ( $selected_value ? esc_html(ucwords( date_i18n( $date_format,strtotime($selected_value) ) )) : '' ); ?></span>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Cancellation Buffer', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('To prevent appointments from getting cancelled too close to the appointment time, you can set a cancellation buffer.','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_cancellation_buffer';
												$selected_value = get_option($option_name);

												$interval_options = array(
													'0' 				=> esc_html__('No buffer','wpbooked'),
													'0.25' 				=> esc_html__('15 minutes','wpbooked'),
													'0.50' 				=> esc_html__('30 minutes','wpbooked'),
													'0.75' 				=> esc_html__('45 minutes','wpbooked'),
													'1' 				=> esc_html__('1 hour','wpbooked'),
													'2' 				=> esc_html__('2 hours','wpbooked'),
													'3' 				=> esc_html__('3 hours','wpbooked'),
													'4' 				=> esc_html__('4 hours','wpbooked'),
													'5' 				=> esc_html__('5 hours','wpbooked'),
													'6' 				=> esc_html__('6 hours','wpbooked'),
													'12' 				=> esc_html__('12 hours','wpbooked'),
													'24' 				=> esc_html__('24 hours','wpbooked'),
													'48' 				=> esc_html__('2 days','wpbooked'),
													'72' 				=> esc_html__('3 days','wpbooked'),
													'96' 				=> esc_html__('5 days','wpbooked'),
													'144' 				=> esc_html__('6 days','wpbooked'),
													'168' 				=> esc_html__('1 week','wpbooked'),
													'336' 				=> esc_html__('2 weeks','wpbooked'),
													'504' 				=> esc_html__('3 weeks','wpbooked'),
													'672' 				=> esc_html__('4 weeks','wpbooked'),
													'840' 				=> esc_html__('5 weeks','wpbooked'),
													'1008' 				=> esc_html__('6 weeks','wpbooked'),
													'1176' 				=> esc_html__('7 weeks','wpbooked'),
													'1344' 				=> esc_html__('8 weeks','wpbooked'),
												); ?>

												<div class="select-box">
													<select name="<?php echo esc_html($option_name); ?>">
														<?php foreach($interval_options as $current_value => $option_title):
															echo '<option value="'.esc_html($current_value).'"' . ($selected_value == $current_value ? ' selected' : ''). '>' . esc_html($option_title) . '</option>';
														endforeach; ?>
													</select>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Appointment Limit', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('To prevent users from booking too many appointments, you can set an appointment limit.','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_appointment_limit';
												$selected_value = get_option($option_name);

												$interval_options = array(
													'0' 				=> esc_html__('No limit','wpbooked'),
													'1' 				=> esc_html__('1 appointment','wpbooked'),
													'2' 				=> esc_html__('2 appointments','wpbooked'),
													'3' 				=> esc_html__('3 appointments','wpbooked'),
													'4' 				=> esc_html__('4 appointments','wpbooked'),
													'5' 				=> esc_html__('5 appointments','wpbooked'),
													'6' 				=> esc_html__('6 appointments','wpbooked'),
													'7' 				=> esc_html__('7 appointments','wpbooked'),
													'8' 				=> esc_html__('8 appointments','wpbooked'),
													'9' 				=> esc_html__('9 appointments','wpbooked'),
													'10' 				=> esc_html__('10 appointments','wpbooked'),
													'15' 				=> esc_html__('15 appointments','wpbooked'),
													'20' 				=> esc_html__('20 appointments','wpbooked'),
													'25' 				=> esc_html__('25 appointments','wpbooked'),
													'50' 				=> esc_html__('50 appointments','wpbooked'),
												); ?>

												<div class="select-box">
													<select name="<?php echo esc_html($option_name); ?>">
														<?php foreach($interval_options as $current_value => $option_title):
															echo '<option value="'.esc_html($current_value).'"' . ($selected_value == $current_value ? ' selected' : ''). '>' . esc_html($option_title) . '</option>';
														endforeach; ?>
													</select>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('New Appointment Default', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3>
												<p><?php esc_html_e('Would you like your appointment requests to go into a pending list or should they be approved immediately?','wpbooked'); ?></p>

												<?php $option_name = 'wpbooked_new_appointment_default';
												$selected_value = get_option($option_name);

												$interval_options = array(
													'draft' 	=> esc_html__('Set as Pending','wpbooked'),
													'publish' 	=> esc_html__('Approve Immediately','wpbooked')
												); ?>

												<div class="select-box">
													<select name="<?php echo esc_html($option_name); ?>">
														<?php foreach($interval_options as $current_value => $option_title):
															echo '<option value="'.esc_html($current_value).'"' . ($selected_value == $current_value ? ' selected' : ''). '>' . esc_html($option_title) . '</option>';
														endforeach; ?>
													</select>
												</div><!-- /.select-box -->
											</div><!-- /.section-body -->
										</div><!-- /.section-row -->

										<div class="section-row cf">
											<div class="section-head">

												<h3><?php esc_html_e('Display Options', 'wpbooked'); ?></h3><?php // TODO - WIP ?>

												<br>

												<?php $option_name = 'wpbooked_hide_default_calendar';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide "Default" in the calendar switcher','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_hide_weekends';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide weekends in the calendar','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_hide_google_link';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide "Add to Calender" button in the Profile appointment list','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_show_only_titles';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide time slots (when a time slot title exists)','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_hide_end_times';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide end times (show only start times)','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_hide_available_timeslots';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide the number of available time slots','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_hide_unavailable_timeslots';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide the already wpbooked time slots (cannot be used with "Public Appointments")','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_public_appointments';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Public Appointments (show names under wpbooked appointments)','wpbooked'); ?></label><br><br>

											</div>
										</div>

										<div class="section-row cf">
											<div class="section-head">

												<h3><?php esc_html_e('Other Options', 'wpbooked'); ?></h3><?php // TODO - WIP ?>

												<br>

												<?php $option_name = 'wpbooked_dont_allow_user_cancellations';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Do not allow users to cancel their own appointments.','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_redirect_non_admins';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Redirect users (except Admins and Booking Agents) from the "/wp-admin/" URL.','wpbooked'); ?></label><br><br>

												<?php $option_name = 'wpbooked_hide_admin_bar_menu';
												$option_value = get_option($option_name,false); ?>

												<input id="<?php echo esc_html($option_name); ?>" name="<?php echo esc_html($option_name); ?>"<?php echo $option_value ? ' checked="checked"' : ''; ?> type="checkbox">
												<label class="checkbox-radio-label" for="<?php echo esc_html($option_name); ?>"><?php esc_html_e('Hide "Appointments" menu from Admin Bar.','wpbooked'); ?></label>

											</div>
										</div><!-- /.section-row -->

										<div class="section-row">
											<div class="section-head">
												<?php $section_title = esc_html__('Front-End Color Settings', 'wpbooked'); ?>
												<h3><?php echo esc_attr($section_title); ?></h3><?php // TODO - WIP ?>
											</div><!-- /.section-head -->
											<div class="section-body">

												<?php
												$color_options = array(
													array(
														'name' => 'wpbooked_light_color',
														'title' => 'Light Color',
														'val' => get_option('wpbooked_light_color','#3745A4'),
														'default' => '#3745A4'
													),
													array(
														'name' => 'wpbooked_dark_color',
														'title' => 'Dark Color',
														'val' => get_option('wpbooked_dark_color','#f0f0f0'),
														'default' => '#f0f0f0'

													),
													array(
														'name' => 'wpbooked_button_color',
														'title' => 'Primary Button Color',
														'val' => get_option('wpbooked_button_color','#3745A4'),
														'default' => '#3745A4'

													),
												);

												foreach($color_options as $color_option):

													echo '<label class="wpbooked-color-label" for="'.esc_attr($color_option['name']).'">'.esc_html($color_option['title']).'</label>';
													echo '<input data-default-color="'.esc_attr($color_option['default']).'" type="text" name="'.esc_html($color_option['name']).'" value="'.esc_html($color_option['val']).'" id="'.esc_html($color_option['name']).'" class="wpbooked-color-field" />';

												endforeach;
												?>

											</div><!-- /.section-body -->
										</div>

										<div class="section-row submit-section" style="padding:0;">
											<?php @submit_button(); ?>
										</div><!-- /.section-row -->

									</div>

									<div id="wpbooked-email-settings" class="tab-content">

										<div class="section-row">
											<div class="section-head">
												<p style="background:#fff; padding:13px 19px 12px; border-left:3px solid #aaa; -moz-border-radius:3px; -webkit-border-radius:3px; border-radius:3px; box-shadow:0 1px 3px rgba(0,0,0,0.10); margin:0; font-size:15px; line-height:1.6;"><?php esc_html_e('If you DO NOT want to send emails for any of the actions listed below, just remove the email subject or content text (or both) and the email will not be sent for that notification.','wpbooked'); ?></p>
											</div>
										</div>

										<?php $email_template_tabs = apply_filters( 'wpbooked_admin_email_template_tabs', array(
											'customer-emails' => esc_html__('Customer Emails','wpbooked'),
											'admin-emails' => esc_html__('Admin/Agent Emails','wpbooked'),
											'email-settings' => esc_html__('Settings','wpbooked')
										));

										$tab_counter = 0; ?>

										<?php do_action( 'wpbooked_admin_before_email_tabs' ); ?>

										<ul class="wpbooked-admin-subtabs WPbookedClearFix">
											<?php foreach( $email_template_tabs as $tab_name => $tab_text ): $tab_counter++; ?>
												<li<?php if ( $tab_counter == 1): ?> class="active"<?php endif; ?>><a href="#<?php echo esc_attr($tab_name); ?>"><?php echo esc_html($tab_text); ?></a></li>
											<?php endforeach; ?>
										</ul>

										<?php do_action( 'wpbooked_admin_after_email_tabs' ); ?>

										<?php do_action( 'wpbooked_admin_before_email_tab_content' ); ?>

										<div id="wpbooked-subtab-email-settings" class="subtab-content">

											<div class="section-row">
												<div class="section-head"><?php

													$option_name = 'wpbooked_email_logo';
													$booked_email_logo = get_option($option_name);
													$section_title = esc_html__('Header/Logo Image', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('Choose an image for your custom emails. Keep it 600px or less for best results.','wpbooked'); ?></p>

													<input id="<?php echo esc_attr($option_name); ?>" name="<?php echo esc_attr($option_name); ?>" value="<?php echo esc_html($booked_email_logo); ?>" type="hidden" />
													<input id="wpbooked_email_logo_button" class="button button-primary" name="wpbooked_email_logo_button" type="button" value="<?php esc_html_e('Upload Logo','wpbooked'); ?>" />

													<input id="wpbooked_email_logo_button_remove"<?php echo ( !$booked_email_logo ? ' style="display:none;"' : '' ); ?> class="button" name="wpbooked_email_logo_button_remove" type="button" value="<?php esc_html_e('Remove','wpbooked'); ?>" />
													<img src="<?php echo esc_url($booked_email_logo); ?>"<?php echo ( !$booked_email_logo ? ' style="display:none;"' : '' ); ?> id="wpbooked_email_logo-img">

												</div>
											</div>

											<div class="section-row">
												<div class="section-head">
													<?php $section_title = esc_html__('Which Administrator or Booking Agent user should receive the notification emails by default?', 'wpbooked'); ?>
													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('By default, Booked uses the "Settings > General > E-mail Address" setting. Also, each custom calendar can have their own user notification setting, this is just the default.','wpbooked'); ?></p>

													<?php $option_name = 'wpbooked_default_email_user';

													$allowed_users = get_users( array( 'role__in' => array( 'administrator', 'wpbooked_booking_agent' ) ) );

													$selected_value = get_option($option_name); ?>
													<div class="select-box">
														<select name="<?php echo esc_html($option_name); ?>">
															<option value=""><?php esc_html_e('Choose a default user for notifications','wpbooked'); ?> ...</option>
															<?php if(!empty($allowed_users)) :
																foreach($allowed_users as $u) :
																	$user_id = $u->ID;
																	$email = $u->data->user_email;
																	$display_name = ( isset( $u->data->display_name ) && $u->data->display_name ? $u->data->display_name . ' (' . $email .')' : $email ); ?>
																	<option value="<?php echo esc_html($email); ?>"<?php echo esc_html($selected_value == $email ? ' selected="selected"' : ''); ?>><?php echo esc_html($display_name); ?></option>
																<?php endforeach;

															endif; ?>
														</select>
													</div><!-- /.select-box -->
												</div><!-- /.section-body -->
											</div><!-- /.section-row -->

											<?php $selected_value = get_option('wpbooked_email_force_sender',false); ?>
											<?php $selected_email = get_option('wpbooked_email_force_sender_from',false); ?>
											<?php $selected_booked_mailer = get_option('wpbooked_emailer_disabled',false); ?>

											<div class="section-row">
												<div class="section-head">

													<h3><?php echo esc_html__('Having Email Issues?', 'wpbooked'); ?></h3>
													<p style="margin-bottom:2.5em;"><?php 
													// translators: %s represents the action to be taken. Example: "WP Mail SMTP link",%s represents the action to be taken. Example: "Easy WP SMTP link"
													echo sprintf( esc_html__('Try using an SMTP plugin like %1$s or %2$s','wpbooked'), '<a href="https://wordpress.org/plugins/wp-mail-smtp/" target="_blank">WP Mail SMTP</a>', '<a href="https://wordpress.org/plugins/easy-wp-smtp/" target="_blank">Easy WP SMTP</a>' ); ?></p>

													<h3><?php echo esc_html__('Emails ONLY NOT sending to Admins/Agents?', 'wpbooked'); ?></h3>
													<p><?php esc_html_e('Some SMTP clients reject emails being sent "from" your customers. Google is one of them, but they simply change the name of the sender to prevent the rejection. Others do not. You can check the following option to "Force the sender name/email", but you will not be able to reply directly to the notification emails coming from customers.','wpbooked'); ?></p>

													<p style="margin:1.2em 0 15px;">
														<input data-condition="force_sender" style="margin:-4px 5px 0 0;" id="wpbooked_email_force_sender" name="wpbooked_email_force_sender" value="true"<?php if ($selected_value): echo ' checked="checked"'; endif; ?> type="checkbox">
														<label class="checkbox-radio-label" for="wpbooked_email_force_sender"><strong><?php esc_html_e("Force sender email", "booked"); ?></strong></label>
													</p>

													<p class="condition-block force_sender"<?php echo ( $selected_value ? ' style="display:block;"' : '' ); ?>>
														<input style="margin:0" name="wpbooked_email_force_sender_from" value="<?php echo ( $selected_email ? esc_attr($selected_email) : esc_attr(get_option('admin_email')) ); ?>" type="text" class="field">
													</p>

													<h3 style="margin-top:2em;"><?php echo esc_html__('Still not working?', 'wpbooked'); ?></h3>
													<p><?php esc_html_e('If you are still having issues, check the box below to disable the Booked mailer and let WordPress handle the emails completely.','wpbooked'); ?></p>

													<p style="margin:1.2em 0 0;">
														<input style="margin:-4px 5px 0 0;" id="wpbooked_emailer_disabled" name="wpbooked_emailer_disabled" value="true"<?php if ($selected_booked_mailer): echo ' checked="checked"'; endif; ?> type="checkbox">
														<label class="checkbox-radio-label" for="wpbooked_emailer_disabled"><strong><?php esc_html_e("Disable Booked mailer, let WordPress handle it.", "booked"); ?></strong></label>
													</p>

												</div>
											</div>

										</div>
										<div id="wpbooked-subtab-customer-emails" class="subtab-content">

											<div class="section-row">
												<div class="section-head">
													<?php $section_title = esc_html__('Customer Appointment Reminder', 'wpbooked'); ?>
													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('When do you want to send out appointment reminders?','wpbooked'); ?></p>

													<?php $option_name = 'wpbooked_reminder_buffer';
													$selected_value = get_option($option_name,30);

													$interval_options = array(
														'0' 				=> esc_html__('At appointment time','wpbooked'),
														'5' 				=> esc_html__('5 minutes before','wpbooked'),
														'10' 				=> esc_html__('10 minutes before','wpbooked'),
														'15' 				=> esc_html__('15 minutes before','wpbooked'),
														'30' 				=> esc_html__('30 minutes before','wpbooked'),
														'45' 				=> esc_html__('45 minutes before','wpbooked'),
														'60' 				=> esc_html__('1 hour before','wpbooked'),
														'120' 				=> esc_html__('2 hours before','wpbooked'),
														'180' 				=> esc_html__('3 hours before','wpbooked'),
														'240' 				=> esc_html__('4 hours before','wpbooked'),
														'300' 				=> esc_html__('5 hours before','wpbooked'),
														'360' 				=> esc_html__('6 hours before','wpbooked'),
														'720' 				=> esc_html__('12 hours before','wpbooked'),
														'1440' 				=> esc_html__('24 hours before','wpbooked'),
														'2880' 				=> esc_html__('2 days before','wpbooked'),
														'4320' 				=> esc_html__('3 days before','wpbooked'),
														'5760' 				=> esc_html__('4 days before','wpbooked'),
														'7200' 				=> esc_html__('5 days before','wpbooked'),
														'8640' 				=> esc_html__('6 days before','wpbooked'),
														'10080' 			=> esc_html__('1 week before','wpbooked'),
														'20160' 			=> esc_html__('2 weeks before','wpbooked'),
														'30240' 			=> esc_html__('3 weeks before','wpbooked'),
														'40320' 			=> esc_html__('4 weeks before','wpbooked'),
														'60480' 			=> esc_html__('6 weeks before','wpbooked'),
														'80640' 			=> esc_html__('2 months before','wpbooked'),
														'120960' 			=> esc_html__('3 months before','wpbooked'),
													); ?>

													<div class="select-box">
														<select name="<?php echo esc_html($option_name); ?>">
															<?php foreach($interval_options as $current_value => $option_title):
																echo '<option value="'.esc_html($current_value).'"' . ($selected_value == $current_value ? ' selected' : ''). '>' . esc_html($option_title) . '</option>';
															endforeach; ?>
														</select>
													</div><!-- /.select-box -->

													<p><strong><?php esc_html_e('Please Note:','wpbooked'); ?></strong> <?php esc_html_e('WordPress crons do not run unless someone visits your site. Because of this, some reminders might not get sent out. To prevent this from happening, you would need to setup cron to run from the server level using the following command:','wpbooked'); ?></p>
													<p><code>*/5 * * * * wget -q -O - <?php echo esc_url(get_site_url()); ?>/wp-cron.php?doing_wp_cron</code></p>

												</div><!-- /.section-body -->
											</div><!-- /.section-row -->

											<div class="section-row">
												<div class="section-head">
													<?php $option_name = 'wpbooked_reminder_email';

$default_content = 'Just a friendly reminder that you have an appointment coming up soon! Here\'s the appointment information:

<strong>Calendar:</strong> %calendar%
<strong>Date:</strong> %date%
<strong>Time:</strong> %time%

Sincerely,
Your friends at '.get_bloginfo('name');

													$email_content_admin_reminder = get_option($option_name,$default_content);
													$section_title = esc_html__('Customer Appointment Reminder Content', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('This is the email content for appoinment reminders. Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<?php $booked_mailer_tokens = wpbooked_mailer_tokens();
														foreach( $booked_mailer_tokens as $token => $desc ):
															echo '<li><strong>%' . esc_html($token) . '%</strong> &mdash; ' . esc_html($desc) . '</li>';
														endforeach; ?>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_reminder_email_subject';
													$subject_default = 'Reminder: You have an appointment coming up soon!';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_admin_reminder, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 250,'teeny' => true) ); ?>

												</div>
											</div><!-- /.section-row -->

											<div class="section-row">
												<div class="section-head">
													<?php $option_name = 'wpbooked_registration_email_content';

$default_content = 'Hey %name%!

Thanks for registering at '.get_bloginfo('name').'. You can now login to manage your account and appointments using the following credentials:

Email Address: %email%
Password: %password%

Sincerely,
Your friends at '.get_bloginfo('name');

													$email_content_registration = get_option($option_name,$default_content);
													$section_title = esc_html__('User Registration', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('The email content that is sent to the user upon registration (using the Booked registration form). Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<li><strong>%name%</strong> &mdash; <?php esc_html_e("To display the person's name.","booked"); ?></li>
														<li><strong>%email%</strong> &mdash; <?php esc_html_e("To display the person's email address.","booked"); ?></li>
														<li><strong>%password%</strong> &mdash; <?php esc_html_e("To display the password for login.","booked"); ?></li>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_registration_email_subject';
													$subject_default = 'Thank you for registering!';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_registration, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 350,'teeny' => true) ); ?>

												</div>
											</div><!-- /.section-row -->

											<div class="section-row" data-controller="cp_fes_controller" data-controlled_by="fes_enabled">
												<div class="section-head">
													<?php $option_name = 'wpbooked_appt_confirmation_email_content';

$default_content = 'Hey %name%!

This is just an email to confirm your appointment. For reference, here\'s the appointment information:

Date: %date%
Time: %time%

Sincerely,
Your friends at '.get_bloginfo('name');

													$email_content_approval = get_option($option_name,$default_content);
													$section_title = esc_html__('Appointment Confirmation', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('The email content that is sent to the user upon appointment creation. Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<?php $booked_mailer_tokens = wpbooked_mailer_tokens();
														foreach( $booked_mailer_tokens as $token => $desc ):
															echo '<li><strong>%' . esc_html($token) . '%</strong> &mdash; ' . esc_html($desc) . '</li>';
														endforeach; ?>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_appt_confirmation_email_subject';
													$subject_default = 'Your appointment confirmation from '.get_bloginfo('name').'.';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_approval, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 350,'teeny' => true) ); ?>
												</div>
											</div><!-- /.section-row -->

											<div class="section-row" data-controller="cp_fes_controller" data-controlled_by="fes_enabled">
												<div class="section-head">
													<?php $option_name = 'wpbooked_approval_email_content';

$default_content = 'Hey %name%!

The appointment you requested at '.get_bloginfo('name').' has been approved! Here\'s your appointment information:

Date: %date%
Time: %time%

Sincerely,
Your friends at '.get_bloginfo('name');

													$email_content_approval = get_option($option_name,$default_content);
													$section_title = esc_html__('Appointment Approval', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('The email content that is sent to the user upon appointment approval. Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<?php $booked_mailer_tokens = wpbooked_mailer_tokens();
														foreach( $booked_mailer_tokens as $token => $desc ):
															echo '<li><strong>%' . esc_html($token) . '%</strong> &mdash; ' . esc_html($desc) . '</li>';
														endforeach; ?>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_approval_email_subject';
													$subject_default = 'Your appointment has been approved!';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_approval, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 350,'teeny' => true) ); ?>
												</div>
											</div><!-- /.section-row -->

											<div class="section-row" data-controller="cp_fes_controller" data-controlled_by="fes_enabled">
												<div class="section-head">
													<?php $option_name = 'wpbooked_cancellation_email_content';

$default_content = 'Hey %name%!

The appointment you requested at '.get_bloginfo('name').' has been cancelled. For reference, here\'s the appointment information:

Date: %date%
Time: %time%

Sincerely,
Your friends at '.get_bloginfo('name');

													$email_content_approval = get_option($option_name,$default_content);
													$section_title = esc_html__('Appointment Cancellation', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('The email content that is sent to the user upon appointment cancellation. Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<?php $booked_mailer_tokens = wpbooked_mailer_tokens();
														foreach( $booked_mailer_tokens as $token => $desc ):
															echo '<li><strong>%' . esc_html($token) . '%</strong> &mdash; ' . esc_html($desc) . '</li>';
														endforeach; ?>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_cancellation_email_subject';
													$subject_default = 'Your appointment has been cancelled.';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_approval, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 350,'teeny' => true) ); ?>

												</div>
											</div><!-- /.section-row -->

										</div>
										<div id="wpbooked-subtab-admin-emails" class="subtab-content">

											<div class="section-row">
												<div class="section-head">
													<?php $section_title = esc_html__('Admin/Agent Appointment Reminder', 'wpbooked'); ?>
													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('When do you want to send out appointment reminders?','wpbooked'); ?></p>

													<?php $option_name = 'wpbooked_admin_reminder_buffer';
													$selected_value = get_option($option_name,30);

													$interval_options = array(
														'0' 				=> esc_html__('At appointment time','wpbooked'),
														'5' 				=> esc_html__('5 minutes before','wpbooked'),
														'10' 				=> esc_html__('10 minutes before','wpbooked'),
														'15' 				=> esc_html__('15 minutes before','wpbooked'),
														'30' 				=> esc_html__('30 minutes before','wpbooked'),
														'45' 				=> esc_html__('45 minutes before','wpbooked'),
														'60' 				=> esc_html__('1 hour before','wpbooked'),
														'120' 				=> esc_html__('2 hours before','wpbooked'),
														'180' 				=> esc_html__('3 hours before','wpbooked'),
														'240' 				=> esc_html__('4 hours before','wpbooked'),
														'300' 				=> esc_html__('5 hours before','wpbooked'),
														'360' 				=> esc_html__('6 hours before','wpbooked'),
														'720' 				=> esc_html__('12 hours before','wpbooked'),
														'1440' 				=> esc_html__('24 hours before','wpbooked'),
														'2880' 				=> esc_html__('2 days before','wpbooked'),
														'4320' 				=> esc_html__('3 days before','wpbooked'),
														'5760' 				=> esc_html__('4 days before','wpbooked'),
														'7200' 				=> esc_html__('5 days before','wpbooked'),
														'8640' 				=> esc_html__('6 days before','wpbooked'),
														'10080' 			=> esc_html__('1 week before','wpbooked'),
														'20160' 			=> esc_html__('2 weeks before','wpbooked'),
														'30240' 			=> esc_html__('3 weeks before','wpbooked'),
														'40320' 			=> esc_html__('4 weeks before','wpbooked'),
														'60480' 			=> esc_html__('6 weeks before','wpbooked'),
														'80640' 			=> esc_html__('2 months before','wpbooked'),
														'120960' 			=> esc_html__('3 months before','wpbooked'),
													); ?>

													<div class="select-box">
														<select name="<?php echo esc_html($option_name); ?>">
															<?php foreach($interval_options as $current_value => $option_title):
																echo '<option value="'.esc_html($current_value).'"' . ($selected_value == $current_value ? ' selected' : ''). '>' . esc_html($option_title) . '</option>';
															endforeach; ?>
														</select>
													</div><!-- /.select-box -->

													<p><strong><?php esc_html_e('Please Note:','wpbooked'); ?></strong> <?php esc_html_e('WordPress crons do not run unless someone visits your site. Because of this, some reminders might not get sent out. To prevent this from happening, you would need to setup cron to run from the server level using the following command:','wpbooked'); ?></p>
													<p><code>*/5 * * * * wget -q -O - <?php echo esc_url(get_site_url()); ?>/wp-cron.php?doing_wp_cron</code></p>

												</div><!-- /.section-body -->
											</div><!-- /.section-row -->

											<div class="section-row">
												<div class="section-head">
													<?php $option_name = 'wpbooked_admin_reminder_email';

$default_content = 'You have an appointment coming up soon! Here\'s the appointment information:

<strong>Customer:</strong> %name%
<strong>Date:</strong> %date%
<strong>Time:</strong> %time%

(Sent via the '.get_bloginfo('name').' website)';

													$email_content_admin_reminder = get_option($option_name,$default_content);
													$section_title = esc_html__('Admin/Agent Appointment Reminder Content', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('This is the email content for appoinment reminders. Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<?php $booked_mailer_tokens = wpbooked_mailer_tokens();
														foreach( $booked_mailer_tokens as $token => $desc ):
															echo '<li><strong>%' . esc_html($token) . '%</strong> &mdash; ' . esc_html($desc) . '</li>';
														endforeach; ?>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_admin_reminder_email_subject';
													$subject_default = 'An appointment is coming up soon!';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_admin_reminder, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 250,'teeny' => true) ); ?>

												</div>
											</div><!-- /.section-row -->

											<div class="section-row">
												<div class="section-head">
													<?php $option_name = 'wpbooked_admin_appointment_email_content';

$default_content = 'You have a new appointment request! Here\'s the appointment information:

Customer: %name%
Date: %date%
Time: %time%

Log into your website here: '.get_admin_url().' to approve this appointment.

(Sent via the '.get_bloginfo('name').' website)';

													$email_content_registration = get_option($option_name,$default_content);
													$section_title = esc_html__('Appointment Request', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('The email content that is sent (to the selected admin users above) upon appointment request. Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<?php $booked_mailer_tokens = wpbooked_mailer_tokens();
														foreach( $booked_mailer_tokens as $token => $desc ):
															echo '<li><strong>%' . esc_html($token) . '%</strong> &mdash; ' . esc_html($desc) . '</li>';
														endforeach; ?>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_admin_appointment_email_subject';
													$subject_default = 'You have a new appointment request!';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_registration, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 350,'teeny' => true) ); ?>

												</div>
											</div><!-- /.section-row -->

											<div class="section-row">
												<div class="section-head">
													<?php $option_name = 'wpbooked_admin_cancellation_email_content';

$default_content = 'One of your customers has cancelled their appointment. Here\'s the appointment information:

Customer: %name%
Date: %date%
Time: %time%

(Sent via the '.get_bloginfo('name').' website)';

													$email_content_registration = get_option($option_name,$default_content);
													$section_title = esc_html__('Appointment Cancellation', 'wpbooked'); ?>

													<h3><?php echo esc_attr($section_title); ?></h3>
													<p><?php esc_html_e('The email content that is sent (to the selected admin users above) upon cancellation. Some tokens you can use:','wpbooked'); ?></p>
													<ul class="cp-list">
														<?php $booked_mailer_tokens = wpbooked_mailer_tokens();
														foreach( $booked_mailer_tokens as $token => $desc ):
															echo '<li><strong>%' . esc_html($token) . '%</strong> &mdash; ' . esc_html($desc) . '</li>';
														endforeach; ?>
													</ul><br>

													<?php

													$subject_var = 'wpbooked_admin_cancellation_email_subject';
													$subject_default = 'An appointment has been cancelled.';
													$current_subject_value = get_option($subject_var,$subject_default); ?>

													<input style="margin:0" name="<?php echo esc_attr($subject_var); ?>" value="<?php echo esc_attr($current_subject_value); ?>" type="text" class="field">
													<?php wp_editor( $email_content_registration, $option_name, array('textarea_name' => $option_name,'media_buttons' => false,'editor_height' => 250,'teeny' => true) ); ?>

												</div>
											</div><!-- /.section-row -->

										</div>

										<?php do_action( 'wpbooked_admin_after_email_tab_content' ); ?>

										<div class="section-row submit-section" style="padding:0;">
											<?php @submit_button(); ?>
										</div><!-- /.section-row -->

									</div><!-- /templates -->

								</form>

							<?php break;
							
							case 'woocommerce-settings':
							
								if ( class_exists('woocommerce') ):
							
								?><div id="wpbooked-woocommerce-settings" class="wpbooked-payment-settings-wrap tab-content">
									<form action="options.php" method="post">
										<div class="section-row">
											<div class="section-head">
												<?php settings_fields( WPBOOKED_WC_PLUGIN_PREFIX . 'payment_options' );
												do_settings_sections( WPBOOKED_WC_PLUGIN_PREFIX . 'payment_options' );
											?></div>
										</div><?php
										submit_button(); ?>
									</form>
								</div><?php
								
								endif;
							
							break;
							
							case 'calendar-feeds': ?>
								
								<div id="wpbooked-calendar-feeds" class="tab-content">
									
									<div class="section-row">
										<div class="section-head">
											<?php $section_title = esc_html__('Calendar Feeds', 'wpbooked'); ?>
											<h3 style="font-size:17px; margin:0; padding:0 0 5px;"><?php echo esc_html($section_title); ?></h3>
									
											<?php $secure_hash = md5( home_url() ); ?>
										
											<p style="width:50%; font-size:14px; margin:0; padding:0 0 20px;"><?php esc_html_e('Use the following URLs to either download a static feed (not auto-updating) or paste the URL into your favorite calendar app (Google Calendar, Apple Calendar, etc.) as a subscription to load a read-only auto-updating appointment feed.','booked-ical'); ?></p>
											
											<p style="font-size:15px; margin:0; padding:0 0 10px;"><strong><?php esc_html_e('All Appointments','booked-ical'); ?></strong></p>
											<p style="font-size:15px; margin:0; padding:0 0 20px;"><input readonly="readonly" type="text" style="width:50%;" value="<?php echo esc_url(get_site_url()); ?>/?wpbooked_ical&sh=<?php echo esc_attr( WPBOOKEDICAL_SECURE_HASH ); ?>"></p>
											
											<?php $calendars = get_terms('wpbooked_custom_calendars','orderby=slug&hide_empty=0');
												
											if (!empty($calendars)):
												
												foreach($calendars as $calendar):
													
													?><p style="font-size:15px; margin:0; padding:0 0 10px;"><strong><?php echo esc_html($calendar->name); ?></strong></p>
													<p style="font-size:15px; margin:0; padding:0 0 20px;"><input readonly="readonly" type="text" style="width:50%;" value="<?php echo esc_url(get_site_url()); ?>/?wpbooked_ical&calendar=<?php echo esc_attr($calendar->term_id); ?>&sh=<?php echo esc_attr( WPBOOKEDICAL_SECURE_HASH ); ?>"></p><?php
												
												endforeach;
															
											endif; ?>
										</div>
									</div>
								
								</div>
							
							<?php break;

							case 'defaults': ?>

								<div id="wpbooked-defaults" class="tab-content">

									<?php if (!$booked_none_assigned && count($calendars) >= 1):

										?><div id="wpbooked-timeslotsSwitcher">
											<p><strong><?php esc_html_e('Editing time slots for:','wpbooked'); ?></strong></p>
											<?php

											echo '<select name="bookedTimeslotsDisplayed">';
											if (current_user_can('manage_booked_options')): echo '<option value="">'.esc_html__('Default Calendar','wpbooked').'</option>'; endif;

											foreach($calendars as $calendar):

												?><option value="<?php echo esc_html($calendar->term_id); ?>"><?php echo esc_html($calendar->name); ?></option><?php

											endforeach;

											echo '</select>';

										?></div><?php

									endif; ?>

									<div id="wpbookedTimeslotsWrap">
										<?php if (current_user_can('manage_booked_options')):
 wpbooked_render_timeslots();
										else:
											$first_calendar = reset($calendars);
 wpbooked_render_timeslots($first_calendar->term_id);
										endif; ?>
									</div>

									<?php $timeslot_intervals = get_option('wpbooked_timeslot_intervals',5); ?>

									<div id="timepickerTemplate" class="WPbookedClearFix">
										<div class="timeslotTabs WPbookedClearFix">
											<a class="addTimeslotTab active" href="#Single"><?php esc_html_e('Single','wpbooked'); ?></a>
											<a class="addTimeslotTab" href="#Bulk"><?php esc_html_e('Bulk','wpbooked'); ?></a>
										</div>
										<div class="tsTabContent tsSingle">
											<?php echo wp_kses(wpbooked_render_single_timeslot_form($timeslot_intervals),['form'=>['id'=>[],'action'=>[],'method'=>[]],'input'=>['type'=>[],'name'=>[],'placeholder'=>[]],'select'=>['name'=>[]],'option'=>['value'=>[],'selected'=>[]]]); ?>
										</div>
										<div class="tsTabContent tsBulk">
											<?php echo wp_kses(wpbooked_render_bulk_timeslot_form($timeslot_intervals),['form'=>['id'=>[],'action'=>[],'method'=>[]],'input'=>['type'=>[],'name'=>[],'placeholder'=>[]],'select'=>['name'=>[]],'option'=>['value'=>[],'selected'=>[]]]); ?>
										</div>
										<span class="cancel button"><?php esc_html_e('Close','wpbooked'); ?></span>
									</div>

								</div><!-- /templates -->

							<?php break;

							case 'custom-timeslots': ?>

								<div id="wpbooked-custom-timeslots" class="tab-content">

									<form action="" id="customTimeslots">

										<div id="customTimeslotsWrapper">
											<div id="customTimeslotsContainer">

												<?php

												// Any custom time slots saved already?
												$booked_custom_timeslots_encoded = get_option('wpbooked_custom_timeslots_encoded');
												$booked_custom_timeslots_decoded = json_decode($booked_custom_timeslots_encoded,true);

												$available_calendar_ids = array();

												foreach($calendars as $this_calendar):
													$available_calendar_ids[] = $this_calendar->term_id;
												endforeach;

												if (!empty($booked_custom_timeslots_decoded)):

													$custom_timeslots_array = wpbooked_custom_timeslots_reconfigured($booked_custom_timeslots_decoded);
													foreach($custom_timeslots_array as $key => $timeslot):
														$date_string = date_i18n('Ymd',strtotime($timeslot['wpbooked_custom_start_date']));
														$new_custom_timeslots_array[$date_string.$key] = $timeslot;
													endforeach;

													$custom_timeslots_array = $new_custom_timeslots_array;

													ksort($custom_timeslots_array);
													$current_timeslot_month_year = false;

													foreach($custom_timeslots_array as $this_timeslot):

														$this_timeslot['wpbooked_custom_calendar_id'] = isset($this_timeslot['wpbooked_custom_calendar_id']) ? $this_timeslot['wpbooked_custom_calendar_id'] : false;
														$this_timeslot_month_year = ( $this_timeslot['wpbooked_custom_start_date'] ? date_i18n('F, Y',strtotime($this_timeslot['wpbooked_custom_start_date'])) : '<span style="color:#dd0000;">'.esc_html__('No "Start date" has been set for these:').'</span>' );

														if (!$current_timeslot_month_year || $current_timeslot_month_year != $this_timeslot_month_year):
															$current_timeslot_month_year = $this_timeslot_month_year;
															echo '<h3 class="wpbooked-ct-date-heading">'.esc_attr($current_timeslot_month_year).'</h3>';
														endif;

														?><div class="wpbooked-customTimeslot"<?php if (!current_user_can('manage_booked_options') && $this_timeslot['wpbooked_custom_calendar_id'] && !in_array($this_timeslot['wpbooked_custom_calendar_id'],$available_calendar_ids)): echo ' style="display:none;"'; endif; ?>>

															<?php

															if (!empty($calendars)):

															    if (!current_user_can('manage_booked_options') && $this_timeslot['wpbooked_custom_calendar_id'] && !in_array($this_timeslot['wpbooked_custom_calendar_id'],$available_calendar_ids)):

															        ?><input type="hidden" name="wpbooked_custom_calendar_id" value="<?php echo esc_html($this_timeslot['wpbooked_custom_calendar_id']); ?>"><?php

															    else:

															        echo '<select name="wpbooked_custom_calendar_id">';
																

															            if (current_user_can('manage_booked_options')): echo '<option value="">'.esc_html__('Default Calendar','wpbooked').'</option>'; endif;

															            foreach($calendars as $calendar):

															                ?><option <?php if ($this_timeslot['wpbooked_custom_calendar_id'] == $calendar->term_id): echo ' selected="selected"'; endif; ?> value="<?php echo esc_html($calendar->term_id); ?>"><?php echo esc_html($calendar->name); ?></option><?php

															            endforeach;

															        echo '</select>';

															    endif;

															else:

															    ?><input type="hidden" name="wpbooked_custom_calendar_id" value=""><?php

															endif; ?>

															<input type="text" placeholder="<?php esc_html_e("Start date","booked"); ?>..." class="wpbooked_custom_start_date" name="wpbooked_custom_start_date" value="<?php echo esc_attr( $this_timeslot['wpbooked_custom_start_date'] ? date_i18n( 'Y-m-d', strtotime( $this_timeslot['wpbooked_custom_start_date'] ) ) : '' ); ?>">
															<input type="text" placeholder="<?php esc_html_e("Optional End date","booked"); ?>..." class="wpbooked_custom_end_date" name="wpbooked_custom_end_date" value="<?php echo esc_attr( $this_timeslot['wpbooked_custom_end_date'] ? date_i18n( 'Y-m-d', strtotime( $this_timeslot['wpbooked_custom_end_date'] ) ) : '' ); ?>">

															<?php if (isset($this_timeslot['wpbooked_this_custom_timelots']) && is_array($this_timeslot['wpbooked_this_custom_timelots'])): ?>
																<input type="hidden" name="wpbooked_this_custom_timelots" value="<?php echo esc_attr(json_encode($this_timeslot['wpbooked_this_custom_timelots'])); ?>">
															<?php else : ?>
																<input type="hidden" name="wpbooked_this_custom_timelots" value="<?php echo esc_attr($this_timeslot['wpbooked_this_custom_timelots']); ?>">
															<?php endif; ?>

															<?php if (isset($this_timeslot['wpbooked_this_custom_timelots_details']) && is_array($this_timeslot['wpbooked_this_custom_timelots_details'])): ?>
																<input type="hidden" name="wpbooked_this_custom_timelots_details" value="<?php echo esc_attr(json_encode($this_timeslot['wpbooked_this_custom_timelots_details'])); ?>">
															<?php else : ?>
																<input type="hidden" name="wpbooked_this_custom_timelots_details" value="<?php echo esc_attr($this_timeslot['wpbooked_this_custom_timelots_details']); ?>">
															<?php endif; ?>

															<input id="vacationDayCheckbox" name="vacationDayCheckbox" type="checkbox" value="1"<?php if ($this_timeslot['vacationDayCheckbox']): echo ' checked="checked"'; endif; ?>>
															<label for="vacationDayCheckbox"><?php esc_html_e('Disable appointments','wpbooked'); ?></label>

															<a href="#" class="deleteCustomTimeslot"><i class="fa-solid fa-xmark"></i></a>

															<?php

															if (is_array($this_timeslot['wpbooked_this_custom_timelots'])):
																$timeslots = $this_timeslot['wpbooked_this_custom_timelots'];
															else:
																$timeslots = json_decode($this_timeslot['wpbooked_this_custom_timelots'],true);
															endif;

															if (isset($this_timeslot['wpbooked_this_custom_timelots_details']) && is_array($this_timeslot['wpbooked_this_custom_timelots_details'])):
																$timeslots_details = $this_timeslot['wpbooked_this_custom_timelots_details'];
															elseif(isset($this_timeslot['wpbooked_this_custom_timelots_details'])):
																$timeslots_details = json_decode($this_timeslot['wpbooked_this_custom_timelots_details'],true);
															endif;

															echo '<div class="customTimeslotsList">';

															if (!empty($timeslots)):

																echo '<div class="cts-header"><span class="slotsTitle">'.esc_html__('Spaces Available','wpbooked').'</span>'.esc_html__('Time Slot','wpbooked').'</div>';

																foreach ($timeslots as $timeslot => $count):

																	$time = explode('-',$timeslot);
																	$time_format = get_option('time_format');

																	echo '<span class="timeslot" data-timeslot="'.esc_attr($timeslot).'">';
																		echo '<span class="slotsBlock"><span class="changeCount minus" data-count="-1"><i class="fa-solid fa-circle-minus"></i></span><span class="count"><em>'.esc_attr($count).'</em> ' .esc_html(_n('Space Available','Spaces Available',$count,'wpbooked')) . '</span><span class="changeCount add" data-count="1"><i class="fa-solid fa-circle-plus"></i></span></span>';

																		do_action( 'wpbooked_single_custom_timeslot_start', $this_timeslot, $timeslot, $this_timeslot['wpbooked_custom_calendar_id'] );

																		if ( !empty($timeslots_details[$timeslot]) ) {

																			if ( !empty($timeslots_details[$timeslot]['title']) ) {
																				echo '<span class="title">' . esc_html($timeslots_details[$timeslot]['title']) . '</span>';
																			}
																		}

																		if ($time[0] == '0000' && $time[1] == '2400'):
																			echo '<span class="start"><i class="fa-solid fa-clock"></i>&nbsp;&nbsp;' . esc_html(strtoupper(__('All day','wpbooked'))) . '</span>';
																		else :
																			echo '<span class="start"><i class="fa-solid fa-clock"></i>&nbsp;&nbsp;' . esc_html(date_i18n($time_format,strtotime('2014-01-01 '.$time[0]))) . '</span> &ndash; <span class="end">' . esc_html(date_i18n($time_format,strtotime('2014-01-01 '.$time[1]))) . '</span>';
																		endif;

																		do_action( 'wpbooked_single_custom_timeslot_end', $this_timeslot, $timeslot, $this_timeslot['wpbooked_custom_calendar_id'] );

																		echo '<span class="delete"><i class="fa-solid fa-xmark"></i></span>';
																	echo '</span>';

																endforeach;
															endif;

															echo '</div>';

															?>

															<button class="button addSingleTimeslot"><?php esc_html_e('+ Single Time Slot','wpbooked'); ?></button>
															<button class="button addBulkTimeslots"><?php esc_html_e('+ Bulk Time Slots','wpbooked'); ?></button>

														</div><?php

													endforeach;
												endif;

												?>

											</div>
										</div>

										<div class="section-row submit-section WPbookedClearFix" style="padding:0;">
											<button class="button addCustomTimeslot"><?php esc_html_e('Add Date(s)','wpbooked'); ?></button>
											<input id="wpbooked-saveCustomTimeslots" type="button" disabled="true" class="button saveCustomTimeslots" value="<?php esc_html_e('Save Custom Time Slots','wpbooked'); ?>">
											<div class="cts-updater savingState"><i class="fa-solid fa-circle-notch fa-spin"></i>&nbsp;&nbsp;<?php esc_html_e('Saving','wpbooked'); ?>...</div>
										</div><!-- /.section-row -->

									</form>

									<input type="hidden" style="width:100%;" id="custom_timeslots_encoded" name="custom_timeslots_encoded" value="<?php echo esc_attr($booked_custom_timeslots_encoded); ?>">

									<div style="border:1px solid #FFBA00;" class="wpbooked-customTimeslotTemplate">

										<?php if (!empty($calendars)):

											echo '<select name="wpbooked_custom_calendar_id">';
												if (current_user_can('manage_booked_options')): echo '<option value="">'.esc_html__('Default Calendar','wpbooked').'</option>'; endif;

												foreach($calendars as $calendar):

													?><option value="<?php echo esc_attr($calendar->term_id); ?>"><?php echo esc_attr($calendar->name); ?></option><?php

												endforeach;

											echo '</select>';

										else: ?>

											<input type="hidden" name="wpbooked_custom_calendar_id" value="">

										<?php endif; ?>

										<input type="text" placeholder="<?php esc_html_e("Start date","booked"); ?>..." class="wpbooked_custom_start_date" name="wpbooked_custom_start_date" value="">
										<input type="text" placeholder="<?php esc_html_e("Optional End date","booked"); ?>..." class="wpbooked_custom_end_date" name="wpbooked_custom_end_date" value="">
										<input type="hidden" name="wpbooked_this_custom_timelots" value="">
										<input type="hidden" name="wpbooked_this_custom_timelots_details" value="">

										<input id="vacationDayCheckbox" name="vacationDayCheckbox" type="checkbox" value="1">
										<label for="vacationDayCheckbox"><?php esc_html_e('Disable appointments','wpbooked'); ?></label>

										<a href="#" class="deleteCustomTimeslot"><i class="fa-solid fa-xmark"></i></a>

										<div class="customTimeslotsList"></div>
										<?php echo wp_kses(wpbooked_render_single_timeslot_form($timeslot_intervals,'custom'),['form'=>['id'=>[],'action'=>[],'method'=>[]],'input'=>['type'=>[],'name'=>[],'placeholder'=>[]],'select'=>['name'=>[]],'option'=>['value'=>[],'selected'=>[]]]); ?>
										<button class="button addSingleTimeslot"><?php esc_html_e('+ Single Time Slot','wpbooked'); ?></button>
										<button class="button addBulkTimeslots"><?php esc_html_e('+ Bulk Time Slots','wpbooked'); ?></button>

									</div>

									<div id="wpbooked-customTimePickerTemplates">
										<div class="customSingle WPbookedClearFix">
											<?php echo wp_kses(wpbooked_render_single_timeslot_form($timeslot_intervals,'custom'),['form'=>['id'=>[],'action'=>[],'method'=>[]],'input'=>['type'=>[],'name'=>[],'placeholder'=>[]],'select'=>['name'=>[]],'option'=>['value'=>[],'selected'=>[]]]); ?>
											<button class="button-primary addSingleTimeslot_button"><?php esc_html_e('Add','wpbooked'); ?></button>
											<button class="button cancel"><?php esc_html_e('Close','wpbooked'); ?></button>
										</div>
										<div class="customBulk WPbookedClearFix">
											<?php echo wp_kses(wpbooked_render_bulk_timeslot_form($timeslot_intervals,'custom'),['form'=>['id'=>[],'action'=>[],'method'=>[]],'input'=>['type'=>[],'name'=>[],'placeholder'=>[]],'select'=>['name'=>[]],'option'=>['value'=>[],'selected'=>[]]]); ?>
											<button class="button-primary addBulkTimeslots_button"><?php esc_html_e('Add','wpbooked'); ?></button>
											<button class="button cancel"><?php esc_html_e('Close','wpbooked'); ?></button>
										</div>
									</div>

								</div>

							<?php break;

							case 'custom-fields': ?>

								<div id="wpbooked-custom-fields" class="tab-content">

									<div class="section-row">
										<div class="section-head">

											<div class="wpbooked-cf-block">

												<?php if (!empty($calendars)):

													echo '<div id="wpbooked-cfSwitcher" style="margin:0 0 30px;">';
														echo '<select name="bookedCustomFieldsDisplayed">';

															if (current_user_can('manage_booked_options')): echo '<option value="">'.esc_html__('Default Calendar','wpbooked').'</option>'; endif;

															foreach($calendars as $calendar):

																?><option value="<?php echo esc_html($calendar->term_id); ?>"><?php echo esc_html($calendar->name); ?></option><?php

															endforeach;

														echo '</select>';
													echo '</div>';

												endif; ?>

												<div id="wpbooked_customFields_Wrap">

													<?php if (current_user_can('manage_booked_options')):
 wpbooked_render_custom_fields();
													else:
														$first_calendar = reset($calendars);
 wpbooked_render_custom_fields($first_calendar->term_id);
													endif; ?>

												</div>

											</div>

											<ul id="wpbooked-cf-sortable-templates">

												<li id="wpbookedCFTemplate-single-line-text-label" class="ui-state-default"><i class="main-handle fa-solid fa-bars"></i>
													<small><?php esc_html_e('Single Line Text','wpbooked'); ?></small>
													<p><input class="cf-required-checkbox" type="checkbox" name="required" id="required"> <label for="required"><?php esc_html_e('Required Field','wpbooked'); ?></label></p>
													<input type="text" name="single-line-text-label" value="" placeholder="<?php esc_html_e('Enter a label for this field...','wpbooked'); ?>" />
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>
												<li id="wpbookedCFTemplate-paragraph-text-label" class="ui-state-default"><i class="main-handle fa-solid fa-bars"></i>
													<small><?php esc_html_e('Paragraph Text','wpbooked'); ?></small>
													<p><input class="cf-required-checkbox" type="checkbox" name="required" id="required"> <label for="required"><?php esc_html_e('Required Field','wpbooked'); ?></label></p>
													<input type="text" name="paragraph-text-label" value="" placeholder="<?php esc_html_e('Enter a label for this field...','wpbooked'); ?>" />
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>
												<li id="wpbookedCFTemplate-checkboxes-label" class="ui-state-default"><i class="main-handle fa-solid fa-bars"></i>
													<small><?php esc_html_e('Checkboxes','wpbooked'); ?></small>
													<p><input class="cf-required-checkbox" type="checkbox" name="required" id="required"> <label for="required"><?php esc_html_e('Required Field','wpbooked'); ?></label></p>
													<input type="text" name="checkboxes-label" value="" placeholder="<?php esc_html_e('Enter a label for this checkbox group...','wpbooked'); ?>" />
													<ul id="wpbooked-cf-checkboxes"></ul>
													<button class="cfButton button" data-type="single-checkbox">+ <?php esc_html_e('Checkbox','wpbooked'); ?></button>
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>
												<li id="wpbookedCFTemplate-radio-buttons-label" class="ui-state-default"><i class="main-handle fa-solid fa-bars"></i>
													<small><?php esc_html_e('Radio Buttons','wpbooked'); ?></small>
													<p><input class="cf-required-checkbox" type="checkbox" name="required" id="required"> <label for="required"><?php esc_html_e('Required Field','wpbooked'); ?></label></p>
													<input type="text" name="radio-buttons-label" value="" placeholder="<?php esc_html_e('Enter a label for this radio button group...','wpbooked'); ?>" />
													<ul id="wpbooked-cf-radio-buttons"></ul>
													<button class="cfButton button" data-type="single-radio-button">+ <?php esc_html_e('Option','wpbooked'); ?></button>
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>
												<li id="wpbookedCFTemplate-drop-down-label" class="ui-state-default"><i class="main-handle fa-solid fa-bars"></i>
													<small><?php esc_html_e('Drop Down','wpbooked'); ?></small>
													<p><input class="cf-required-checkbox" type="checkbox" name="required" id="required"> <label for="required"><?php esc_html_e('Required Field','wpbooked'); ?></label></p>
													<input type="text" name="drop-down-label" value="" placeholder="<?php esc_html_e('Enter a label for this drop-down group...','wpbooked'); ?>" />
													<ul id="wpbooked-cf-drop-down"></ul>
													<button class="cfButton button" data-type="single-drop-down">+ <?php esc_html_e('Option','wpbooked'); ?></button>
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>
												<li id="wpbookedCFTemplate-plain-text-content" class="ui-state-default"><i class="main-handle fa-solid fa-bars"></i>
													<small><?php esc_html_e('Text Content','wpbooked'); ?></small>
													<textarea name="plain-text-content"></textarea>
													<small class="help-text"><?php esc_html_e('HTML allowed','wpbooked'); ?></small>
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>

												<li id="wpbookedCFTemplate-single-checkbox" class="ui-state-default "><i class="sub-handle fa-solid fa-bars"></i>
													<?php do_action('wpbooked_before_custom_checkbox'); ?>
													<input type="text" name="single-checkbox" value="" placeholder="<?php esc_html_e('Enter a label for this checkbox...','wpbooked'); ?>" />
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
													<?php do_action('wpbooked_after_custom_checkbox'); ?>
												</li>
												<li id="wpbookedCFTemplate-single-radio-button" class="ui-state-default "><i class="sub-handle fa-solid fa-bars"></i>
													<input type="text" name="single-radio-button" value="" placeholder="<?php esc_html_e('Enter a label for this radio button...','wpbooked'); ?>" />
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>
												<li id="wpbookedCFTemplate-single-drop-down" class="ui-state-default "><i class="sub-handle fa-solid fa-bars"></i>
													<input type="text" name="single-drop-down" value="" placeholder="<?php esc_html_e('Enter a label for this option...','wpbooked'); ?>" />
													<span class="cf-delete"><i class="fa-solid fa-trash-can"></i></span>
												</li>

												<?php do_action('wpbooked_custom_fields_add_template') ?>
											</ul>

										</div>
									</div>

									<input id="wpbooked_custom_fields" name="wpbooked_custom_fields" value="" type="hidden" class="field" style="width:100%;">

									<div class="section-row submit-section WPbookedClearFix" style="padding:0;">
										<input id="wpbooked-cf-saveButton" type="button" class="button button-primary" value="<?php esc_html_e('Save Custom Fields','wpbooked'); ?>">
										<div class="cf-updater savingState"><i class="fa-solid fa-circle-notch fa-spin"></i>&nbsp;&nbsp;<?php esc_html_e('Saving','wpbooked'); ?>...</div>
									</div><!-- /.section-row -->

								</div><!-- /templates -->

							<?php break;

							case 'shortcodes': ?>

								<div id="wpbooked-shortcodes" class="tab-content">

									<div class="section-row" style="margin-bottom:-50px;">
										<div class="section-head">

											<h3><?php echo esc_html__('Display the Default Calendar', 'wpbooked'); ?></h3>
											<p><?php esc_html_e('You can use this shortcode to display the front-end booking calendar. Use the "calendar" attribute to display a specific calendar. Use the "year" and/or "month" attributes to display a specific month and/or year. You can also use the "switcher" variable to add a calendar switcher dropdown above the calendar. Your users can then switch between each calendar you\'ve created.','wpbooked'); ?></p>
											<p><input value="[wpbooked-calendar]" type="text" readonly="readonly" class="field"></p>

										</div>

										<?php

										if (!empty($calendars)):

											?><div class="section-head">
												<h3><?php echo esc_html__('Display a Custom Calendar', 'wpbooked'); ?></h3>
												<p style="margin:0 0 10px;">&nbsp;</p><?php

												foreach($calendars as $calendar):

													?><p style="margin:0 0 10px;"><strong style="font-size:14px;"><?php echo esc_html($calendar->name); ?></strong></p>
													<input value="[wpbooked-calendar calendar=<?php echo esc_html($calendar->term_id); ?>]" readonly="readonly" type="text"class="field"><?php

												endforeach;

											?></div><?php

										endif;

										?>

										<div class="section-head">

											<h3><?php echo esc_html__('Display the Login / Register Form', 'wpbooked'); ?></h3>
											<p><?php esc_html_e("If the Registration tab doesn't show up, be sure to allow registrations from the Settings > General page.","booked"); ?></p>
											<p><input value="[wpbooked-login]" type="text" readonly="readonly" class="field"></p>

										</div>

										<div class="section-head">

											<h3><?php echo esc_html__('Display User Profile', 'wpbooked'); ?></h3>
											<p><?php esc_html_e("You can use this shortcode to display the profile content on any page. If a user is not logged in, they will see the login form instead.","booked"); ?></p>
											<p><input value="[wpbooked-profile]" type="text" readonly="readonly" class="field"></p>

										</div>

										<div class="section-head">

											<h3><?php echo esc_html__("Display User's Appointments", 'wpbooked'); ?></h3>
											<p><?php esc_html_e("You can use this shortcode to display just the currently logged in user's upcoming appointments.","booked"); ?></p>
											<p><input value="[wpbooked-appointments]" type="text" readonly="readonly" class="field"></p>

										</div>

									</div>

								</div>


							<?php break;

							case 'export-appointments': ?>

								<form action="" class="booked-export-form" method="post">

									<div id="wpbooked-export-appointments" class="tab-content">

										<div class="section-row">
											<div class="section-head">
												<h3><?php esc_html_e('Export Appointments','wpbooked'); ?></h3>
												<p><?php esc_html_e('You can export all appointments or specify what you want by choosing from the below options.','wpbooked'); ?></p>
												<br>
												<div class="select-box">
													<label class="wpbooked-color-label" for="appointment_time"><?php esc_html_e('Appointment Dates','wpbooked'); ?>:</label>
													<select name="appointment_time">
														<option value="" selected="selected"><?php esc_html_e('Upcoming & Past','wpbooked'); ?></option>
														<option value="upcoming"><?php esc_html_e('Only Upcoming','wpbooked'); ?></option>
														<option value="past"><?php esc_html_e('Only Past','wpbooked'); ?></option>
													</select>
												</div>

												<br>
												<div class="select-box">
													<label class="wpbooked-color-label" for="appointment_type"><?php esc_html_e('Approved and/or Pending','wpbooked'); ?>:</label>
													<select name="appointment_type">
														<option value="any" selected="selected"><?php esc_html_e('Approved & Pending','wpbooked'); ?></option>
														<option value="publish"><?php esc_html_e('Only Approved','wpbooked'); ?></option>
														<option value="draft"><?php esc_html_e('Only Pending','wpbooked'); ?></option>
													</select>
												</div>

												<?php if (!empty($calendars)): ?>

													<br>
													<div class="select-box">
														<label class="wpbooked-color-label" for="calendar_id"><?php esc_html_e('Calendar','wpbooked'); ?>:</label>
														<select name="calendar_id">
															<option value="" selected="selected"><?php esc_html_e('All Calendars','wpbooked'); ?></option>
															<?php
															foreach($calendars as $calendar):
																?><option value="<?php echo esc_html($calendar->term_id); ?>"><?php echo esc_html($calendar->name); ?></option><?php
															endforeach;
															?>
														</select>
													</div>

												<?php endif; ?>

											</div>
										</div>

										<div class="section-row submit-section" style="padding:0;">
											<p class="submit">
												<button class="button-primary"><i class="fa-solid fa-arrow-up-right-from-square"></i>&nbsp;&nbsp;<?php esc_html_e('Export Appointments to CSV','wpbooked'); ?></button>
											</p>
										</div>

									</div>

									<input type="hidden" name="wpbooked_export_appointments_csv" value="1">

								</form>

							<?php break;

							default:
							echo !empty($tab_data['form']) ? $tab_data['form'] : '';
							break;

						endswitch;

					endif;

				endforeach;

				?>

			</div>

		</div>

	<?php endif; ?>

	</div>
</div>