<?php

global $error,$post;

$booked_current_user = wp_get_current_user();
$profile_username = $booked_current_user->user_login;
$my_id = $booked_current_user->ID;
$my_profile = true;

$user_data = get_user_by( 'id', $booked_current_user->ID );

?><div id="wpbooked-profile-page"<?php if ($my_profile): ?> class="me"<?php endif; ?>><?php

if (empty($user_data)) {

	echo '<h2>' . esc_html__('No profile here!','wpbooked') . '</h2>';
	echo '<p>' . esc_html__('Sorry, this user profile does not exist.','wpbooked') . '</p>';

} else { ?>

	<?php
			
	$user_meta = get_user_meta($user_data->ID);
	$user_url = $user_data->data->user_url;
	$user_desc = $user_meta['description'][0];
	$h3_class = '';
			
	?>

	<div class="wpbooked-profile-header WPbookedClearFix">

		<div class="wpbooked-info">
			<div class="wpbooked-user">
				<div class="wp-wpbooked-user-avatar"><?php echo wp_kses_post(wpbooked_avatar($user_data->ID,50)); ?></div>
				<h3 class="<?php echo esc_attr($h3_class); ?>">
					<?php 
					// translators: %s represents the action to be taken. Example: "user name"
					echo sprintf(esc_html__('Welcome back, %s!','wpbooked'),'<strong>'.esc_html(wpbooked_get_name( $user_data->ID )).'</strong>'); ?>
					<?php if ($my_profile): ?>
						&nbsp;&nbsp;<a class="wpbooked-logout-button" href="<?php echo esc_url(wp_logout_url(get_permalink($post->ID))); ?>" title="<?php esc_html_e('Sign Out','wpbooked'); ?>"><?php esc_html_e('Sign Out','wpbooked'); ?></a>
					<?php endif; ?>
				</h3>
			</div>
		</div>

	</div>

	<ul class="wpbooked-tabs WPbookedClearFix">
		<?php
			$default_tabs = array(
				'appointments' => array(
					'title' => esc_html__('Upcoming Appointments','wpbooked'),
					'fa-icon' => 'calendar-days',
					'class' => false
				),
				'history' => array(
					'title' => esc_html__('Appointment History','wpbooked'),
					'fa-icon' => 'calendar-check',
					'class' => false
				),
				'edit' => array(
					'title' => esc_html__('Edit Profile','wpbooked'),
					'fa-icon' => 'pen-to-square',
					'class' => 'edit-button'
				)
			);
			
			echo esc_html(apply_filters( 'wpbooked_profile_tabs', $default_tabs ));
		
		?>
	</ul>

	<?php $appointment_default_status = get_option('wpbooked_new_appointment_default','draft');

	if ( is_user_logged_in() && $my_profile ) : ?>
	
		<?php echo esc_html(apply_filters( 'wpbooked_profile_tab_content',$default_tabs )); ?>

	<?php endif; ?>

<?php } ?>

</div>