<?php

add_action('widgets_init', 'wpbooked_register_widgets');

function wpbooked_register_widgets()
{
	register_widget('WPBooked_Calendar_Widget');
}

class WPBooked_Calendar_Widget extends WP_Widget
{

	public function __construct()
	{
		$widget_ops = array(
			'classname' => 'wpbooked_calendar',
			'description' => 'The Booked Calendar Widget',
		);
		parent::__construct('wpbooked_calendar', esc_html__('Booked Calendar', 'wpbooked'), $widget_ops);
	}

	function form($instance)
	{

		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$calendar = isset($instance['wpbooked_calendar_chooser']) ? $instance['wpbooked_calendar_chooser'] : 0;
		$month = isset($instance['wpbooked_calendar_month']) ? $instance['wpbooked_calendar_month'] : 0;
		$year = isset($instance['wpbooked_calendar_year']) ? $instance['wpbooked_calendar_year'] : 0;

		$args = array(
			'taxonomy'			=> 'wpbooked_custom_calendars',
			'show_option_none' 	=> 'Default',
			'option_none_value'	=> 0,
			'hide_empty'		=> 0,
			'echo'				=> 0,
			'orderby'			=> 'name',
			'id'				=> $this->get_field_id('wpbooked_calendar_chooser'),
			'name'				=> $this->get_field_name('wpbooked_calendar_chooser'),
			'selected'			=> $calendar
		);


		if (!get_option('wpbooked_hide_default_calendar')) : $args['show_option_all'] = esc_html__('Default Calendar', 'wpbooked');
		endif;

?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Widget Title', 'wpbooked'); ?>:</label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>

		<p class="wpbooked-widget-col-13">
			<label><?php esc_html_e('Calendar to Display', 'wpbooked'); ?>:</label><br>
			<?php echo wp_kses(str_replace("\n", '', wp_dropdown_categories($args)), array(
				'select' => array(),
				'option' => array(
					'value' => array(),
					'selected' => array(),
				)
			)); ?>
		</p>

		<?php $current_month = 0; ?>

		<p class="wpbooked-widget-col-13">
			<label><?php esc_html_e('Month', 'wpbooked'); ?>:</label><br>
			<select name="<?php echo esc_html($this->get_field_name('wpbooked_calendar_month')); ?>">
				<?php do {
					echo '<option value="' . esc_attr($current_month) . '"' . esc_html($month == $current_month ? ' selected' : '') . '>' . esc_html(!$current_month ? esc_html__('Current month') : date_i18n('F', strtotime('2016-' . $current_month . '-01'))) . '</option>';
					$current_month++;
				} while ($current_month <= 12); ?>
			</select>
		</p>

		<?php $current_year = date_i18n('Y');
		$highest_year = $current_year + 25; ?>

		<p class="wpbooked-widget-col-13">
			<label><?php esc_html_e('Year', 'wpbooked'); ?>:</label><br>
			<select name="<?php echo esc_attr($this->get_field_name('wpbooked_calendar_year')); ?>">
				<option value="0" <?php if (!$year) : ?> selected<?php endif; ?>><?php esc_html_e('Current year'); ?></option>
				<?php do {
					echo '<option value="' . esc_attr($current_year) . '"' . esc_html($year == $current_year ? ' selected' : '') . '>' . esc_html($current_year) . '</option>';
					$current_year++;
				} while ($current_year <= $highest_year); ?>
			</select>
		</p>

<?php
	}

	function widget($args, $instance)
	{

		extract($args);

		// these are our widget options
		$widget_title = isset($instance['title']) ? $instance['title'] : false;
		$title = apply_filters('widget_title', $widget_title);
		$calendar = isset($instance['wpbooked_calendar_chooser']) ? $instance['wpbooked_calendar_chooser'] : false;
		$month = isset($instance['wpbooked_calendar_month']) ? $instance['wpbooked_calendar_month'] : false;
		$year = isset($instance['wpbooked_calendar_year']) ? $instance['wpbooked_calendar_year'] : false;

		echo wp_kses($before_widget,'post');

		if ($title) {
			echo wp_kses($before_title . $title . $after_title,'post');
		}

		echo do_shortcode('[wpbooked-calendar size="small"' . ($calendar ? ' calendar="' . $calendar . '"' : '') . ($month ? ' month="' . $month . '"' : '') . ($year ? ' year="' . $year . '"' : '') . ']');

		echo wp_kses_post( $after_widget );
	}

	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['wpbooked_calendar_month'] = $new_instance['wpbooked_calendar_month'];
		$instance['wpbooked_calendar_year'] = $new_instance['wpbooked_calendar_year'];
		$instance['wpbooked_calendar_chooser'] = $new_instance['wpbooked_calendar_chooser'];
		return $instance;
	}
}
