<?php


if ( ! class_exists( 'WPBOOKED_Plugin_Migration' ) ) {
    class WPBOOKED_Plugin_Migration {
        public static function pluginsLoaded(){
            if( class_exists('booked_plugin') ){
                if( get_option( 'wpbooked_old_plugin_migration', false ) !== 'yes' ){
                    add_action( 'admin_notices', array( self::class, 'migrationAdminNotice' ) );
                    add_filter( 'wpbooked_settings_tabs', array( self::class, 'addMigrationTab' ) );
                    add_action('wp_ajax_wpbooked_migrate_old_plugin', array( self::class, 'migrateOldPlugin' ) );
                }else if(isset($_GET['migration_done']) && $_GET['migration_done'] === 'yes' ){
                    add_action( 'admin_notices', array( self::class, 'migrationSuccessAdminNotice' ) );
                }
            }
        }
    
        public static function migrationAdminNotice() {
            ?>
            <div class='notice notice-info'>
                <p>
                    <?php echo esc_html__( 'Migrate booked plugin data to WP Booked plugin.', 'wpbooked' ) ?>
                </p>
                <p>
                    <a href='<?php echo esc_url(admin_url('admin.php?page=wpbooked-settings#migration')); ?>' class='button button-primary' target="_blank">
                        <?php echo esc_html__( 'Migrate Now', 'wpbooked' ) ?>
                    </a>
                </p>
            </div>
            <?php
        }
    
        public static function migrationSuccessAdminNotice() {
            ?>
            <div class='notice notice-success'>
                <p>
                    <?php echo esc_html__( 'The migration from Booked plugin data to WP Booked plugin was successful.', 'wpbooked' ) ?>
                </p>
            </div>
            <?php
        }

        public static function addMigrationTab( $booked_settings_tabs ){
            
            $migration_tab_data = array(
                'access' => 'admin',
                'slug' => 'migration',
                'content' => "",
                'form' => ""
            );
    
            ob_start();
            ?>
            <i class='fa-solid fa-code'></i>
            <span class='wpbooked-tab-text'>
                &nbsp;&nbsp;<?php echo esc_html__('Migration','wpbooked'); ?>
            </span>
            <?php
            $migration_tab_data['content'] = ob_get_clean();
            ob_start();
            ?>
            <div id="wpbooked-migration" class="tab-content">
                <div class="section-row" style="margin-bottom:-50px;">    
                    <div class="section-head">
                        <h3>
                            <?php echo esc_html__("Booked Plugin Data Migration", "wpbooked"); ?>
                        </h3>
                        <p>
                            <strong>
                                <?php echo esc_html__("Before proceeding with the migration, please ensure you have taken a backup of your database.", "wpbooked"); ?>
                            </strong>
                        </p>
                        <label for="wpbooked_migrate_checkbox">
                            <input type="checkbox" id="wpbooked_migrate_checkbox" checked>
                            <?php echo esc_html__("Replace WPBooked settings data with Booked plugin data", "wpbooked"); ?>
                        </label>
                        <br>
                        <br>
                        <button id="wpbooked_migrate_button" class="button button-primary">
                            <?php echo esc_html__("Start Migration", "wpbooked"); ?>
                        </button>
                        <p id="wpbooked_migrate_error" style="color:red;"></p>
                    </div>
                </div>
            </div>
            <script>
                jQuery(document).ready(function($) {
                    $('#wpbooked_migrate_button').on('click', function() {
                        // Ask for confirmation
                        if (confirm('<?php echo esc_html__("Are you sure you want to migrate the Booked plugin data? This action cannot be undone.","wpbooked"); ?>')) {
                            // Disable the button and change text to "Migrating..."
                            $(this).prop('disabled', true).text('<?php echo esc_html__( "Migrating...","wpbooked"); ?>');
                            // Initiate AJAX request
                            $.ajax({
                                type: 'POST',
                                url: '<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>', // WordPress AJAX URL
                                data: {
                                    action: 'wpbooked_migrate_old_plugin', // AJAX action name
                                    _nonce: '<?php echo sanitize_key( wp_create_nonce( 'wpbooked_migrate_old_plugin' ) ); ?>',
                                    update_setting:  $('#wpbooked_migrate_checkbox').prop('checked') ? 'yes' : 'no'
                                },
                                success: (response) => {
                                    // Restore button state after AJAX call is completed
                                    $(this).prop('disabled', false).text('<?php echo esc_html__("Start Migration","wpbooked"); ?>');
                                    if(response.status && response.status === true){
                                        window.location.href = '<?php echo esc_url_raw(admin_url('admin.php?page=wpbooked-settings&migration_done=yes')); ?>';
                                    }else{
                                        $('#wpbooked_migrate_error').html(response.message);
                                    }
                                },
                                error: (xhr, status, error) => {
                                    // Restore button state after AJAX call is completed
                                    $(this).prop('disabled', false).text('<?php echo esc_html__("Start Migration'","wpbooked"); ?>');
                                    console.error(xhr, status, error);
                                }
                            });
                        }
                    });
                });

            </script>
            <?php
            $migration_tab_data['form'] = ob_get_clean();
            $booked_settings_tabs[] = $migration_tab_data;
            return $booked_settings_tabs;
        }

        public static function migrateOldPlugin() {
            // Check if current user is administrator
            if (!current_user_can('administrator')) {
                wp_send_json(array(
                    "status" => false,
                    "message" => esc_html__("You don't have permission to perform this action.", "wpbooked")
                ));
            }
        
            // Verify nonce for security
            if (!wp_verify_nonce((isset($_POST['_nonce']) ? $_POST['_nonce'] : ''), 'wpbooked_migrate_old_plugin')) {
                wp_send_json(array(
                    "status" => false,
                    "message" => esc_html__("Security error. Please refresh the page and try again.", "wpbooked")
                ));
            }
        
            // Get old migration data
            $old_migration_data = get_option('wpbooked_migration_status_data', false);
            $old_migration_data = !empty($old_migration_data) && is_array($old_migration_data) ? $old_migration_data : array();        
            global $wpdb;
            $options_table = $wpdb->prefix . 'options';
            $post_table = $wpdb->prefix . 'posts';
            $postmeta_table = $wpdb->prefix . 'postmeta';
        
            // Settings migration
            if (empty($old_migration_data['setting_migration']) || $old_migration_data['setting_migration'] !== 'yes') {
                //Replace WPBooked settings data with Booked plugin data
                $replace_setting = isset( $_POST['update_setting'] ) && $_POST['update_setting'] === 'yes' ; 
                // Construct SQL query to retrieve only required options
                $get_booked_plugin_setting = $wpdb->get_results("
                    SELECT *
                        FROM {$options_table}
                    WHERE
                        option_name LIKE '%booked_%' 
                            AND 
                        option_name NOT LIKE '%wpbooked_%'"
                    );
                foreach ($get_booked_plugin_setting as $setting) {
                    if(in_array($setting->option_name, array(
                        'booked_welcome_screen',
                        'booked_demo_mode'
                    ))){
                        continue;
                    }
                    $new_option_name = str_replace('booked_', 'wpbooked_', $setting->option_name);
                    // If $replace_setting is true or the WPBooked option doesn't exist, update the option
                    if ($replace_setting || !get_option($new_option_name)) {
                        delete_option($new_option_name);
                        $wpdb->query("
                            UPDATE {$options_table}
                            SET option_name = '{$new_option_name}',
                                option_value = REPLACE(option_value, 'booked_', 'wpbooked_')
                            WHERE option_name = '{$setting->option_name}';
                        ");
                    }
                }
            }

            $old_migration_data['setting_migration'] = 'yes';
            $setting_migrate = true;
        
            // Appointment migration
            if (empty($old_migration_data['appointment_migration']) || $old_migration_data['appointment_migration'] !== 'yes') {
                $appointment_migrate = $wpdb->query("
                    UPDATE {$post_table}
                    SET
                        post_type = CASE
                            WHEN post_type = 'booked_appointments' THEN 'wpbooked_apts'
                            ELSE post_type
                        END,
                        post_status = CASE
                            WHEN post_status = 'booked_wc_awaiting' THEN 'wpbooked_wc_awaiting'
                            ELSE post_status
                        END
                    WHERE
                        post_type = 'booked_appointments'
                        OR post_status = 'booked_wc_awaiting'
                ");
                $old_migration_data['appointment_migration'] = $appointment_migrate !== false ? 'yes' : 'no';
            } else {
                $old_migration_data['appointment_migration'] = 'yes';
                $appointment_migrate = true;
            }
        
            // Appointment and product meta migration
            if (empty($old_migration_data['apt_and_product_migrate']) || $old_migration_data['apt_and_product_migrate'] !== 'yes') {
                $apt_and_product_migrate = $wpdb->query("
                    UPDATE {$postmeta_table}
                    SET meta_key = 
                        CASE
                            WHEN meta_key = '_booked_wc_cfield_' THEN '_wpbooked_wc_cfield_'
                            WHEN meta_key = '_booked_wc_appointment_order_id' THEN '_wpbooked_wc_appointment_order_id'
                            WHEN meta_key = '_booked_wc_order_appointments' THEN '_wpbooked_wc_order_appointments'
                            WHEN meta_key = '_booked_wc_time_created' THEN '_wpbooked_wc_time_created'
                            WHEN meta_key = '_booked_wc_date_created' THEN '_wpbooked_wc_date_created'
                            WHEN meta_key = '_booked_appointment' THEN '_wpbooked_appointment'
                            ELSE meta_key
                        END
                    WHERE 
                        meta_key IN ('_booked_wc_cfield_', '_booked_wc_appointment_order_id', '_booked_wc_order_appointments',
                        '_booked_wc_time_created', '_booked_wc_date_created', '_booked_appointment')
                ");
                $old_migration_data['apt_and_product_migrate'] = $apt_and_product_migrate !== false ? 'yes' : 'no';
            } else {
                $old_migration_data['setting_migration'] = 'yes';
                $apt_and_product_migrate = true;
            }

            if(empty($old_migration_data['calendar_migration']) || $old_migration_data['calendar_migration'] !== 'yes'){
                // Step 1: Update the taxonomy name in the database
                $taxonomy_table = $wpdb->prefix . 'term_taxonomy';
                $wpdb->update(
                    $taxonomy_table,
                    array('taxonomy' => 'wpbooked_custom_calendars'),
                    array('taxonomy' => 'booked_custom_calendars')
                );
                // Step 2: Update post metadata associated with the taxonomy
                $meta_table = $wpdb->prefix . 'term_relationships';

                // Get post IDs associated with the old taxonomy term
                $post_ids = $wpdb->get_col("
                    SELECT object_id
                    FROM {$meta_table}
                    WHERE term_taxonomy_id IN (
                        SELECT term_taxonomy_id
                        FROM {$taxonomy_table}
                        WHERE taxonomy = 'booked_custom_calendars'
                    )
                ");
                // Update post metadata to reflect the new taxonomy term
                foreach ($post_ids as $post_id) {
                    wp_set_object_terms($post_id, 'wpbooked_custom_calendars', 'wpbooked_custom_calendars', true);
                }
                $old_migration_data['calendar_migration'] = 'yes';
            }else{
                $old_migration_data['calendar_migration'] = 'yes';
                $appointment_migrate = true;
            }

            // Role migration
            if (empty($old_migration_data['role_migration']) || $old_migration_data['role_migration'] !== 'yes') {
                $old_plugin_role = get_users(array('role__in' => array('booked_booking_agent')));
                foreach ($old_plugin_role as $user) {
                    $user->remove_role('booked_booking_agent');
                    $user->add_role('wpbooked_booking_agent');
                };
                $old_migration_data['role_migration'] = 'yes';
            }
        
            // Update old migration status data
            update_option('wpbooked_migration_status_data', $old_migration_data);
            

            // Check if all queries executed successfully
            if ($setting_migrate !== false && $appointment_migrate !== false && $apt_and_product_migrate !== false) {
                // If successful, update plugin migration status and send success response
                update_option('wpbooked_old_plugin_migration', 'yes');
                wp_send_json(array(
                    'status' => true,
                    'message' => esc_html__("Migration completed successfully.", "wpbooked")
                ));
            } else {
                // If any query failed, send error message along with details
                wp_send_json(array(
                    'status' => false,
                    'message' => esc_html__('Failed to migrate data. Please contact the plugin author for assistance.', 'wpbooked'),
                    'failed' => $old_migration_data
                ));
            }
        }

        public static function style(){
            ?>
            <style>
                .entryBlock.wpbooked-loading .spinner {
                    visibility: visible;
                }
            </style>
            <?php
        }

        public static function redirectWelcomeScreen(){
            if(isset($_GET['page']) && $_GET['page'] === 'booked-welcome' ){
                wp_redirect( admin_url('admin.php?page=wpbooked-settings') );
                die;
            }
        }
        
    }
    add_action( 'admin_menu', array('WPBOOKED_Plugin_Migration','redirectWelcomeScreen'), 1 );
    add_action( 'wp_head', array('WPBOOKED_Plugin_Migration','style') );
    add_action( 'admin_head', array('WPBOOKED_Plugin_Migration','style') );
    add_action( 'plugins_loaded', array( 'WPBOOKED_Plugin_Migration', 'pluginsLoaded' ) );
    
}
