<?php

class WPBooked_WC {

	private function __construct() {
		if ( $this->check_plugin_dependencies() ) {

			$this->setup_woocommerce_support();
			$this->setup_booked_custom_fields();
			$this->enqueue_scripts();
			$this->wp_ajax();
			$this->filters_and_actions();
			$this->add_new_post_status();
			$this->add_options_pages();
			$this->setup_wp_cron();

		}
	}

	public static function setup() {
		return new self();
	}

	protected function check_plugin_dependencies() {
		return class_exists('woocommerce');
	}

	protected function filters_and_actions() {

		# ------------------
		# Filters
		# ------------------

		add_filter('wpbooked_mailer_actions', array('WPBooked_WC_Functions', 'wpbooked_wc_mailer_actions'), 10, 1 );
		add_filter('wpbooked_prepare_sending_reminder', array('WPBooked_WC_Functions', 'wpbooked_prepare_sending_reminder'), 10, 2);
		add_filter('wpbooked_custom_field_data', array('WPBooked_WC_Functions', 'wpbooked_custom_field_data'), 10, 1);
		add_filter('wpbooked_appointments_array', array('WPBooked_WC_Functions', 'wpbooked_appointments_array'), 10, 1);
		add_filter('wpbooked_button_book_appointment', array('WPBooked_WC_Functions', 'wpbooked_button_book_appointment'), 10, 1);
		add_filter('wpbooked_shortcode_appointments_allow_cancel', array('WPBooked_WC_Functions', 'wpbooked_shortcode_appointments_allow_cancel'), 10, 2);
		add_filter('wpbooked_admin_pending_post_status',array('WPBooked_WC_Functions', 'wpbooked_admin_pending_post_status'), 10, 2);
		add_filter('wpbooked_fea_shortcode_appointments_buttons', array('WPBooked_WC_Functions', 'wpbooked_fea_shortcode_appointments_buttons'), 10, 2);
		add_filter('woocommerce_cart_item_name', array('WPBooked_WC_Cart_Hooks', 'woocommerce_cart_item_name'), 10, 3);
		add_filter('woocommerce_cart_item_permalink', array('WPBooked_WC_Cart_Hooks', 'woocommerce_cart_item_permalink'), 10, 3);
		add_filter('woocommerce_cart_item_thumbnail', array('WPBooked_WC_Cart_Hooks', 'woocommerce_cart_item_thumbnail'), 10, 2 );
		add_filter('woocommerce_checkout_cart_item_quantity', array('WPBooked_WC_Cart_Hooks', 'woocommerce_checkout_cart_item_quantity'), 10, 3 );
		add_filter('woocommerce_order_item_name', array('WPBooked_WC_Order_Item_Hooks', 'woocommerce_order_item_name'), 10, 2);
		add_filter('woocommerce_attribute_label', array('WPBooked_WC_Order_Item_Hooks', 'woocommerce_attribute_label'), 10, 3);
		add_filter('woocommerce_hidden_order_itemmeta', array('WPBooked_WC_Order_Hooks', 'woocommerce_hidden_order_itemmeta'), 10);
		add_filter('woocommerce_order_items_meta_display', array('WPBooked_WC_Order_Hooks', 'woocommerce_order_items_meta_display'), 10, 2);
		add_filter('woocommerce_checkout_fields', array('WPBooked_WC_Cart_Hooks', 'woocommerce_checkout_fields'), 10, 1 );

		# ------------------
		# Actions
		# ------------------

		add_action('wp_loaded', array('WPBooked_WC_Cart_Hooks', 'woocommerce_remove_missing_appointment_products'), 10, 1);
		add_action('woocommerce_resume_order', array('WPBooked_WC_Order_Hooks', 'woocommerce_validate_order_items'), 10, 1);
		add_action('woocommerce_new_order', array('WPBooked_WC_Order_Hooks', 'woocommerce_validate_order_items'), 10, 1);
		add_action('wp_ajax_wpbooked_new_appointment_form', array('WPBooked_WC_Functions', 'wpbooked_new_appointment_form'), 5);
		add_action('wp_ajax_nopriv_wpbooked_new_appointment_form', array('WPBooked_WC_Functions', 'wpbooked_new_appointment_form'), 5);
		add_action('wpbooked_new_appointment_created', array('WPBooked_WC_Functions', 'wpbooked_new_appointment_created'), 15, 1);
		add_action('wpbooked_new_appointment_created', array('WPBooked_WC_Functions', 'wpbooked_store_appointment_creation_date'), 10, 1);
		add_action('wpbooked_before_creating_appointment', array('WPBooked_WC_Functions', 'remove_default_emails'), 1);
		add_action('wpbooked_before_creating_appointment', array('WPBooked_WC_Functions', 'wpbooked_before_creating_appointment'), 10);

		// On Order Complete
		add_action('woocommerce_order_status_completed', array('WPBooked_WC_Order_Hooks', 'woocommerce_order_complete'), 10, 1);

		// Trash the appointment on order cancel, refunded or deleted
		add_action('woocommerce_order_status_cancelled', array('WPBooked_WC_Order_Hooks', 'woocommerce_order_remove_appointment'), 10, 1);
		add_action('woocommerce_order_status_refunded', array('WPBooked_WC_Order_Hooks', 'woocommerce_order_remove_appointment'), 10, 1);
		add_action('woocommerce_order_status_trash', array('WPBooked_WC_Order_Hooks', 'woocommerce_order_remove_appointment'), 10, 1);
		add_action('before_delete_post', array('WPBooked_WC_Order_Hooks', 'woocommerce_order_remove_appointment'), 10, 1);

		add_action('wpbooked_admin_calendar_buttons_after', array('WPBooked_WC_Functions', 'wpbooked_admin_calendar_buttons_after'), 10, 3);
		add_action('wpbooked_admin_calendar_buttons_before', array('WPBooked_WC_Functions', 'wpbooked_admin_calendar_buttons_before'), 10, 3);
		add_action('wpbooked_shortcode_appointments_buttons', array('WPBooked_WC_Functions', 'wpbooked_shortcode_appointments_buttons'), 10, 1);
		add_action('wpbooked_shortcode_appointments_additional_information', array('WPBooked_WC_Functions', 'wpbooked_shortcode_appointments_additional_information'), 10, 1);
		add_action('woocommerce_add_order_item_meta', array('WPBooked_WC_Order_Hooks', 'woocommerce_add_order_item_meta'), 10, 4);

	}

	protected function setup_woocommerce_support() {
		WPBooked_WC_Main::setup();
	}

	protected function setup_booked_custom_fields() {
		WPBooked_WC_Custom_Fields::setup();
	}

	protected function enqueue_scripts() {
		WPBooked_WC_EnqueueScript::enqueue();
	}

	protected function wp_ajax() {
		WPBooked_WC_Ajax::setup();
	}

	protected function add_new_post_status() {
		WPBooked_WC_Post_Status::setup();
	}

	protected function add_options_pages() {
		WPBooked_WC_Settings::setup();
	}

	protected function setup_wp_cron() {
		WPBooked_WC_WP_Crons::setup();
	}
}
